/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.meter.micrometer;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.FunctionTimer;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Statistic;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.instrument.cumulative.CumulativeFunctionCounter;
import io.micrometer.core.instrument.cumulative.CumulativeFunctionTimer;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import io.micrometer.core.instrument.distribution.pause.PauseDetector;
import io.micrometer.core.instrument.internal.DefaultGauge;
import io.micrometer.core.instrument.internal.DefaultMeter;
import java.util.concurrent.TimeUnit;
import java.util.function.ToDoubleFunction;
import java.util.function.ToLongFunction;
import org.apache.skywalking.apm.meter.micrometer.MeterBuilder;
import org.apache.skywalking.apm.meter.micrometer.SkywalkingConfig;
import org.apache.skywalking.apm.meter.micrometer.SkywalkingCounter;
import org.apache.skywalking.apm.meter.micrometer.SkywalkingCustomCounter;
import org.apache.skywalking.apm.meter.micrometer.SkywalkingDistributionSummary;
import org.apache.skywalking.apm.meter.micrometer.SkywalkingLongTaskTimer;
import org.apache.skywalking.apm.meter.micrometer.SkywalkingTimer;
import org.apache.skywalking.apm.toolkit.meter.MeterCenter;
import org.apache.skywalking.apm.toolkit.meter.MeterFactory;
import org.apache.skywalking.apm.toolkit.meter.MeterId;

public class SkywalkingMeterRegistry
extends MeterRegistry {
    private final SkywalkingConfig config;

    public SkywalkingMeterRegistry() {
        this(SkywalkingConfig.DEFAULT, Clock.SYSTEM);
    }

    public SkywalkingMeterRegistry(SkywalkingConfig config) {
        this(config, Clock.SYSTEM);
    }

    public SkywalkingMeterRegistry(Clock clock) {
        this(SkywalkingConfig.DEFAULT, clock);
    }

    public SkywalkingMeterRegistry(SkywalkingConfig config, Clock clock) {
        super(clock);
        this.config = config;
        this.config().namingConvention(NamingConvention.snakeCase);
        this.config().onMeterRemoved(this::onMeterRemoved);
    }

    protected <T> Gauge newGauge(Meter.Id id, T obj, ToDoubleFunction<T> valueFunction) {
        MeterId meterId = this.convertId(id);
        MeterFactory.gauge(meterId, () -> valueFunction.applyAsDouble(obj)).build();
        return new DefaultGauge(id, obj, valueFunction);
    }

    protected Counter newCounter(Meter.Id id) {
        MeterId meterId = this.convertId(id);
        return new SkywalkingCounter(id, MeterBuilder.buildCounter(meterId, this.config));
    }

    protected LongTaskTimer newLongTaskTimer(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig) {
        MeterId meterId = this.convertId(id);
        return new SkywalkingLongTaskTimer(id, meterId, this.clock, TimeUnit.MILLISECONDS, distributionStatisticConfig, true);
    }

    protected Timer newTimer(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig, PauseDetector pauseDetector) {
        MeterId meterId = this.convertId(id);
        return new SkywalkingTimer(id, meterId, this.config, this.clock, distributionStatisticConfig, pauseDetector, TimeUnit.MILLISECONDS, true);
    }

    protected DistributionSummary newDistributionSummary(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig, double scale) {
        MeterId meterId = this.convertId(id);
        return new SkywalkingDistributionSummary(id, meterId, this.config, this.clock, distributionStatisticConfig, scale, true);
    }

    protected Meter newMeter(Meter.Id id, Meter.Type type, Iterable<Measurement> measurements) {
        MeterId meterId = this.convertId(id);
        String baseName = meterId.getName();
        measurements.forEach(m -> {
            String meterName = baseName;
            boolean isCounter = false;
            switch (m.getStatistic()) {
                case TOTAL: 
                case TOTAL_TIME: {
                    meterName = baseName + "_sum";
                    isCounter = true;
                    break;
                }
                case COUNT: {
                    isCounter = true;
                    break;
                }
                case MAX: {
                    meterName = baseName + "_max";
                    break;
                }
                case ACTIVE_TASKS: {
                    meterName = baseName + "_active_count";
                    break;
                }
                case DURATION: {
                    meterName = baseName + "_duration_sum";
                    break;
                }
            }
            if (isCounter) {
                new SkywalkingCustomCounter.Builder(meterId.copyTo(meterName, MeterId.MeterType.COUNTER), (Measurement)m, this.config).build();
            } else {
                MeterFactory.gauge(meterId.copyTo(meterName, MeterId.MeterType.GAUGE), () -> m.getValue()).build();
            }
        });
        return new DefaultMeter(id, type, measurements);
    }

    protected <T> FunctionTimer newFunctionTimer(Meter.Id id, T obj, ToLongFunction<T> countFunction, ToDoubleFunction<T> totalTimeFunction, TimeUnit totalTimeFunctionUnit) {
        MeterId meterId = this.convertId(id);
        CumulativeFunctionTimer ft = new CumulativeFunctionTimer(id, obj, countFunction, totalTimeFunction, totalTimeFunctionUnit, this.getBaseTimeUnit());
        String baseName = meterId.getName();
        MeterFactory.gauge(meterId.copyTo(baseName + "_count", MeterId.MeterType.GAUGE), () -> SkywalkingMeterRegistry.lambda$newFunctionTimer$3((FunctionTimer)ft)).build();
        MeterFactory.gauge(meterId.copyTo(baseName + "_sum", MeterId.MeterType.GAUGE), () -> SkywalkingMeterRegistry.lambda$newFunctionTimer$4((FunctionTimer)ft)).build();
        return ft;
    }

    protected <T> FunctionCounter newFunctionCounter(Meter.Id id, T obj, ToDoubleFunction<T> countFunction) {
        MeterId meterId = this.convertId(id);
        CumulativeFunctionCounter fc = new CumulativeFunctionCounter(id, obj, countFunction);
        new SkywalkingCustomCounter.Builder(meterId, new Measurement(() -> countFunction.applyAsDouble(obj), Statistic.COUNT), this.config).build();
        return fc;
    }

    protected TimeUnit getBaseTimeUnit() {
        return TimeUnit.MILLISECONDS;
    }

    protected DistributionStatisticConfig defaultHistogramConfig() {
        return DistributionStatisticConfig.DEFAULT;
    }

    private void onMeterRemoved(Meter meter) {
        MeterId meterId = this.convertId(meter.getId());
        MeterCenter.removeMeter(meterId);
    }

    private MeterId convertId(Meter.Id id) {
        return MeterBuilder.convertId(id, this.getConventionName(id));
    }

    private static /* synthetic */ Double lambda$newFunctionTimer$4(FunctionTimer ft) {
        return ft.totalTime(TimeUnit.MILLISECONDS);
    }

    private static /* synthetic */ Double lambda$newFunctionTimer$3(FunctionTimer ft) {
        return ft.count();
    }
}

