/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.bootstrap;

import com.alipay.sofa.rpc.bootstrap.ProviderBootstrap;
import com.alipay.sofa.rpc.codec.AbstractSerializer;
import com.alipay.sofa.rpc.common.struct.NamedThreadFactory;
import com.alipay.sofa.rpc.common.utils.CommonUtils;
import com.alipay.sofa.rpc.common.utils.StringUtils;
import com.alipay.sofa.rpc.config.ConfigUniqueNameGenerator;
import com.alipay.sofa.rpc.config.ProviderConfig;
import com.alipay.sofa.rpc.config.RegistryConfig;
import com.alipay.sofa.rpc.config.ServerConfig;
import com.alipay.sofa.rpc.context.RpcRuntimeContext;
import com.alipay.sofa.rpc.core.exception.SofaRpcRuntimeException;
import com.alipay.sofa.rpc.event.EventBus;
import com.alipay.sofa.rpc.event.ProviderProcessorRegisterEvent;
import com.alipay.sofa.rpc.event.ProviderProcessorUnRegistryEvent;
import com.alipay.sofa.rpc.ext.Extension;
import com.alipay.sofa.rpc.invoke.Invoker;
import com.alipay.sofa.rpc.listener.ConfigListener;
import com.alipay.sofa.rpc.log.LogCodes;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import com.alipay.sofa.rpc.registry.Registry;
import com.alipay.sofa.rpc.registry.RegistryFactory;
import com.alipay.sofa.rpc.server.ProviderProxyInvoker;
import com.alipay.sofa.rpc.server.Server;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

@Extension(value="sofa")
public class DefaultProviderBootstrap<T>
extends ProviderBootstrap<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultProviderBootstrap.class);
    protected volatile transient boolean exported;
    protected transient Invoker providerProxyInvoker;
    protected static final ConcurrentMap<String, AtomicInteger> EXPORTED_KEYS = new ConcurrentHashMap<String, AtomicInteger>();
    private final ThreadFactory factory = new NamedThreadFactory("DELAY-EXPORT", true);

    protected DefaultProviderBootstrap(ProviderConfig<T> providerConfig) {
        super(providerConfig);
    }

    @Override
    public void export() {
        if (this.providerConfig.getDelay() > 0) {
            Thread thread = this.factory.newThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(DefaultProviderBootstrap.this.providerConfig.getDelay());
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    DefaultProviderBootstrap.this.doExport();
                }
            });
            thread.start();
        } else {
            this.doExport();
        }
    }

    private void doExport() {
        if (this.exported) {
            return;
        }
        this.checkParameters();
        String appName = this.providerConfig.getAppName();
        ConcurrentHashMap<String, Boolean> hasExportedInCurrent = new ConcurrentHashMap<String, Boolean>();
        List<ServerConfig> serverConfigs = this.providerConfig.getServer();
        for (ServerConfig serverConfig : serverConfigs) {
            AtomicInteger cnt;
            String protocol = serverConfig.getProtocol();
            String key = this.providerConfig.buildKey() + ":" + protocol;
            if (LOGGER.isInfoEnabled(appName)) {
                LOGGER.infoWithApp(appName, "Export provider config : {} with bean id {}", key, this.providerConfig.getId());
            }
            if ((cnt = (AtomicInteger)EXPORTED_KEYS.get(key)) == null) {
                cnt = CommonUtils.putToConcurrentMap(EXPORTED_KEYS, key, new AtomicInteger(0));
            }
            int c = cnt.incrementAndGet();
            hasExportedInCurrent.put(serverConfig.getProtocol(), true);
            int maxProxyCount = this.providerConfig.getRepeatedExportLimit();
            if (maxProxyCount <= 0) continue;
            if (c > maxProxyCount) {
                this.decrementCounter(hasExportedInCurrent);
                throw new SofaRpcRuntimeException(LogCodes.getLog("010000014", key, maxProxyCount));
            }
            if (c <= 1 || !LOGGER.isInfoEnabled(appName)) continue;
            LOGGER.infoWithApp(appName, LogCodes.getLog("010000015", key, c));
        }
        try {
            Object registryConfigs;
            this.providerProxyInvoker = new ProviderProxyInvoker(this.providerConfig);
            this.preProcessProviderTarget(this.providerConfig, (ProviderProxyInvoker)this.providerProxyInvoker);
            if (this.providerConfig.isRegister() && CommonUtils.isNotEmpty((Collection)(registryConfigs = this.providerConfig.getRegistry()))) {
                Iterator iterator = registryConfigs.iterator();
                while (iterator.hasNext()) {
                    RegistryConfig registryConfig = (RegistryConfig)iterator.next();
                    RegistryFactory.getRegistry(registryConfig);
                }
            }
            for (ServerConfig serverConfig : serverConfigs) {
                try {
                    Server server = serverConfig.buildIfAbsent();
                    server.registerProcessor(this.providerConfig, this.providerProxyInvoker);
                    if (EventBus.isEnable(ProviderProcessorRegisterEvent.class)) {
                        EventBus.post(new ProviderProcessorRegisterEvent(this.providerConfig, serverConfig));
                    }
                    if (!serverConfig.isAutoStart()) continue;
                    server.start();
                }
                catch (SofaRpcRuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    LOGGER.errorWithApp(appName, LogCodes.getLog("010000016", serverConfig.getId()), e);
                }
            }
            if (this.providerConfig.getProxyClass().getTypeParameters().length > 0) {
                String serviceName = ConfigUniqueNameGenerator.getUniqueName(this.providerConfig);
                AbstractSerializer.registerGenericService(serviceName, this.providerConfig.getRef().getClass().getName());
            }
            this.providerConfig.setConfigListener(new ProviderAttributeListener());
            this.register();
        }
        catch (Exception e) {
            this.decrementCounter(hasExportedInCurrent);
            if (e instanceof SofaRpcRuntimeException) {
                throw e;
            }
            throw new SofaRpcRuntimeException(LogCodes.getLog("010000017"), e);
        }
        RpcRuntimeContext.cacheProviderConfig(this);
        this.exported = true;
    }

    private void decrementCounter(Map<String, Boolean> hasExportedInCurrent) {
        for (Map.Entry<String, Boolean> entry : hasExportedInCurrent.entrySet()) {
            String protocol = entry.getKey();
            String key = this.providerConfig.buildKey() + ":" + protocol;
            AtomicInteger cnt = (AtomicInteger)EXPORTED_KEYS.get(key);
            if (cnt == null || cnt.get() <= 0) continue;
            cnt.decrementAndGet();
        }
    }

    protected void checkParameters() {
        Class<?> proxyClass = this.providerConfig.getProxyClass();
        String key = this.providerConfig.buildKey();
        Object ref = this.providerConfig.getRef();
        if (!proxyClass.isInstance(ref)) {
            String name = ref == null ? "null" : ref.getClass().getName();
            throw new SofaRpcRuntimeException(LogCodes.getLog("010000018", name, this.providerConfig.getInterfaceId(), key));
        }
        if (CommonUtils.isEmpty(this.providerConfig.getServer())) {
            throw new SofaRpcRuntimeException(LogCodes.getLog("010000019", key));
        }
        this.checkMethods(proxyClass);
    }

    protected void checkMethods(Class<?> itfClass) {
        ConcurrentHashMap<String, Boolean> methodsLimit = new ConcurrentHashMap<String, Boolean>();
        for (Method method : itfClass.getMethods()) {
            Boolean include;
            String methodName = method.getName();
            if (methodsLimit.containsKey(methodName) && LOGGER.isWarnEnabled(this.providerConfig.getAppName())) {
                LOGGER.warnWithApp(this.providerConfig.getAppName(), "Method with same name \"" + itfClass.getName() + "." + methodName + "\" exists ! The usage of overloading method in rpc is deprecated.");
            }
            if ((include = methodsLimit.get(methodName)) != null) continue;
            include = this.inList(this.providerConfig.getInclude(), this.providerConfig.getExclude(), methodName);
            methodsLimit.putIfAbsent(methodName, include);
        }
        this.providerConfig.setMethodsLimit(methodsLimit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unExport() {
        if (!this.exported) {
            return;
        }
        DefaultProviderBootstrap defaultProviderBootstrap = this;
        synchronized (defaultProviderBootstrap) {
            String key;
            String protocol;
            if (!this.exported) {
                return;
            }
            String appName = this.providerConfig.getAppName();
            List<ServerConfig> serverConfigs = this.providerConfig.getServer();
            for (ServerConfig serverConfig : serverConfigs) {
                protocol = serverConfig.getProtocol();
                key = this.providerConfig.buildKey() + ":" + protocol;
                if (!LOGGER.isInfoEnabled(appName)) continue;
                LOGGER.infoWithApp(appName, "Unexport provider config : {} {}", key, this.providerConfig.getId() != null ? "with bean id " + this.providerConfig.getId() : "");
            }
            this.unregister();
            this.providerProxyInvoker = null;
            if (serverConfigs != null) {
                for (ServerConfig serverConfig : serverConfigs) {
                    Server server = serverConfig.getServer();
                    if (server == null) continue;
                    try {
                        server.unRegisterProcessor(this.providerConfig, serverConfig.isAutoStart());
                        if (!EventBus.isEnable(ProviderProcessorUnRegistryEvent.class)) continue;
                        EventBus.post(new ProviderProcessorUnRegistryEvent(this.providerConfig, serverConfig));
                    }
                    catch (Exception e) {
                        if (!LOGGER.isWarnEnabled(appName)) continue;
                        LOGGER.warnWithApp(appName, "Catch exception when unRegister processor to server: " + serverConfig.getId() + ", but you can ignore if it's called by JVM shutdown hook", e);
                    }
                }
            }
            this.providerConfig.setConfigListener(null);
            for (ServerConfig serverConfig : serverConfigs) {
                protocol = serverConfig.getProtocol();
                key = this.providerConfig.buildKey() + ":" + protocol;
                AtomicInteger cnt = (AtomicInteger)EXPORTED_KEYS.get(key);
                if (cnt == null || cnt.decrementAndGet() > 0) continue;
                EXPORTED_KEYS.remove(key);
            }
            RpcRuntimeContext.invalidateProviderConfig(this);
            this.exported = false;
        }
    }

    protected void register() {
        List<RegistryConfig> registryConfigs;
        if (this.providerConfig.isRegister() && (registryConfigs = this.providerConfig.getRegistry()) != null) {
            for (RegistryConfig registryConfig : registryConfigs) {
                Registry registry = RegistryFactory.getRegistry(registryConfig);
                registry.init();
                registry.start();
                try {
                    registry.register(this.providerConfig);
                }
                catch (SofaRpcRuntimeException e) {
                    throw e;
                }
                catch (Throwable e) {
                    String appName = this.providerConfig.getAppName();
                    if (!LOGGER.isWarnEnabled(appName)) continue;
                    LOGGER.errorWithApp(appName, LogCodes.getLog("010000020", registryConfig.getId()), e);
                }
            }
        }
    }

    protected void unregister() {
        List<RegistryConfig> registryConfigs;
        if (this.providerConfig.isRegister() && (registryConfigs = this.providerConfig.getRegistry()) != null) {
            for (RegistryConfig registryConfig : registryConfigs) {
                Registry registry = RegistryFactory.getRegistry(registryConfig);
                try {
                    registry.unRegister(this.providerConfig);
                }
                catch (Exception e) {
                    String appName = this.providerConfig.getAppName();
                    if (!LOGGER.isWarnEnabled(appName)) continue;
                    LOGGER.warnWithApp(appName, "Catch exception when unRegister from registry: " + registryConfig.getId() + ", but you can ignore if it's called by JVM shutdown hook", e);
                }
            }
        }
    }

    protected boolean inList(String includeMethods, String excludeMethods, String methodName) {
        if (!"*".equals(includeMethods) && !this.inMethodConfigs(includeMethods, methodName)) {
            return false;
        }
        return !this.inMethodConfigs(excludeMethods, methodName);
    }

    private boolean inMethodConfigs(String methodConfigs, String methodName) {
        String[] excludeMethodCollections;
        for (String excludeMethodName : excludeMethodCollections = StringUtils.splitWithCommaOrSemicolon(methodConfigs)) {
            boolean exist = StringUtils.equals(excludeMethodName, methodName);
            if (!exist) continue;
            return true;
        }
        return false;
    }

    protected void preProcessProviderTarget(ProviderConfig providerConfig, ProviderProxyInvoker providerProxyInvoker) {
    }

    private class ProviderAttributeListener
    implements ConfigListener {
        private ProviderAttributeListener() {
        }

        @Override
        public void configChanged(Map newValue) {
        }

        @Override
        public synchronized void attrUpdated(Map newValueMap) {
            String appName = DefaultProviderBootstrap.this.providerConfig.getAppName();
            Map newValues = newValueMap;
            HashMap oldValues = new HashMap();
            boolean reexport = false;
            try {
                for (Map.Entry entry : newValues.entrySet()) {
                    boolean changed;
                    String newValue = (String)entry.getValue();
                    String oldValue = DefaultProviderBootstrap.this.providerConfig.queryAttribute((String)entry.getKey());
                    boolean bl = oldValue == null ? newValue != null : (changed = !oldValue.equals(newValue));
                    if (changed) {
                        oldValues.put(entry.getKey(), oldValue);
                    }
                    reexport = reexport || changed;
                }
            }
            catch (Exception e) {
                LOGGER.errorWithApp(appName, LogCodes.getLog("010000021"), e);
                return;
            }
            if (reexport) {
                try {
                    if (LOGGER.isInfoEnabled(appName)) {
                        LOGGER.infoWithApp(appName, "Reexport service {}", DefaultProviderBootstrap.this.providerConfig.buildKey());
                    }
                    DefaultProviderBootstrap.this.unExport();
                    for (Map.Entry entry : newValues.entrySet()) {
                        DefaultProviderBootstrap.this.providerConfig.updateAttribute((String)entry.getKey(), (String)entry.getValue(), true);
                    }
                    DefaultProviderBootstrap.this.export();
                }
                catch (Exception e) {
                    LOGGER.errorWithApp(appName, LogCodes.getLog("010000022"), e);
                    for (Map.Entry entry : oldValues.entrySet()) {
                        DefaultProviderBootstrap.this.providerConfig.updateAttribute((String)entry.getKey(), (String)entry.getValue(), true);
                    }
                    DefaultProviderBootstrap.this.export();
                }
            }
        }
    }
}

