/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.bootstrap;

import com.alipay.sofa.rpc.bootstrap.ClusterProviderInfoListener;
import com.alipay.sofa.rpc.bootstrap.ConsumerBootstrap;
import com.alipay.sofa.rpc.bootstrap.DefaultClientProxyInvoker;
import com.alipay.sofa.rpc.client.ClientProxyInvoker;
import com.alipay.sofa.rpc.client.Cluster;
import com.alipay.sofa.rpc.client.ClusterFactory;
import com.alipay.sofa.rpc.client.ProviderGroup;
import com.alipay.sofa.rpc.common.SofaConfigs;
import com.alipay.sofa.rpc.common.utils.CommonUtils;
import com.alipay.sofa.rpc.common.utils.StringUtils;
import com.alipay.sofa.rpc.config.ConsumerConfig;
import com.alipay.sofa.rpc.config.RegistryConfig;
import com.alipay.sofa.rpc.context.RpcRuntimeContext;
import com.alipay.sofa.rpc.core.exception.SofaRpcRuntimeException;
import com.alipay.sofa.rpc.dynamic.DynamicConfigManager;
import com.alipay.sofa.rpc.dynamic.DynamicConfigManagerFactory;
import com.alipay.sofa.rpc.ext.Extension;
import com.alipay.sofa.rpc.invoke.Invoker;
import com.alipay.sofa.rpc.listener.ConfigListener;
import com.alipay.sofa.rpc.listener.ProviderInfoListener;
import com.alipay.sofa.rpc.log.LogCodes;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import com.alipay.sofa.rpc.proxy.ProxyFactory;
import com.alipay.sofa.rpc.registry.Registry;
import com.alipay.sofa.rpc.registry.RegistryFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

@Extension(value="sofa")
public class DefaultConsumerBootstrap<T>
extends ConsumerBootstrap<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultConsumerBootstrap.class);
    protected volatile transient T proxyIns;
    protected volatile transient Invoker proxyInvoker;
    protected volatile transient Cluster cluster;
    protected volatile transient CountDownLatch respondRegistries;
    protected static final ConcurrentMap<String, AtomicInteger> REFERRED_KEYS = new ConcurrentHashMap<String, AtomicInteger>();

    protected DefaultConsumerBootstrap(ConsumerConfig<T> consumerConfig) {
        super(consumerConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T refer() {
        if (this.proxyIns != null) {
            return this.proxyIns;
        }
        DefaultConsumerBootstrap defaultConsumerBootstrap = this;
        synchronized (defaultConsumerBootstrap) {
            AtomicInteger cnt;
            if (this.proxyIns != null) {
                return this.proxyIns;
            }
            String key = this.consumerConfig.buildKey();
            String appName = this.consumerConfig.getAppName();
            this.checkParameters();
            if (LOGGER.isInfoEnabled(appName)) {
                LOGGER.infoWithApp(appName, "Refer consumer config : {} with bean id {}", key, this.consumerConfig.getId());
            }
            if ((cnt = (AtomicInteger)REFERRED_KEYS.get(key)) == null) {
                cnt = CommonUtils.putToConcurrentMap(REFERRED_KEYS, key, new AtomicInteger(0));
            }
            int c = cnt.incrementAndGet();
            int maxProxyCount = this.consumerConfig.getRepeatedReferLimit();
            if (maxProxyCount > 0) {
                if (c > maxProxyCount) {
                    cnt.decrementAndGet();
                    throw new SofaRpcRuntimeException(LogCodes.getLog("010010014", key, maxProxyCount));
                }
                if (c > 1 && LOGGER.isInfoEnabled(appName)) {
                    LOGGER.infoWithApp(appName, "Duplicate consumer config with key {} has been referred! Maybe it's wrong config, please check it. Ignore this if you did that on purpose!", key);
                }
            }
            try {
                this.cluster = ClusterFactory.getCluster(this);
                this.consumerConfig.setConfigListener(this.buildConfigListener(this));
                this.consumerConfig.setProviderInfoListener(this.buildProviderInfoListener(this));
                this.cluster.init();
                this.proxyInvoker = this.buildClientProxyInvoker(this);
                this.proxyIns = ProxyFactory.buildProxy(this.consumerConfig.getProxy(), this.consumerConfig.getProxyClass(), this.proxyInvoker);
                String dynamicAlias = this.consumerConfig.getParameter("dynamicAlias");
                if (StringUtils.isNotBlank(dynamicAlias)) {
                    DynamicConfigManager dynamicManager = DynamicConfigManagerFactory.getDynamicManager(this.consumerConfig.getAppName(), dynamicAlias);
                    dynamicManager.initServiceConfiguration(this.consumerConfig.getInterfaceId());
                }
            }
            catch (Exception e) {
                if (this.cluster != null) {
                    this.cluster.destroy();
                    this.cluster = null;
                }
                this.consumerConfig.setConfigListener(null);
                this.consumerConfig.setProviderInfoListener(null);
                cnt.decrementAndGet();
                if (e instanceof SofaRpcRuntimeException) {
                    throw (SofaRpcRuntimeException)e;
                }
                throw new SofaRpcRuntimeException(LogCodes.getLog("010010015"), e);
            }
            if (this.consumerConfig.getOnAvailable() != null && this.cluster != null) {
                this.cluster.checkStateChange(false);
            }
            RpcRuntimeContext.cacheConsumerConfig(this);
            return this.proxyIns;
        }
    }

    protected void checkParameters() {
    }

    protected ConfigListener buildConfigListener(ConsumerBootstrap bootstrap) {
        return new ConsumerAttributeListener();
    }

    protected ProviderInfoListener buildProviderInfoListener(ConsumerBootstrap bootstrap) {
        return new ClusterProviderInfoListener(bootstrap.getCluster());
    }

    protected ClientProxyInvoker buildClientProxyInvoker(ConsumerBootstrap bootstrap) {
        return new DefaultClientProxyInvoker(bootstrap);
    }

    @Override
    public void unRefer() {
        String key;
        block5: {
            if (this.proxyIns == null) {
                return;
            }
            key = this.consumerConfig.buildKey();
            String appName = this.consumerConfig.getAppName();
            if (LOGGER.isInfoEnabled(appName)) {
                LOGGER.infoWithApp(appName, "UnRefer consumer config : {} with bean id {}", key, this.consumerConfig.getId());
            }
            try {
                this.cluster.destroy();
            }
            catch (Exception e) {
                if (!LOGGER.isWarnEnabled(appName)) break block5;
                LOGGER.warnWithApp(appName, "Catch exception when unrefer consumer config : " + key + ", but you can ignore if it's called by JVM shutdown hook", e);
            }
        }
        AtomicInteger cnt = (AtomicInteger)REFERRED_KEYS.get(key);
        if (cnt != null && cnt.decrementAndGet() <= 0) {
            REFERRED_KEYS.remove(key);
        }
        this.consumerConfig.setConfigListener(null);
        this.consumerConfig.setProviderInfoListener(null);
        RpcRuntimeContext.invalidateConsumerConfig(this);
        this.proxyIns = null;
        this.unSubscribe();
    }

    @Override
    public List<ProviderGroup> subscribe() {
        List<Object> registryConfigs;
        List<ProviderGroup> result = null;
        String directUrl = this.consumerConfig.getDirectUrl();
        if (StringUtils.isNotEmpty(directUrl)) {
            registryConfigs = new ArrayList();
            registryConfigs.add(new RegistryConfig().setProtocol("domain"));
            this.consumerConfig.setRegistry(registryConfigs);
        }
        if (CommonUtils.isNotEmpty(registryConfigs = this.consumerConfig.getRegistry())) {
            result = this.subscribeFromRegistries();
        }
        return result;
    }

    @Override
    public boolean isSubscribed() {
        return this.respondRegistries == null || this.respondRegistries.getCount() <= 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ProviderGroup> subscribeFromRegistries() {
        ArrayList<ProviderGroup> result = new ArrayList<ProviderGroup>();
        List<RegistryConfig> registryConfigs = this.consumerConfig.getRegistry();
        if (CommonUtils.isEmpty(registryConfigs)) {
            return result;
        }
        int addressWaitTime = this.consumerConfig.getAddressWait();
        int maxAddressWaitTime = SofaConfigs.getIntegerValue(this.consumerConfig.getAppName(), "rpc_max_address_wait_time", 30000);
        addressWaitTime = addressWaitTime < 0 ? maxAddressWaitTime : Math.min(addressWaitTime, maxAddressWaitTime);
        ProviderInfoListener listener = this.consumerConfig.getProviderInfoListener();
        this.respondRegistries = addressWaitTime == 0 ? null : new CountDownLatch(registryConfigs.size());
        HashMap<String, ProviderGroup> tmpProviderInfoList = new HashMap<String, ProviderGroup>();
        for (RegistryConfig registryConfig : registryConfigs) {
            Registry registry = RegistryFactory.getRegistry(registryConfig);
            registry.init();
            registry.start();
            try {
                List<ProviderGroup> current;
                try {
                    if (this.respondRegistries != null) {
                        this.consumerConfig.setProviderInfoListener(new WrapperClusterProviderInfoListener(listener, this.respondRegistries));
                    }
                    current = registry.subscribe(this.consumerConfig);
                }
                finally {
                    if (this.respondRegistries != null) {
                        this.consumerConfig.setProviderInfoListener(listener);
                    }
                }
                if (current == null) continue;
                if (this.respondRegistries != null) {
                    this.respondRegistries.countDown();
                }
                for (ProviderGroup group : current) {
                    String groupName = group.getName();
                    if (group.isEmpty()) continue;
                    ProviderGroup oldGroup = (ProviderGroup)tmpProviderInfoList.get(groupName);
                    if (oldGroup != null) {
                        oldGroup.addAll(group.getProviderInfos());
                        continue;
                    }
                    tmpProviderInfoList.put(groupName, group);
                }
            }
            catch (SofaRpcRuntimeException e) {
                throw e;
            }
            catch (Throwable e) {
                String appName = this.consumerConfig.getAppName();
                if (!LOGGER.isWarnEnabled(appName)) continue;
                LOGGER.warnWithApp(appName, LogCodes.getLog("010010016", registryConfig.getId()), e);
            }
        }
        if (this.respondRegistries != null) {
            try {
                this.respondRegistries.await(addressWaitTime, TimeUnit.MILLISECONDS);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new ArrayList<ProviderGroup>(tmpProviderInfoList.values());
    }

    public void unSubscribe() {
        List<RegistryConfig> registryConfigs;
        if (this.consumerConfig.isSubscribe() && (registryConfigs = this.consumerConfig.getRegistry()) != null) {
            for (RegistryConfig registryConfig : registryConfigs) {
                Registry registry = RegistryFactory.getRegistry(registryConfig);
                try {
                    registry.unSubscribe(this.consumerConfig);
                }
                catch (Exception e) {
                    String appName = this.consumerConfig.getAppName();
                    if (!LOGGER.isWarnEnabled(appName)) continue;
                    LOGGER.warnWithApp(appName, "Catch exception when unSubscribe from registry: " + registryConfig.getId() + ", but you can ignore if it's called by JVM shutdown hook", e);
                }
            }
        }
    }

    @Override
    public Cluster getCluster() {
        return this.cluster;
    }

    @Override
    public T getProxyIns() {
        return this.proxyIns;
    }

    public Invoker getProxyInvoker() {
        return this.proxyInvoker;
    }

    private class ConsumerAttributeListener
    implements ConfigListener {
        private ConsumerAttributeListener() {
        }

        @Override
        public void configChanged(Map newValue) {
        }

        @Override
        public synchronized void attrUpdated(Map newValueMap) {
            String appName = DefaultConsumerBootstrap.this.consumerConfig.getAppName();
            Map newValues = newValueMap;
            HashMap oldValues = new HashMap();
            boolean rerefer = false;
            try {
                for (Map.Entry entry : newValues.entrySet()) {
                    boolean changed;
                    String newValue = (String)entry.getValue();
                    String oldValue = DefaultConsumerBootstrap.this.consumerConfig.queryAttribute((String)entry.getKey());
                    boolean bl = oldValue == null ? newValue != null : (changed = !oldValue.equals(newValue));
                    if (changed) {
                        oldValues.put(entry.getKey(), oldValue);
                    }
                    rerefer = rerefer || changed;
                }
            }
            catch (Exception e) {
                LOGGER.errorWithApp(appName, LogCodes.getLog("010010017"), e);
                return;
            }
            if (rerefer) {
                try {
                    DefaultConsumerBootstrap.this.unSubscribe();
                    for (Map.Entry entry : newValues.entrySet()) {
                        DefaultConsumerBootstrap.this.consumerConfig.updateAttribute((String)entry.getKey(), (String)entry.getValue(), true);
                    }
                    if (LOGGER.isInfoEnabled(appName)) {
                        LOGGER.infoWithApp(appName, "Rerefer consumer {}", DefaultConsumerBootstrap.this.consumerConfig.buildKey());
                    }
                }
                catch (Exception e) {
                    LOGGER.errorWithApp(appName, LogCodes.getLog("010010018"), e);
                    for (Map.Entry entry : oldValues.entrySet()) {
                        DefaultConsumerBootstrap.this.consumerConfig.updateAttribute((String)entry.getKey(), (String)entry.getValue(), true);
                    }
                    DefaultConsumerBootstrap.this.subscribe();
                    return;
                }
                try {
                    this.switchCluster();
                }
                catch (Exception e) {
                    LOGGER.errorWithApp(appName, LogCodes.getLog("010010019"), e);
                    DefaultConsumerBootstrap.this.unSubscribe();
                    for (Map.Entry entry : oldValues.entrySet()) {
                        DefaultConsumerBootstrap.this.consumerConfig.updateAttribute((String)entry.getKey(), (String)entry.getValue(), true);
                    }
                    DefaultConsumerBootstrap.this.subscribe();
                }
            }
        }

        private void switchCluster() throws Exception {
            block7: {
                Cluster oldCluster;
                Cluster newCluster = null;
                try {
                    newCluster = ClusterFactory.getCluster(DefaultConsumerBootstrap.this);
                    newCluster.init();
                    oldCluster = ((ClientProxyInvoker)DefaultConsumerBootstrap.this.proxyInvoker).setCluster(newCluster);
                }
                catch (Exception e) {
                    if (newCluster != null) {
                        newCluster.destroy();
                    }
                    if (e instanceof SofaRpcRuntimeException) {
                        throw e;
                    }
                    throw new SofaRpcRuntimeException(LogCodes.getLog("010010020"), e);
                }
                try {
                    DefaultConsumerBootstrap.this.cluster = newCluster;
                    if (oldCluster != null) {
                        oldCluster.destroy();
                    }
                }
                catch (Exception e) {
                    String appName = DefaultConsumerBootstrap.this.consumerConfig.getAppName();
                    if (!LOGGER.isWarnEnabled(appName)) break block7;
                    LOGGER.warnWithApp(appName, LogCodes.getLog("010010021"), e);
                }
            }
        }
    }

    class WrapperClusterProviderInfoListener
    implements ProviderInfoListener {
        private ProviderInfoListener providerInfoListener;
        private CountDownLatch respondRegistries;
        private AtomicBoolean hasRespond = new AtomicBoolean(false);

        public WrapperClusterProviderInfoListener(ProviderInfoListener providerInfoListener, CountDownLatch respondRegistries) {
            this.providerInfoListener = providerInfoListener;
            this.respondRegistries = respondRegistries;
        }

        private void doCountDown() {
            if (this.respondRegistries != null && this.hasRespond.compareAndSet(false, true)) {
                this.respondRegistries.countDown();
                this.respondRegistries = null;
            }
        }

        @Override
        public void addProvider(ProviderGroup group) {
            this.providerInfoListener.addProvider(group);
            this.doCountDown();
        }

        @Override
        public void removeProvider(ProviderGroup group) {
            this.providerInfoListener.removeProvider(group);
        }

        @Override
        public void updateProviders(ProviderGroup group) {
            this.providerInfoListener.updateProviders(group);
            this.doCountDown();
        }

        @Override
        public void updateAllProviders(List<ProviderGroup> groups) {
            this.providerInfoListener.updateAllProviders(groups);
            this.doCountDown();
        }
    }
}

