/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.rpc.protocol.tup;

import com.qq.tars.protocol.tars.TarsInputStream;
import com.qq.tars.protocol.tars.TarsOutputStream;
import com.qq.tars.protocol.tars.TarsStructBase;
import com.qq.tars.protocol.util.TarsUtil;
import com.qq.tars.rpc.protocol.tup.BasicClassTypeUtil;
import com.qq.tars.rpc.protocol.tup.ObjectCreateException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

class OldUniAttribute {
    protected HashMap<String, HashMap<String, byte[]>> _data = new HashMap();
    protected HashMap<String, Object> cachedClassName = new HashMap();
    private HashMap<String, Object> cachedData = new HashMap();
    protected String encodeName = "UTF-8";
    TarsInputStream _is = new TarsInputStream();

    OldUniAttribute() {
    }

    public String getEncodeName() {
        return this.encodeName;
    }

    public void setEncodeName(String encodeName) {
        this.encodeName = encodeName;
    }

    public void clearCacheData() {
        this.cachedData.clear();
    }

    public Set<String> getKeySet() {
        return Collections.unmodifiableSet(this._data.keySet());
    }

    public boolean isEmpty() {
        return this._data.isEmpty();
    }

    public int size() {
        return this._data.size();
    }

    public boolean containsKey(String key) {
        return this._data.containsKey(key);
    }

    public <T> void put(String name, T t) {
        if (name == null) {
            throw new IllegalArgumentException("put key can not is null");
        }
        if (t == null) {
            throw new IllegalArgumentException("put value can not is null");
        }
        if (t instanceof Set) {
            throw new IllegalArgumentException("can not support Set");
        }
        TarsOutputStream _out = new TarsOutputStream();
        _out.setServerEncoding(this.encodeName);
        _out.write(t, 0);
        byte[] _sBuffer = TarsUtil.getBufArray(_out.getByteBuffer());
        HashMap<String, byte[]> pair = new HashMap<String, byte[]>(1);
        ArrayList<String> listType = new ArrayList<String>(1);
        this.checkObjectType(listType, t);
        String className = BasicClassTypeUtil.transTypeList(listType);
        pair.put(className, _sBuffer);
        this.cachedData.remove(name);
        this._data.put(name, pair);
    }

    public <T> T getStruct(String name) throws ObjectCreateException {
        if (!this._data.containsKey(name)) {
            return null;
        }
        if (this.cachedData.containsKey(name)) {
            return (T)this.cachedData.get(name);
        }
        HashMap<String, byte[]> pair = this._data.get(name);
        String className = null;
        byte[] data = new byte[]{};
        Iterator<Map.Entry<String, byte[]>> iterator = pair.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry<String, byte[]> e = iterator.next();
            className = e.getKey();
            data = e.getValue();
        }
        try {
            Object proxy = this.getCacheProxy(className);
            this._is.warp(data);
            this._is.setServerEncoding(this.encodeName);
            TarsStructBase o = this._is.directRead((TarsStructBase)proxy, 0, true);
            this.saveDataCache(name, o);
            return (T)o;
        }
        catch (Exception ex) {
            throw new ObjectCreateException(ex);
        }
    }

    public <T> T get(String name) throws ObjectCreateException {
        if (!this._data.containsKey(name)) {
            return null;
        }
        if (this.cachedData.containsKey(name)) {
            return (T)this.cachedData.get(name);
        }
        HashMap<String, byte[]> pair = this._data.get(name);
        String className = null;
        byte[] data = new byte[]{};
        Iterator<Map.Entry<String, byte[]>> iterator = pair.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry<String, byte[]> e = iterator.next();
            className = e.getKey();
            data = e.getValue();
        }
        try {
            Object proxy = this.getCacheProxy(className);
            this._is.warp(data);
            this._is.setServerEncoding(this.encodeName);
            Object o = this._is.read(proxy, 0, true);
            this.saveDataCache(name, o);
            return (T)o;
        }
        catch (Exception ex) {
            throw new ObjectCreateException(ex);
        }
    }

    private Object getCacheProxy(String className) {
        Object proxy = null;
        if (this.cachedClassName.containsKey(className)) {
            proxy = this.cachedClassName.get(className);
        } else {
            proxy = BasicClassTypeUtil.createClassByUni(className);
            this.cachedClassName.put(className, proxy);
        }
        return proxy;
    }

    private void saveDataCache(String name, Object o) {
        this.cachedData.put(name, o);
    }

    public <T> T get(String name, Object defaultValue) {
        if (!this._data.containsKey(name)) {
            return (T)defaultValue;
        }
        if (this.cachedData.containsKey(name)) {
            return (T)this.cachedData.get(name);
        }
        HashMap<String, byte[]> pair = this._data.get(name);
        String className = "";
        byte[] data = new byte[]{};
        Iterator<Map.Entry<String, byte[]>> iterator = pair.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry<String, byte[]> e = iterator.next();
            className = e.getKey();
            data = e.getValue();
        }
        try {
            Object proxy = this.getCacheProxy(className);
            this._is.warp(data);
            this._is.setServerEncoding(this.encodeName);
            Object o = this._is.read(proxy, 0, true);
            this.saveDataCache(name, o);
            return (T)o;
        }
        catch (Exception ex) {
            this.saveDataCache(name, defaultValue);
            return (T)defaultValue;
        }
    }

    public <T> T remove(String name) throws ObjectCreateException {
        if (!this._data.containsKey(name)) {
            return null;
        }
        HashMap<String, byte[]> pair = this._data.remove(name);
        String className = "";
        byte[] data = new byte[]{};
        Iterator<Map.Entry<String, byte[]>> iterator = pair.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry<String, byte[]> e = iterator.next();
            className = e.getKey();
            data = e.getValue();
        }
        try {
            Object proxy = BasicClassTypeUtil.createClassByUni(className);
            this._is.warp(data);
            this._is.setServerEncoding(this.encodeName);
            return (T)this._is.read(proxy, 0, true);
        }
        catch (Exception ex) {
            throw new ObjectCreateException(ex);
        }
    }

    private void checkObjectType(ArrayList<String> listType, Object o) {
        if (o.getClass().isArray()) {
            if (!o.getClass().getComponentType().toString().equals("byte")) {
                throw new IllegalArgumentException("only byte[] is supported");
            }
            if (Array.getLength(o) > 0) {
                listType.add("java.util.List");
                this.checkObjectType(listType, Array.get(o, 0));
            } else {
                listType.add("Array");
                listType.add("?");
            }
        } else {
            if (o instanceof Array) {
                throw new IllegalArgumentException("can not support Array, please use List");
            }
            if (o instanceof List) {
                listType.add("java.util.List");
                List list = (List)o;
                if (list.size() > 0) {
                    this.checkObjectType(listType, list.get(0));
                } else {
                    listType.add("?");
                }
            } else if (o instanceof Map) {
                listType.add("java.util.Map");
                Map map = (Map)o;
                if (map.size() > 0) {
                    Iterator it = map.keySet().iterator();
                    Object key = it.next();
                    Object value = map.get(key);
                    listType.add(key.getClass().getName());
                    this.checkObjectType(listType, value);
                } else {
                    listType.add("?");
                    listType.add("?");
                }
            } else {
                listType.add(o.getClass().getName());
            }
        }
    }

    public byte[] encode() {
        TarsOutputStream _os = new TarsOutputStream(0);
        _os.setServerEncoding(this.encodeName);
        _os.write(this._data, 0);
        return TarsUtil.getBufArray(_os.getByteBuffer());
    }

    public void decode(byte[] buffer) {
        this._is.warp(buffer);
        this._is.setServerEncoding(this.encodeName);
        HashMap _tempdata = new HashMap(1);
        HashMap<String, byte[]> h = new HashMap<String, byte[]>(1);
        h.put("", new byte[0]);
        _tempdata.put("", h);
        this._data = this._is.readMap(_tempdata, 0, false);
    }
}

