/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.protocol.util;

import com.qq.tars.common.support.Holder;
import com.qq.tars.common.util.BeanAccessor;
import com.qq.tars.common.util.CommonUtils;
import com.qq.tars.protocol.annotation.Servant;
import com.qq.tars.protocol.tars.annotation.TarsCallback;
import com.qq.tars.protocol.tars.annotation.TarsContext;
import com.qq.tars.protocol.tars.annotation.TarsHolder;
import com.qq.tars.protocol.tars.annotation.TarsMethod;
import com.qq.tars.protocol.tars.annotation.TarsMethodParameter;
import com.qq.tars.protocol.tars.annotation.TarsRouteKey;
import com.qq.tars.protocol.tars.annotation.TarsStruct;
import com.qq.tars.protocol.tars.annotation.TarsStructProperty;
import com.qq.tars.protocol.tars.support.TarsMethodInfo;
import com.qq.tars.protocol.tars.support.TarsMethodParameterInfo;
import com.qq.tars.protocol.tars.support.TarsStructInfo;
import com.qq.tars.protocol.tars.support.TarsStrutPropertyInfo;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import sun.reflect.generics.reflectiveObjects.ParameterizedTypeImpl;

public class TarsHelper {
    public static final int PACKAGE_MAX_LENGTH = 0xA00000;
    public static final int HEAD_SIZE = 4;
    public static final short VERSION = 1;
    public static final short VERSION2 = 2;
    public static final short VERSION3 = 3;
    public static final short VERSIONJSON = 5;
    public static final byte NORMAL = 0;
    public static final byte ONEWAY = 1;
    public static final int SERVERSUCCESS = 0;
    public static final int SERVERDECODEERR = -1;
    public static final int SERVERENCODEERR = -2;
    public static final int SERVERNOFUNCERR = -3;
    public static final int SERVERNOSERVANTERR = -4;
    public static final int SERVERRESETGRID = -5;
    public static final int SERVERQUEUETIMEOUT = -6;
    public static final int ASYNCCALLTIMEOUT = -7;
    public static final int INVOKETIMEOUT = -7;
    public static final int PROXYCONNECTERR = -8;
    public static final int SERVEROVERLOAD = -9;
    public static final int ADAPTERNULL = -10;
    public static final int SERVERUNCATCHEDERR = -98;
    public static final int SERVERUNKNOWNERR = -99;
    public static final int MESSAGETYPENULL = 0;
    public static final int MESSAGETYPEHASH = 1;
    public static final int MESSAGETYPEGRID = 2;
    public static final int MESSAGETYPEDYED = 4;
    public static final int MESSAGETYPESAMPLE = 8;
    public static final int MESSAGETYPEASYNC = 16;
    public static final int MESSAGETYPELOADED = 32;
    public static final String STATUS_RESULT_CODE = "STATUS_RESULT_CODE";
    public static final String STATUS_RESULT_DESC = "STATUS_RESULT_DESC";
    public static final Boolean STAMP_BOOLEAN = Boolean.TRUE;
    public static final Byte STAMP_BYTE = 0;
    public static final Short STAMP_SHORT = 0;
    public static final Float STAMP_FLOAT = Float.valueOf(0.0f);
    public static final Integer STAMP_INT = 0;
    public static final Long STAMP_LONG = 0L;
    public static final Double STAMP_DOUBLE = 0.0;
    public static final String STAMP_STRING = "";
    public static final boolean[] STAMP_BOOLEAN_ARRAY = new boolean[]{true};
    public static final byte[] STAMP_BYTE_ARRAY = new byte[]{0};
    public static final short[] STAMP_SHORT_ARRAY = new short[]{0};
    public static final int[] STAMP_INT_ARRAY = new int[]{0};
    public static final long[] STAMP_LONG_ARRAY = new long[]{0L};
    public static final float[] STAMP_FLOAT_ARRAY = new float[]{0.0f};
    public static final double[] STAMP_DOUBLE_ARRAY = new double[]{0.0};
    public static final Map<String, String> STAMP_MAP = new HashMap<String, String>();
    private static Map<Class<?>, TarsStructInfo> tarsStructCache;
    private static Comparator<Field> tarsStructFieldsListComparator;
    private static Map<Class<?>, Object> stampCache;

    public static Object getJavaBaseOrArrayOrJavaBeanStamp(Class<?> clazz) {
        if (clazz == Boolean.TYPE || clazz == Boolean.class) {
            return STAMP_BOOLEAN;
        }
        if (clazz == Byte.TYPE || clazz == Byte.class) {
            return STAMP_BYTE;
        }
        if (clazz == Short.TYPE || clazz == Short.class) {
            return STAMP_SHORT;
        }
        if (clazz == Integer.TYPE || clazz == Integer.class) {
            return STAMP_INT;
        }
        if (clazz == Long.TYPE || clazz == Long.class) {
            return STAMP_LONG;
        }
        if (clazz == Float.TYPE || clazz == Float.class) {
            return STAMP_FLOAT;
        }
        if (clazz == Double.TYPE || clazz == Double.class) {
            return STAMP_DOUBLE;
        }
        if (clazz == String.class) {
            return STAMP_STRING;
        }
        if (clazz == boolean[].class) {
            return STAMP_BOOLEAN_ARRAY;
        }
        if (clazz == byte[].class) {
            return STAMP_BYTE_ARRAY;
        }
        if (clazz == short[].class) {
            return STAMP_SHORT_ARRAY;
        }
        if (clazz == int[].class) {
            return STAMP_INT_ARRAY;
        }
        if (clazz == long[].class) {
            return STAMP_LONG_ARRAY;
        }
        if (clazz == float[].class) {
            return STAMP_FLOAT_ARRAY;
        }
        if (clazz == double[].class) {
            return STAMP_DOUBLE_ARRAY;
        }
        Object stamp = stampCache.get(clazz);
        if (stamp == null) {
            if (clazz.isArray()) {
                Object e;
                Class<?> componentType = clazz.getComponentType();
                Object[] array = (Object[])Array.newInstance(componentType, 1);
                array[0] = e = TarsHelper.getJavaBaseOrArrayOrJavaBeanStamp(componentType);
                stamp = array;
            } else {
                stamp = CommonUtils.newInstance(clazz);
            }
            stampCache.put(clazz, stamp);
        }
        return stamp;
    }

    public static String getParameterName(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            if (annotation.annotationType() == TarsMethodParameter.class) {
                TarsMethodParameter parameter = (TarsMethodParameter)annotation;
                return parameter.name();
            }
            if (annotation.annotationType() != TarsHolder.class) continue;
            TarsHolder tarsHolder = (TarsHolder)annotation;
            return tarsHolder.name();
        }
        return null;
    }

    public static Object getParameterStamp(Type type) {
        if (type instanceof Class) {
            Class clazz = (Class)type;
            if (CommonUtils.isJavaBase(clazz) || clazz.isArray() || TarsHelper.isStruct(clazz)) {
                return TarsHelper.getJavaBaseOrArrayOrJavaBeanStamp((Class)type);
            }
            return clazz;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Class clazz = (Class)parameterizedType.getRawType();
            if (TarsHelper.isStruct(clazz)) {
                return TarsHelper.getJavaBaseOrArrayOrJavaBeanStamp((Class)type);
            }
            if (TarsHelper.isMap(clazz)) {
                Type[] types = parameterizedType.getActualTypeArguments();
                Type keyType = types[0];
                Type valueType = types[1];
                Object key = TarsHelper.getParameterStamp(keyType);
                Object value = TarsHelper.getParameterStamp(valueType);
                HashMap<Object, Object> map = new HashMap<Object, Object>(1);
                map.put(key, value);
                return map;
            }
            if (TarsHelper.isCollection(clazz)) {
                Type[] types = parameterizedType.getActualTypeArguments();
                Type valueType = types[0];
                Object e = TarsHelper.getParameterStamp(valueType);
                ArrayList<Object> list = new ArrayList<Object>(1);
                list.add(e);
                return list;
            }
            if (TarsHelper.isHolder(clazz)) {
                Type[] types = parameterizedType.getActualTypeArguments();
                if (Holder.class == clazz) {
                    return TarsHelper.getParameterStamp(types[0]);
                }
                throw new RuntimeException("getStamp for Holder Not Implement Yet, parameterizedType=" + parameterizedType);
            }
        } else if (type instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)type;
            Type componentType = genericArrayType.getGenericComponentType();
            Object component = TarsHelper.getParameterStamp(componentType);
            Object[] array = (Object[])Array.newInstance(component.getClass(), 1);
            array[0] = component;
            return array;
        }
        throw new RuntimeException("Generic Type: " + type + " no permission, please check it.");
    }

    public static Object getNewParameterStamp(Type type) {
        if (type instanceof Class) {
            Class clazz = (Class)type;
            if (CommonUtils.isJavaBase(clazz) || clazz.isArray() || TarsHelper.isStruct(clazz)) {
                return TarsHelper.getNewJavaBaseOrArrayOrJavaBeanStamp((Class)type);
            }
            return clazz;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Class clazz = (Class)parameterizedType.getRawType();
            if (TarsHelper.isStruct(clazz)) {
                return TarsHelper.getNewJavaBaseOrArrayOrJavaBeanStamp((Class)type);
            }
            if (TarsHelper.isMap(clazz)) {
                Type[] types = parameterizedType.getActualTypeArguments();
                Type keyType = types[0];
                Type valueType = types[1];
                Object key = TarsHelper.getNewParameterStamp(keyType);
                Object value = TarsHelper.getNewParameterStamp(valueType);
                HashMap<Object, Object> map = new HashMap<Object, Object>(1);
                map.put(key, value);
                return map;
            }
            if (TarsHelper.isCollection(clazz)) {
                Type[] types = parameterizedType.getActualTypeArguments();
                Type valueType = types[0];
                Object e = TarsHelper.getNewParameterStamp(valueType);
                ArrayList<Object> list = new ArrayList<Object>(1);
                list.add(e);
                return list;
            }
            if (TarsHelper.isHolder(clazz)) {
                Type[] types = parameterizedType.getActualTypeArguments();
                if (Holder.class == clazz) {
                    return TarsHelper.getNewParameterStamp(types[0]);
                }
                throw new RuntimeException("getStamp for Holder Not Implement Yet, parameterizedType=" + parameterizedType);
            }
        } else if (type instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)type;
            Type componentType = genericArrayType.getGenericComponentType();
            Object component = TarsHelper.getNewParameterStamp(componentType);
            Object[] array = (Object[])Array.newInstance(component.getClass(), 1);
            array[0] = component;
            return array;
        }
        throw new RuntimeException("Generic Type: " + type + " no permission, please check it.");
    }

    public static TarsMethodParameterInfo createParameterInfo(Type genericParameterType) {
        if (genericParameterType == null) {
            throw new NullPointerException("genericParameterType is null.");
        }
        TarsMethodParameterInfo parameterInfo = new TarsMethodParameterInfo();
        Object stamp = TarsHelper.getParameterStamp(genericParameterType);
        parameterInfo.setStamp(stamp);
        return parameterInfo;
    }

    public static Object getNewJavaBaseOrArrayOrJavaBeanStamp(Class<?> clazz) {
        if (clazz == Boolean.TYPE || clazz == Boolean.class) {
            return new Boolean(true);
        }
        if (clazz == Byte.TYPE || clazz == Byte.class) {
            return (byte)0;
        }
        if (clazz == Short.TYPE || clazz == Short.class) {
            return (short)0;
        }
        if (clazz == Integer.TYPE || clazz == Integer.class) {
            return 0;
        }
        if (clazz == Long.TYPE || clazz == Long.class) {
            return 0L;
        }
        if (clazz == Float.TYPE || clazz == Float.class) {
            return Float.valueOf(0.0f);
        }
        if (clazz == Double.TYPE || clazz == Double.class) {
            return 0.0;
        }
        if (clazz == String.class) {
            return new String(STAMP_STRING);
        }
        if (clazz == boolean[].class) {
            return new boolean[]{true};
        }
        if (clazz == byte[].class) {
            return new byte[]{0};
        }
        if (clazz == short[].class) {
            return new short[]{0};
        }
        if (clazz == int[].class) {
            return new int[]{0};
        }
        if (clazz == long[].class) {
            return new long[]{0L};
        }
        if (clazz == float[].class) {
            return new float[]{0.0f};
        }
        if (clazz == double[].class) {
            return new double[]{0.0};
        }
        Object[] stamp = null;
        if (stamp == null) {
            if (clazz.isArray()) {
                Object e;
                Class<?> componentType = clazz.getComponentType();
                Object[] array = (Object[])Array.newInstance(componentType, 1);
                array[0] = e = TarsHelper.getNewJavaBaseOrArrayOrJavaBeanStamp(componentType);
                stamp = array;
            } else {
                stamp = (Object[])CommonUtils.newInstance(clazz);
            }
        }
        return stamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TarsStructInfo getStructInfo(Class<?> clazz) {
        TarsStructInfo tarsStructInfo = tarsStructCache.get(clazz);
        if (tarsStructInfo != null) return tarsStructInfo;
        Class<TarsHelper> clazz2 = TarsHelper.class;
        synchronized (TarsHelper.class) {
            tarsStructInfo = tarsStructCache.get(clazz);
            if (tarsStructInfo != null) return tarsStructInfo;
            tarsStructInfo = new TarsStructInfo();
            Object[] fields = clazz.getDeclaredFields();
            if (!CommonUtils.isEmptyArray(fields)) {
                String string;
                ArrayList<Object> fieldList = new ArrayList<Object>(fields.length);
                for (Object object : fields) {
                    if (!((AccessibleObject)object).isAnnotationPresent(TarsStructProperty.class)) continue;
                    fieldList.add(object);
                }
                try {
                    fieldList.sort(tarsStructFieldsListComparator);
                }
                catch (Exception e) {
                    throw new RuntimeException("class[" + clazz + "] , Annotation StructProperty order error: " + e.getMessage(), e);
                }
                ArrayList<TarsStrutPropertyInfo> propertyList = new ArrayList<TarsStrutPropertyInfo>(fieldList.size());
                int order = 0;
                Object bean = CommonUtils.newInstance(clazz);
                for (Field field : fieldList) {
                    TarsStrutPropertyInfo propertyInfo = new TarsStrutPropertyInfo();
                    Type type = field.getGenericType();
                    Object stamp = null;
                    try {
                        stamp = TarsHelper.getParameterStamp(type);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("class[" + clazz + "] , Field[" + field.getName() + "] create stamp failed:" + e.getMessage(), e);
                    }
                    propertyInfo.setStamp(stamp);
                    propertyInfo.setName(field.getName());
                    TarsStructProperty propertyAnnotation = field.getAnnotation(TarsStructProperty.class);
                    order = propertyAnnotation.order();
                    propertyInfo.setOrder(order);
                    propertyInfo.setRequire(propertyAnnotation.isRequire());
                    propertyInfo.setComment(propertyAnnotation.comment());
                    propertyInfo.setDefaultValue(TarsHelper.getPropertyDefaultValue(BeanAccessor.getBeanValue(bean, field.getName())));
                    propertyList.add(propertyInfo);
                }
                tarsStructInfo.setPropertyList(propertyList);
                TarsStruct tarsStruct = clazz.getAnnotation(TarsStruct.class);
                if (tarsStruct != null && !CommonUtils.isEmpty(string = tarsStruct.comment())) {
                    tarsStructInfo.setComment(string);
                }
            }
            tarsStructCache.put(clazz, tarsStructInfo);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return tarsStructInfo;
        }
    }

    public static Map<Method, TarsMethodInfo> getMethodInfo(Class<?> api, String objectName) {
        Method[] methods = api.getDeclaredMethods();
        HashMap<Method, TarsMethodInfo> methodMap = new HashMap<Method, TarsMethodInfo>(methods.length);
        for (Method method : methods) {
            TarsMethodInfo methodInfo;
            if (method == null || (methodInfo = TarsHelper.getMethodInfo(api, method, objectName)) == null) continue;
            methodMap.put(method, methodInfo);
        }
        return methodMap;
    }

    public static TarsMethodInfo getMethodInfo(Class<?> api, Method method, String objectName) {
        if (!TarsHelper.isServant(api) && !TarsHelper.isCallback(api)) {
            return null;
        }
        TarsMethodInfo methodInfo = new TarsMethodInfo();
        methodInfo.setServiceName(objectName);
        methodInfo.setMethod(method);
        Type[] genericParameterTypes = method.getGenericParameterTypes();
        TarsMethod tarsMethod = method.getAnnotation(TarsMethod.class);
        if (tarsMethod != null && !CommonUtils.isEmpty(tarsMethod.comment())) {
            methodInfo.setComment(tarsMethod.comment());
        }
        ArrayList<TarsMethodParameterInfo> parametersList = new ArrayList<TarsMethodParameterInfo>(genericParameterTypes.length);
        methodInfo.setParametersList(parametersList);
        int order = 0;
        Annotation[][] allParameterAnnotations = method.getParameterAnnotations();
        for (Type genericParameterType : genericParameterTypes) {
            String name = TarsHelper.getParameterName(allParameterAnnotations[order]);
            if (name == null) {
                name = "args" + order;
            }
            TarsMethodParameterInfo parameterInfo = new TarsMethodParameterInfo();
            parametersList.add(parameterInfo);
            try {
                parameterInfo.setType(genericParameterType);
                parameterInfo.setName(name);
                parameterInfo.setOrder(TarsHelper.isAsync(method.getName()) ? order : order + 1);
                parameterInfo.setAnnotations(allParameterAnnotations[order]);
                if (!TarsHelper.isCallback(allParameterAnnotations[order])) {
                    parameterInfo.setStamp(TarsHelper.getParameterStamp(genericParameterType));
                }
                if (TarsHelper.isRoutekey(allParameterAnnotations[order])) {
                    methodInfo.setRouteKeyIndex(order);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("failed to create parameter info:" + method + ", index=[" + order + "]", e);
            }
            ++order;
        }
        Type returnType = method.getGenericReturnType();
        Class<?> returnOriginType = method.getReturnType();
        if (returnOriginType == CompletableFuture.class) {
            ParameterizedTypeImpl parameterizedType = (ParameterizedTypeImpl)method.getGenericReturnType();
            TarsMethodParameterInfo returnInfo = new TarsMethodParameterInfo();
            returnInfo.setStamp(TarsHelper.getParameterStamp(parameterizedType.getActualTypeArguments()[0]));
            returnInfo.setName("result");
            returnInfo.setOrder(0);
            returnInfo.setType(returnType);
            methodInfo.setReturnInfo(returnInfo);
        } else if (returnType != Void.TYPE) {
            TarsMethodParameterInfo returnInfo = new TarsMethodParameterInfo();
            returnInfo.setStamp(TarsHelper.getParameterStamp(returnType));
            returnInfo.setName("result");
            returnInfo.setOrder(0);
            returnInfo.setType(returnType);
            methodInfo.setReturnInfo(returnInfo);
        }
        return methodInfo;
    }

    public static boolean isAsync(String methodName) {
        return methodName != null && methodName.startsWith("async_");
    }

    public static boolean isPromiseFuture(String methodName) {
        return methodName != null && methodName.startsWith("promise_");
    }

    public static boolean isPing(String methodName) {
        return methodName != null && methodName.equals("tars_ping");
    }

    public static boolean isHolder(Annotation[] annotations) {
        if (annotations == null || annotations.length < 0) {
            return false;
        }
        for (Annotation annotation : annotations) {
            if (annotation.annotationType() != TarsHolder.class) continue;
            return true;
        }
        return false;
    }

    public static String getHolderName(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            if (annotation.annotationType() != TarsHolder.class) continue;
            TarsHolder holder = (TarsHolder)annotation;
            return holder.name();
        }
        return null;
    }

    public static boolean isCallback(Annotation[] annotations) {
        if (annotations == null || annotations.length < 0) {
            return false;
        }
        for (Annotation annotation : annotations) {
            if (annotation.annotationType() != TarsCallback.class) continue;
            return true;
        }
        return false;
    }

    public static boolean isParameter(Annotation[] annotations) {
        if (annotations == null || annotations.length < 0) {
            return false;
        }
        for (Annotation annotation : annotations) {
            if (annotation.annotationType() != TarsMethodParameter.class) continue;
            return true;
        }
        return false;
    }

    public static boolean isContext(Annotation[] annotations) {
        if (annotations == null || annotations.length < 0) {
            return false;
        }
        for (Annotation annotation : annotations) {
            if (annotation.annotationType() != TarsContext.class) continue;
            return true;
        }
        return false;
    }

    public static boolean isRoutekey(Annotation[] annotations) {
        if (annotations == null || annotations.length < 0) {
            return false;
        }
        for (Annotation annotation : annotations) {
            if (annotation.annotationType() != TarsRouteKey.class) continue;
            return true;
        }
        return false;
    }

    public static boolean isStruct(Class<?> clazz) {
        boolean isStruct = clazz.isAnnotationPresent(TarsStruct.class);
        return isStruct;
    }

    public static boolean isServant(Class<?> apiClass) {
        return apiClass.isAnnotationPresent(Servant.class);
    }

    public static boolean isCallback(Class<?> apiClass) {
        return apiClass.isAnnotationPresent(TarsCallback.class);
    }

    public static boolean isHolder(Class<?> clazz) {
        return Holder.class.isAssignableFrom(clazz);
    }

    public static boolean isMap(Class<?> clazz) {
        return Map.class.isAssignableFrom(clazz);
    }

    public static boolean isVector(Class<?> clazz) {
        return clazz.isArray() || TarsHelper.isCollection(clazz);
    }

    public static boolean isCollection(Class<?> clazz) {
        return Collection.class.isAssignableFrom(clazz);
    }

    public static String getDataType(Class<?> clazz) {
        if (clazz == Boolean.TYPE || clazz == Boolean.class) {
            return "bool";
        }
        if (clazz == Byte.TYPE || clazz == Byte.class) {
            return "byte";
        }
        if (clazz == Short.TYPE || clazz == Short.class) {
            return "short";
        }
        if (clazz == Integer.TYPE || clazz == Integer.class) {
            return "int";
        }
        if (clazz == Long.TYPE || clazz == Long.class) {
            return "long";
        }
        if (clazz == Float.TYPE || clazz == Float.class) {
            return "float";
        }
        if (clazz == Double.TYPE || clazz == Double.class) {
            return "double";
        }
        if (clazz == String.class) {
            return "string";
        }
        if (TarsHelper.isStruct(clazz)) {
            return clazz.getSimpleName();
        }
        if (TarsHelper.isCollection(clazz) || clazz.isArray()) {
            return "vector";
        }
        if (TarsHelper.isMap(clazz)) {
            return "map";
        }
        return null;
    }

    public static Object getJavaBaseArrayType(Object stamp) {
        if (STAMP_BOOLEAN_ARRAY == stamp) {
            return STAMP_BOOLEAN;
        }
        if (STAMP_BYTE_ARRAY == stamp) {
            return STAMP_BYTE;
        }
        if (STAMP_SHORT_ARRAY == stamp) {
            return STAMP_SHORT;
        }
        if (STAMP_INT_ARRAY == stamp) {
            return STAMP_INT;
        }
        if (STAMP_LONG_ARRAY == stamp) {
            return STAMP_LONG;
        }
        if (STAMP_FLOAT_ARRAY == stamp) {
            return STAMP_FLOAT;
        }
        if (STAMP_DOUBLE_ARRAY == stamp) {
            return STAMP_DOUBLE;
        }
        return null;
    }

    public static Object getPropertyDefaultValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Integer && (Integer)value != 0) {
            return value;
        }
        if (value instanceof Long && ((Long)value).intValue() != 0) {
            return value;
        }
        if (value instanceof Double && ((Double)value).intValue() != 0) {
            return value;
        }
        if (value instanceof Float && ((Float)value).intValue() != 0) {
            return value;
        }
        if (value instanceof Short && ((Short)value).intValue() != 0) {
            return value;
        }
        if (value instanceof Byte && ((Byte)value).intValue() != 0) {
            return value;
        }
        if (value instanceof Boolean && ((Boolean)value).booleanValue()) {
            return value;
        }
        if (value instanceof String) {
            return value;
        }
        return null;
    }

    public static void setHolderValue(Object holder, Object value) throws Exception {
        BeanAccessor.setBeanValue(holder, "value", value);
    }

    public static Object getHolderValue(Object holder) throws Exception {
        return BeanAccessor.getBeanValue(holder, "value");
    }

    static {
        STAMP_MAP.put(STAMP_STRING, STAMP_STRING);
        tarsStructCache = new HashMap();
        tarsStructFieldsListComparator = new Comparator<Field>(){

            @Override
            public int compare(Field one, Field other) {
                TarsStructProperty oneProperty = one.getAnnotation(TarsStructProperty.class);
                TarsStructProperty otherProperty = other.getAnnotation(TarsStructProperty.class);
                if (oneProperty.order() == otherProperty.order()) {
                    throw new RuntimeException("Field[" + one.getName() + "] , Field[" + other.getName() + "] order is:" + oneProperty.order());
                }
                return oneProperty.order() - otherProperty.order();
            }
        };
        stampCache = new HashMap();
    }
}

