/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.lts.producer;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.huaweicloud.lts.producer.Callback;
import com.huaweicloud.lts.producer.Producer;
import com.huaweicloud.lts.producer.ProducerConfig;
import com.huaweicloud.lts.producer.ProjectConfig;
import com.huaweicloud.lts.producer.Result;
import com.huaweicloud.lts.producer.exception.MaxBatchCountExceedException;
import com.huaweicloud.lts.producer.exception.ProducerException;
import com.huaweicloud.lts.producer.http.Client;
import com.huaweicloud.lts.producer.http.ClientConfiguration;
import com.huaweicloud.lts.producer.http.ServiceClient;
import com.huaweicloud.lts.producer.http.TimeoutServiceClient;
import com.huaweicloud.lts.producer.internals.BatchHandler;
import com.huaweicloud.lts.producer.internals.IOThreadPool;
import com.huaweicloud.lts.producer.internals.LogAccumulator;
import com.huaweicloud.lts.producer.internals.Mover;
import com.huaweicloud.lts.producer.internals.ProducerBatch;
import com.huaweicloud.lts.producer.internals.RetryQueue;
import com.huaweicloud.lts.producer.model.log.LogItem;
import com.huaweicloud.lts.producer.util.Utils;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogProducer
implements Producer {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogProducer.class);
    private static final AtomicInteger INSTANCE_ID_GENERATOR = new AtomicInteger(0);
    private static final String LOG_PRODUCER_PREFIX = "huawei-cloud-log-producer-";
    private static final String MOVER_SUFFIX = "-mover";
    private static final String SUCCESS_BATCH_HANDLER_SUFFIX = "-success-batch-handler";
    private static final String FAILURE_BATCH_HANDLER_SUFFIX = "-failure-batch-handler";
    private static final String TIMEOUT_THREAD_SUFFIX_FORMAT = "-timeout-thread-%d";
    private final int instanceId;
    private final String name;
    private final String producerHash;
    private final ProducerConfig producerConfig;
    private final Map<String, Client> clientPool = new ConcurrentHashMap<String, Client>();
    private final ServiceClient serviceClient;
    private final Semaphore memoryController;
    private final RetryQueue retryQueue;
    private final IOThreadPool ioThreadPool;
    private final ThreadPoolExecutor timeoutThreadPool;
    private final LogAccumulator accumulator;
    private final Mover mover;
    private final BatchHandler successBatchHandler;
    private final BatchHandler failureBatchHandler;
    private final AtomicInteger batchCount = new AtomicInteger(0);

    public LogProducer(ProducerConfig producerConfig) {
        this.instanceId = INSTANCE_ID_GENERATOR.getAndIncrement();
        this.name = LOG_PRODUCER_PREFIX + this.instanceId;
        this.producerHash = Utils.generateProducerHash(this.instanceId);
        this.producerConfig = producerConfig;
        this.memoryController = new Semaphore(producerConfig.getTotalSizeInBytes());
        this.retryQueue = new RetryQueue();
        LinkedBlockingQueue<ProducerBatch> successQueue = new LinkedBlockingQueue<ProducerBatch>();
        LinkedBlockingQueue<ProducerBatch> failureQueue = new LinkedBlockingQueue<ProducerBatch>();
        this.ioThreadPool = new IOThreadPool(producerConfig.getIoThreadCount(), this.name);
        this.timeoutThreadPool = new ThreadPoolExecutor(producerConfig.getIoThreadCount(), producerConfig.getIoThreadCount(), 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat(this.name + TIMEOUT_THREAD_SUFFIX_FORMAT).build());
        this.serviceClient = new TimeoutServiceClient(new ClientConfiguration(), this.timeoutThreadPool);
        this.accumulator = new LogAccumulator(this.producerHash, producerConfig, this.clientPool, this.memoryController, this.retryQueue, successQueue, failureQueue, this.ioThreadPool, this.batchCount);
        this.mover = new Mover(this.name + MOVER_SUFFIX, producerConfig, this.clientPool, this.accumulator, this.retryQueue, successQueue, failureQueue, this.ioThreadPool, this.batchCount);
        this.successBatchHandler = new BatchHandler(this.name + SUCCESS_BATCH_HANDLER_SUFFIX, successQueue, this.batchCount, this.memoryController);
        this.failureBatchHandler = new BatchHandler(this.name + FAILURE_BATCH_HANDLER_SUFFIX, failureQueue, this.batchCount, this.memoryController);
        this.mover.start();
        this.successBatchHandler.start();
        this.failureBatchHandler.start();
    }

    @Override
    public ListenableFuture<Result> send(String logGroupId, String logStreamId, List<LogItem> logItems) throws InterruptedException, ProducerException {
        return this.send(logGroupId, logStreamId, logItems, null);
    }

    @Override
    public ListenableFuture<Result> send(String logGroupId, String logStreamId, List<LogItem> logItems, Callback callback) throws InterruptedException, ProducerException {
        Utils.assertArgumentNotNullOrEmpty(logGroupId, "logGroupId");
        Utils.assertArgumentNotNullOrEmpty(logStreamId, "logStreamId");
        Utils.assertArgumentNotNull(logItems, "logItems");
        if (logItems.isEmpty()) {
            throw new IllegalArgumentException("logItems cannot be empty");
        }
        AtomicInteger count = new AtomicInteger(0);
        for (LogItem logItem : logItems) {
            count.addAndGet(logItem.getContents().size());
        }
        if (count.get() > 40960) {
            throw new MaxBatchCountExceedException("the log list size is " + count + " which exceeds the MAX_BATCH_COUNT " + 40960);
        }
        return this.accumulator.append(logGroupId, logStreamId, logItems, callback);
    }

    @Override
    public void close() throws InterruptedException, ProducerException {
        this.close(Long.MAX_VALUE);
    }

    @Override
    public void close(long timeoutMs) throws InterruptedException, ProducerException {
        ProducerException firstException;
        block15: {
            block14: {
                block13: {
                    block12: {
                        if (timeoutMs < 0L) {
                            throw new IllegalArgumentException("timeoutMs must be greater than or equal to 0, got " + timeoutMs);
                        }
                        firstException = null;
                        LOGGER.info("Closing the log producer, timeoutMs={}", (Object)timeoutMs);
                        try {
                            timeoutMs = this.closeMover(timeoutMs);
                        }
                        catch (ProducerException e) {
                            firstException = e;
                        }
                        LOGGER.debug("After close mover, timeoutMs={}", (Object)timeoutMs);
                        try {
                            timeoutMs = this.closeIOThreadPool(timeoutMs);
                        }
                        catch (ProducerException e) {
                            if (firstException != null) break block12;
                            firstException = e;
                        }
                    }
                    LOGGER.debug("After close ioThreadPool, timeoutMs={}", (Object)timeoutMs);
                    try {
                        timeoutMs = this.closeTimeoutThreadPool(timeoutMs);
                    }
                    catch (ProducerException e) {
                        if (firstException != null) break block13;
                        firstException = e;
                    }
                }
                LOGGER.debug("After close timeoutThreadPool, timeoutMs={}", (Object)timeoutMs);
                try {
                    timeoutMs = this.closeSuccessBatchHandler(timeoutMs);
                }
                catch (ProducerException e) {
                    if (firstException != null) break block14;
                    firstException = e;
                }
            }
            LOGGER.debug("After close success batch handler, timeoutMs={}", (Object)timeoutMs);
            try {
                timeoutMs = this.closeFailureBatchHandler(timeoutMs);
            }
            catch (ProducerException e) {
                if (firstException != null) break block15;
                firstException = e;
            }
        }
        LOGGER.debug("After close failure batch handler, timeoutMs={}", (Object)timeoutMs);
        if (firstException != null) {
            throw firstException;
        }
        LOGGER.info("The log producer has been closed");
    }

    @Override
    public void putProjectConfig(ProjectConfig projectConfig) {
        Client client = this.buildClient(projectConfig);
        this.clientPool.put(projectConfig.getProject(), client);
    }

    private Client buildClient(ProjectConfig projectConfig) {
        Client client = new Client(projectConfig, this.serviceClient);
        String stsToken = client.getSecurityToken();
        if (stsToken != null) {
            client.setSecurityToken(stsToken);
        }
        return client;
    }

    private long closeMover(long timeoutMs) throws InterruptedException, ProducerException {
        long startMs = System.currentTimeMillis();
        this.accumulator.close();
        this.retryQueue.close();
        this.mover.close();
        this.mover.join(timeoutMs);
        if (this.mover.isAlive()) {
            LOGGER.warn("The mover thread is still alive");
            throw new ProducerException("the mover thread is still alive");
        }
        long nowMs = System.currentTimeMillis();
        return Math.max(0L, timeoutMs - nowMs + startMs);
    }

    private long closeIOThreadPool(long timeoutMs) throws InterruptedException, ProducerException {
        long startMs = System.currentTimeMillis();
        this.ioThreadPool.shutdown();
        if (!this.ioThreadPool.awaitTermination(timeoutMs, TimeUnit.MILLISECONDS)) {
            LOGGER.warn("The ioThreadPool is not fully terminated");
            throw new ProducerException("the ioThreadPool is not fully terminated");
        }
        LOGGER.debug("The ioThreadPool is terminated");
        long nowMs = System.currentTimeMillis();
        return Math.max(0L, timeoutMs - nowMs + startMs);
    }

    private long closeTimeoutThreadPool(long timeoutMs) throws InterruptedException, ProducerException {
        long startMs = System.currentTimeMillis();
        this.timeoutThreadPool.shutdown();
        if (!this.timeoutThreadPool.awaitTermination(timeoutMs, TimeUnit.MILLISECONDS)) {
            LOGGER.warn("The timeoutThreadPool is not fully terminated");
            throw new ProducerException("the timeoutThreadPool is not fully terminated");
        }
        LOGGER.debug("The timeoutThreadPool is terminated");
        long nowMs = System.currentTimeMillis();
        return Math.max(0L, timeoutMs - nowMs + startMs);
    }

    private long closeSuccessBatchHandler(long timeoutMs) throws InterruptedException, ProducerException {
        boolean invokedFromCallback;
        long startMs = System.currentTimeMillis();
        this.successBatchHandler.close();
        boolean bl = invokedFromCallback = Thread.currentThread() == this.successBatchHandler;
        if (invokedFromCallback) {
            LOGGER.warn("Skip join success batch handler since you have incorrectly invoked close from the producer call-back");
            return timeoutMs;
        }
        this.successBatchHandler.join(timeoutMs);
        if (this.successBatchHandler.isAlive()) {
            LOGGER.warn("The success batch handler thread is still alive");
            throw new ProducerException("the success batch handler thread is still alive");
        }
        long nowMs = System.currentTimeMillis();
        return Math.max(0L, timeoutMs - nowMs + startMs);
    }

    private long closeFailureBatchHandler(long timeoutMs) throws InterruptedException, ProducerException {
        boolean invokedFromCallback;
        long startMs = System.currentTimeMillis();
        this.failureBatchHandler.close();
        boolean bl = invokedFromCallback = Thread.currentThread() == this.successBatchHandler || Thread.currentThread() == this.failureBatchHandler;
        if (invokedFromCallback) {
            LOGGER.warn("Skip join failure batch handler since you have incorrectly invoked close from the producer call-back");
            return timeoutMs;
        }
        this.failureBatchHandler.join(timeoutMs);
        if (this.failureBatchHandler.isAlive()) {
            LOGGER.warn("The failure batch handler thread is still alive");
            throw new ProducerException("the failure batch handler thread is still alive");
        }
        long nowMs = System.currentTimeMillis();
        return Math.max(0L, timeoutMs - nowMs + startMs);
    }
}

