/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jdbc.config;

import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.AbstractConsumerEndpointParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.jdbc.StoredProcOutboundGateway;
import org.springframework.integration.jdbc.config.StoredProcParserUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class StoredProcOutboundGatewayParser
extends AbstractConsumerEndpointParser {
    protected BeanDefinitionBuilder parseHandler(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(StoredProcOutboundGateway.class);
        BeanDefinitionBuilder storedProcExecutorBuilder = StoredProcParserUtils.getStoredProcExecutorBuilder(element, parserContext);
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)storedProcExecutorBuilder, (Element)element, (String)"is-function");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)storedProcExecutorBuilder, (Element)element, (String)"return-value-required");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)storedProcExecutorBuilder, (Element)element, (String)"use-payload-as-parameter-source");
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)storedProcExecutorBuilder, (Element)element, (String)"sql-parameter-source-factory");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)storedProcExecutorBuilder, (Element)element, (String)"skip-undeclared-results");
        ManagedMap<String, BeanMetadataElement> returningResultSetMap = StoredProcParserUtils.getReturningResultsetBeanDefinitions(element, parserContext);
        if (!returningResultSetMap.isEmpty()) {
            storedProcExecutorBuilder.addPropertyValue("returningResultSetRowMappers", returningResultSetMap);
        }
        AbstractBeanDefinition storedProcExecutorBuilderBeanDefinition = storedProcExecutorBuilder.getBeanDefinition();
        String gatewayId = this.resolveId(element, builder.getRawBeanDefinition(), parserContext);
        String storedProcExecutorBeanName = gatewayId + ".storedProcExecutor";
        parserContext.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)storedProcExecutorBuilderBeanDefinition, storedProcExecutorBeanName));
        builder.addConstructorArgReference(storedProcExecutorBeanName);
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"expect-single-result");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"reply-timeout", (String)"sendTimeout");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"requires-reply");
        String replyChannel = element.getAttribute("reply-channel");
        if (StringUtils.hasText((String)replyChannel)) {
            builder.addPropertyReference("outputChannel", replyChannel);
        }
        return builder;
    }

    protected String getInputChannelAttributeName() {
        return "request-channel";
    }
}

