/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.configfilefilter;

import com.tencent.polaris.api.config.configuration.ConfigFilterConfig;
import com.tencent.polaris.api.config.configuration.CryptoConfig;
import com.tencent.polaris.api.exception.ErrorCode;
import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.api.plugin.PluginType;
import com.tencent.polaris.api.plugin.common.InitContext;
import com.tencent.polaris.api.plugin.common.PluginTypes;
import com.tencent.polaris.api.plugin.compose.Extensions;
import com.tencent.polaris.api.plugin.configuration.ConfigFile;
import com.tencent.polaris.api.plugin.configuration.ConfigFileResponse;
import com.tencent.polaris.api.plugin.filter.ConfigFileFilter;
import com.tencent.polaris.api.plugin.filter.Crypto;
import com.tencent.polaris.configuration.client.JustForTest;
import com.tencent.polaris.factory.config.configuration.CryptoConfigImpl;
import com.tencent.polaris.plugins.configfilefilter.service.RSAService;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class CryptoConfigFileFilter
implements ConfigFileFilter {
    private Crypto crypto;
    private RSAService rsaService;
    private CryptoConfig cryptoConfig;
    private Map<String, Crypto> cryptoMap;

    @Override
    public Function<ConfigFile, ConfigFileResponse> doFilter(ConfigFile configFile, final Function<ConfigFile, ConfigFileResponse> next) {
        return new Function<ConfigFile, ConfigFileResponse>(){

            @Override
            public ConfigFileResponse apply(ConfigFile configFile) {
                configFile.setEncrypted(Boolean.TRUE);
                configFile.setPublicKey(CryptoConfigFileFilter.this.rsaService.getPKCS1PublicKey());
                ConfigFileResponse response = (ConfigFileResponse)next.apply(configFile);
                ConfigFile configFileResponse = response.getConfigFile();
                if (response.getCode() == 200000) {
                    String dataKey = configFileResponse.getDataKey();
                    if (dataKey == null) {
                        throw new PolarisException(ErrorCode.RSA_DECRYPT_ERROR, "dataKey is null");
                    }
                    byte[] password = CryptoConfigFileFilter.this.rsaService.decrypt(dataKey);
                    CryptoConfigFileFilter.this.crypto.doDecrypt(configFileResponse, password);
                }
                return response;
            }
        };
    }

    public CryptoConfigFileFilter() {
    }

    @JustForTest
    public CryptoConfigFileFilter(Crypto crypto, RSAService rsaService, CryptoConfig cryptoConfig, Map<String, Crypto> cryptoMap) {
        this.crypto = crypto;
        this.rsaService = rsaService;
        this.cryptoConfig = cryptoConfig;
        this.cryptoMap = cryptoMap;
    }

    @Override
    public String getName() {
        return "crypto";
    }

    @Override
    public PluginType getType() {
        return PluginTypes.CONFIG_FILTER.getBaseType();
    }

    @Override
    public void init(InitContext ctx) throws PolarisException {
        ConfigFilterConfig configFilterConfig = ctx.getConfig().getConfigFile().getConfigFilterConfig();
        if (configFilterConfig == null || !configFilterConfig.isEnable()) {
            return;
        }
        this.cryptoMap = new HashMap<String, Crypto>();
        this.rsaService = new RSAService();
        this.cryptoConfig = configFilterConfig.getPluginConfig(this.getName(), CryptoConfigImpl.class);
        ctx.getPlugins().getPlugins(PluginTypes.CRYPTO.getBaseType()).forEach(plugin -> this.cryptoMap.put(plugin.getName(), (Crypto)plugin));
        this.crypto = this.cryptoMap.get(this.cryptoConfig.getType());
    }

    @Override
    public void postContextInit(Extensions ctx) throws PolarisException {
    }

    @Override
    public void destroy() {
    }
}

