/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.otlp.metrics;

import java.io.IOException;
import java.util.Collection;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.marshal.Marshaler;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.marshal.MarshalerUtil;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.marshal.MarshalerWithSize;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.marshal.ProtoFieldInfo;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.marshal.Serializer;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.otlp.KeyValueMarshaler;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.otlp.metrics.ValueAtQuantileMarshaler;
import org.apache.shardingsphere.shade.io.opentelemetry.proto.metrics.v1.internal.SummaryDataPoint;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.data.SummaryPointData;

final class SummaryDataPointMarshaler
extends MarshalerWithSize {
    private final long startTimeUnixNano;
    private final long timeUnixNano;
    private final long count;
    private final double sum;
    private final ValueAtQuantileMarshaler[] quantileValues;
    private final MarshalerWithSize[] attributes;

    static SummaryDataPointMarshaler[] createRepeated(Collection<SummaryPointData> points) {
        SummaryDataPointMarshaler[] marshalers = new SummaryDataPointMarshaler[points.size()];
        int index = 0;
        for (SummaryPointData point : points) {
            marshalers[index++] = SummaryDataPointMarshaler.create(point);
        }
        return marshalers;
    }

    static SummaryDataPointMarshaler create(SummaryPointData point) {
        ValueAtQuantileMarshaler[] quantileMarshalers = ValueAtQuantileMarshaler.createRepeated(point.getValues());
        MarshalerWithSize[] attributeMarshalers = KeyValueMarshaler.createForAttributes(point.getAttributes());
        return new SummaryDataPointMarshaler(point.getStartEpochNanos(), point.getEpochNanos(), point.getCount(), point.getSum(), quantileMarshalers, attributeMarshalers);
    }

    private SummaryDataPointMarshaler(long startTimeUnixNano, long timeUnixNano, long count, double sum, ValueAtQuantileMarshaler[] quantileValues, MarshalerWithSize[] attributes) {
        super(SummaryDataPointMarshaler.calculateSize(startTimeUnixNano, timeUnixNano, count, sum, quantileValues, attributes));
        this.startTimeUnixNano = startTimeUnixNano;
        this.timeUnixNano = timeUnixNano;
        this.count = count;
        this.sum = sum;
        this.quantileValues = quantileValues;
        this.attributes = attributes;
    }

    @Override
    public void writeTo(Serializer output) throws IOException {
        output.serializeFixed64(SummaryDataPoint.START_TIME_UNIX_NANO, this.startTimeUnixNano);
        output.serializeFixed64(SummaryDataPoint.TIME_UNIX_NANO, this.timeUnixNano);
        output.serializeFixed64(SummaryDataPoint.COUNT, this.count);
        output.serializeDouble(SummaryDataPoint.SUM, this.sum);
        output.serializeRepeatedMessage(SummaryDataPoint.QUANTILE_VALUES, this.quantileValues);
        output.serializeRepeatedMessage(SummaryDataPoint.ATTRIBUTES, this.attributes);
    }

    private static int calculateSize(long startTimeUnixNano, long timeUnixNano, long count, double sum, ValueAtQuantileMarshaler[] quantileValues, MarshalerWithSize[] attributes) {
        int size = 0;
        size += MarshalerUtil.sizeFixed64(SummaryDataPoint.START_TIME_UNIX_NANO, startTimeUnixNano);
        size += MarshalerUtil.sizeFixed64(SummaryDataPoint.TIME_UNIX_NANO, timeUnixNano);
        size += MarshalerUtil.sizeFixed64(SummaryDataPoint.COUNT, count);
        size += MarshalerUtil.sizeDouble(SummaryDataPoint.SUM, sum);
        size += MarshalerUtil.sizeRepeatedMessage((ProtoFieldInfo)SummaryDataPoint.QUANTILE_VALUES, (Marshaler[])quantileValues);
        return size += MarshalerUtil.sizeRepeatedMessage((ProtoFieldInfo)SummaryDataPoint.ATTRIBUTES, (Marshaler[])attributes);
    }
}

