/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mask.distsql.parser.core;

import java.util.Collection;
import java.util.Properties;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.shardingsphere.distsql.parser.autogen.MaskDistSQLStatementBaseVisitor;
import org.apache.shardingsphere.distsql.parser.autogen.MaskDistSQLStatementParser;
import org.apache.shardingsphere.distsql.segment.AlgorithmSegment;
import org.apache.shardingsphere.distsql.statement.ral.queryable.show.ShowPluginsStatement;
import org.apache.shardingsphere.distsql.statement.rql.rule.database.CountRuleStatement;
import org.apache.shardingsphere.infra.database.core.metadata.database.enums.QuoteCharacter;
import org.apache.shardingsphere.mask.distsql.segment.MaskColumnSegment;
import org.apache.shardingsphere.mask.distsql.segment.MaskRuleSegment;
import org.apache.shardingsphere.mask.distsql.statement.AlterMaskRuleStatement;
import org.apache.shardingsphere.mask.distsql.statement.CreateMaskRuleStatement;
import org.apache.shardingsphere.mask.distsql.statement.DropMaskRuleStatement;
import org.apache.shardingsphere.mask.distsql.statement.ShowMaskRulesStatement;
import org.apache.shardingsphere.sql.parser.api.ASTNode;
import org.apache.shardingsphere.sql.parser.api.visitor.SQLVisitor;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.DatabaseSegment;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;

public final class MaskDistSQLStatementVisitor
extends MaskDistSQLStatementBaseVisitor<ASTNode>
implements SQLVisitor<ASTNode> {
    @Override
    public ASTNode visitCreateMaskRule(MaskDistSQLStatementParser.CreateMaskRuleContext ctx) {
        return new CreateMaskRuleStatement(null != ctx.ifNotExists(), (Collection)ctx.maskRuleDefinition().stream().map(each -> (MaskRuleSegment)this.visit((ParseTree)each)).collect(Collectors.toList()));
    }

    @Override
    public ASTNode visitAlterMaskRule(MaskDistSQLStatementParser.AlterMaskRuleContext ctx) {
        return new AlterMaskRuleStatement((Collection)ctx.maskRuleDefinition().stream().map(each -> (MaskRuleSegment)this.visit((ParseTree)each)).collect(Collectors.toList()));
    }

    @Override
    public ASTNode visitDropMaskRule(MaskDistSQLStatementParser.DropMaskRuleContext ctx) {
        return new DropMaskRuleStatement(null != ctx.ifExists(), (Collection)ctx.ruleName().stream().map(this::getIdentifierValue).collect(Collectors.toList()));
    }

    @Override
    public ASTNode visitShowMaskRules(MaskDistSQLStatementParser.ShowMaskRulesContext ctx) {
        return new ShowMaskRulesStatement(null == ctx.RULE() ? null : this.getIdentifierValue((ParseTree)ctx.ruleName()), null == ctx.databaseName() ? null : (DatabaseSegment)this.visit((ParseTree)ctx.databaseName()));
    }

    @Override
    public ASTNode visitCountMaskRule(MaskDistSQLStatementParser.CountMaskRuleContext ctx) {
        return new CountRuleStatement(null == ctx.databaseName() ? null : (DatabaseSegment)this.visit((ParseTree)ctx.databaseName()), "MASK");
    }

    @Override
    public ASTNode visitMaskRuleDefinition(MaskDistSQLStatementParser.MaskRuleDefinitionContext ctx) {
        return new MaskRuleSegment(this.getIdentifierValue((ParseTree)ctx.ruleName()), (Collection)ctx.columnDefinition().stream().map(each -> (MaskColumnSegment)this.visit((ParseTree)each)).collect(Collectors.toList()));
    }

    @Override
    public ASTNode visitColumnDefinition(MaskDistSQLStatementParser.ColumnDefinitionContext ctx) {
        return new MaskColumnSegment(this.getIdentifierValue((ParseTree)ctx.columnName()), (AlgorithmSegment)this.visit((ParseTree)ctx.algorithmDefinition()));
    }

    @Override
    public ASTNode visitAlgorithmDefinition(MaskDistSQLStatementParser.AlgorithmDefinitionContext ctx) {
        return new AlgorithmSegment(this.getIdentifierValue((ParseTree)ctx.algorithmTypeName()), this.getProperties(ctx.propertiesDefinition()));
    }

    private String getIdentifierValue(ParseTree context) {
        return null == context ? null : new IdentifierValue(context.getText()).getValue();
    }

    private Properties getProperties(MaskDistSQLStatementParser.PropertiesDefinitionContext ctx) {
        Properties result = new Properties();
        if (null == ctx || null == ctx.properties()) {
            return result;
        }
        for (MaskDistSQLStatementParser.PropertyContext each : ctx.properties().property()) {
            result.setProperty(QuoteCharacter.unwrapAndTrimText((String)each.key.getText()), QuoteCharacter.unwrapAndTrimText((String)each.value.getText()));
        }
        return result;
    }

    @Override
    public ASTNode visitDatabaseName(MaskDistSQLStatementParser.DatabaseNameContext ctx) {
        return new DatabaseSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), new IdentifierValue(ctx.getText()));
    }

    @Override
    public ASTNode visitShowMaskAlgorithmPlugins(MaskDistSQLStatementParser.ShowMaskAlgorithmPluginsContext ctx) {
        return new ShowPluginsStatement("MASK_ALGORITHM");
    }
}

