/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.distsql.handler.executor.ral.plugin;

import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.database.core.spi.DatabaseSupportedTypedSPI;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.merge.result.impl.local.LocalDataQueryResultRow;
import org.apache.shardingsphere.infra.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.infra.spi.annotation.SPIDescription;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPI;

public final class PluginMetaDataQueryResultRow {
    private final boolean containsDatabaseTypes;
    private final String type;
    private final String typeAliases;
    private final String supportedDatabaseTypes;
    private final String description;

    public PluginMetaDataQueryResultRow(TypedSPI plugin) {
        this.containsDatabaseTypes = plugin instanceof DatabaseSupportedTypedSPI;
        this.type = String.valueOf(plugin.getType());
        this.typeAliases = plugin.getTypeAliases().stream().map(Object::toString).collect(Collectors.joining(","));
        this.supportedDatabaseTypes = this.containsDatabaseTypes ? this.getSupportedDatabaseTypes(((DatabaseSupportedTypedSPI)plugin).getSupportedDatabaseTypes()).stream().map(DatabaseType::getType).collect(Collectors.joining(",")) : "";
        SPIDescription description = plugin.getClass().getAnnotation(SPIDescription.class);
        this.description = null == description ? "" : description.value();
    }

    private Collection<DatabaseType> getSupportedDatabaseTypes(Collection<DatabaseType> supportedDatabaseTypes) {
        return supportedDatabaseTypes.isEmpty() ? ShardingSphereServiceLoader.getServiceInstances(DatabaseType.class) : supportedDatabaseTypes;
    }

    public LocalDataQueryResultRow toLocalDataQueryResultRow() {
        return this.containsDatabaseTypes ? new LocalDataQueryResultRow(new Object[]{this.type, this.typeAliases, this.supportedDatabaseTypes, this.description}) : new LocalDataQueryResultRow(new Object[]{this.type, this.typeAliases, this.description});
    }
}

