/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.datasource.creator;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import javax.sql.DataSource;
import org.apache.shardingsphere.authority.yaml.config.YamlAuthorityRuleConfiguration;
import org.apache.shardingsphere.data.pipeline.spi.PipelineDataSourceCreator;
import org.apache.shardingsphere.driver.api.ShardingSphereDataSourceFactory;
import org.apache.shardingsphere.infra.algorithm.core.yaml.YamlAlgorithmConfiguration;
import org.apache.shardingsphere.infra.config.mode.ModeConfiguration;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.infra.config.props.temporary.TemporaryConfigurationPropertyKey;
import org.apache.shardingsphere.infra.datasource.pool.destroyer.DataSourcePoolDestroyer;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.infra.yaml.config.pojo.YamlRootConfiguration;
import org.apache.shardingsphere.infra.yaml.config.pojo.mode.YamlModeConfiguration;
import org.apache.shardingsphere.infra.yaml.config.pojo.mode.YamlPersistRepositoryConfiguration;
import org.apache.shardingsphere.infra.yaml.config.swapper.mode.YamlModeConfigurationSwapper;
import org.apache.shardingsphere.infra.yaml.config.swapper.resource.YamlDataSourceConfigurationSwapper;
import org.apache.shardingsphere.infra.yaml.config.swapper.rule.YamlRuleConfigurationSwapperEngine;
import org.apache.shardingsphere.mode.repository.standalone.jdbc.props.JDBCRepositoryPropertyKey;
import org.apache.shardingsphere.sharding.yaml.config.YamlShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.yaml.swapper.ShardingRuleConfigurationConverter;

public final class ShardingSpherePipelineDataSourceCreator
implements PipelineDataSourceCreator {
    private static final AtomicInteger STANDALONE_DATABASE_ID = new AtomicInteger(1);

    public DataSource create(Object dataSourceConfig) throws SQLException {
        YamlRootConfiguration yamlRootConfig = (YamlRootConfiguration)YamlEngine.unmarshal((String)YamlEngine.marshal((Object)dataSourceConfig), YamlRootConfiguration.class);
        this.removeAuthorityRuleConfiguration(yamlRootConfig);
        this.updateConfigurationProperties(yamlRootConfig);
        this.updateShardingRuleConfiguration(yamlRootConfig);
        yamlRootConfig.setMode(this.createStandaloneModeConfiguration());
        return this.createShardingSphereDataSource(yamlRootConfig);
    }

    private void removeAuthorityRuleConfiguration(YamlRootConfiguration yamlRootConfig) {
        yamlRootConfig.getRules().removeIf(YamlAuthorityRuleConfiguration.class::isInstance);
    }

    private void updateConfigurationProperties(YamlRootConfiguration yamlRootConfig) {
        Properties newProps = new Properties();
        for (String each : Arrays.asList(ConfigurationPropertyKey.KERNEL_EXECUTOR_SIZE.getKey(), ConfigurationPropertyKey.SYSTEM_LOG_LEVEL.getKey(), ConfigurationPropertyKey.SQL_SHOW.getKey())) {
            Object value = yamlRootConfig.getProps().get(each);
            if (null == value) continue;
            newProps.put(each, value);
        }
        newProps.put(TemporaryConfigurationPropertyKey.SYSTEM_SCHEMA_METADATA_ASSEMBLY_ENABLED.getKey(), String.valueOf(Boolean.FALSE));
        newProps.put(ConfigurationPropertyKey.MAX_CONNECTIONS_SIZE_PER_QUERY.getKey(), (Object)100000);
        yamlRootConfig.setProps(newProps);
    }

    private void updateShardingRuleConfiguration(YamlRootConfiguration yamlRootConfig) {
        Optional yamlShardingRuleConfig = ShardingRuleConfigurationConverter.findYamlShardingRuleConfiguration((Collection)yamlRootConfig.getRules());
        if (yamlShardingRuleConfig.isPresent()) {
            this.enableRangeQueryForInline((YamlShardingRuleConfiguration)yamlShardingRuleConfig.get());
            this.removeAuditStrategy((YamlShardingRuleConfiguration)yamlShardingRuleConfig.get());
        }
    }

    private void enableRangeQueryForInline(YamlShardingRuleConfiguration yamlShardingRuleConfig) {
        for (YamlAlgorithmConfiguration each : yamlShardingRuleConfig.getShardingAlgorithms().values()) {
            if (!"INLINE".equalsIgnoreCase(each.getType())) continue;
            each.getProps().put("allow-range-query-with-inline-sharding", Boolean.TRUE.toString());
        }
    }

    private void removeAuditStrategy(YamlShardingRuleConfiguration yamlShardingRuleConfig) {
        yamlShardingRuleConfig.setDefaultAuditStrategy(null);
        yamlShardingRuleConfig.setAuditors(null);
        if (null != yamlShardingRuleConfig.getTables()) {
            yamlShardingRuleConfig.getTables().forEach((key, value) -> value.setAuditStrategy(null));
        }
        if (null != yamlShardingRuleConfig.getAutoTables()) {
            yamlShardingRuleConfig.getAutoTables().forEach((key, value) -> value.setAuditStrategy(null));
        }
    }

    private YamlModeConfiguration createStandaloneModeConfiguration() {
        YamlModeConfiguration result = new YamlModeConfiguration();
        result.setType("Standalone");
        YamlPersistRepositoryConfiguration yamlRepositoryConfig = new YamlPersistRepositoryConfiguration();
        yamlRepositoryConfig.setType("JDBC");
        yamlRepositoryConfig.getProps().setProperty(JDBCRepositoryPropertyKey.JDBC_URL.getKey(), String.format("jdbc:h2:mem:pipeline_db_%d;DB_CLOSE_DELAY=0;DATABASE_TO_UPPER=false;MODE=MYSQL", STANDALONE_DATABASE_ID.getAndIncrement()));
        result.setRepository(yamlRepositoryConfig);
        return result;
    }

    private DataSource createShardingSphereDataSource(YamlRootConfiguration yamlRootConfig) throws SQLException {
        Map dataSourceMap = new YamlDataSourceConfigurationSwapper().swapToDataSources(yamlRootConfig.getDataSources(), false);
        try {
            return this.createShardingSphereDataSource(dataSourceMap, yamlRootConfig);
        }
        catch (RuntimeException | SQLException ex) {
            dataSourceMap.values().stream().map(DataSourcePoolDestroyer::new).forEach(DataSourcePoolDestroyer::asyncDestroy);
            throw ex;
        }
    }

    private DataSource createShardingSphereDataSource(Map<String, DataSource> dataSourceMap, YamlRootConfiguration yamlRootConfig) throws SQLException {
        ModeConfiguration modeConfig = new YamlModeConfigurationSwapper().swapToObject(yamlRootConfig.getMode());
        Collection ruleConfigs = new YamlRuleConfigurationSwapperEngine().swapToRuleConfigurations(yamlRootConfig.getRules());
        return ShardingSphereDataSourceFactory.createDataSource((String)yamlRootConfig.getDatabaseName(), (ModeConfiguration)modeConfig, dataSourceMap, (Collection)ruleConfigs, (Properties)yamlRootConfig.getProps());
    }

    public String getType() {
        return "ShardingSphereJDBC";
    }
}

