/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.opengauss.authentication;

import com.google.common.base.Strings;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.ssl.SslHandler;
import java.util.Optional;
import org.apache.shardingsphere.authentication.Authenticator;
import org.apache.shardingsphere.authentication.AuthenticatorFactory;
import org.apache.shardingsphere.authentication.result.AuthenticationResult;
import org.apache.shardingsphere.authentication.result.AuthenticationResultBuilder;
import org.apache.shardingsphere.authority.checker.AuthorityChecker;
import org.apache.shardingsphere.authority.rule.AuthorityRule;
import org.apache.shardingsphere.db.protocol.constant.CommonConstants;
import org.apache.shardingsphere.db.protocol.constant.DatabaseProtocolServerInfo;
import org.apache.shardingsphere.db.protocol.opengauss.constant.OpenGaussProtocolVersion;
import org.apache.shardingsphere.db.protocol.opengauss.packet.authentication.OpenGaussAuthenticationHexData;
import org.apache.shardingsphere.db.protocol.opengauss.packet.authentication.OpenGaussAuthenticationSCRAMSha256Packet;
import org.apache.shardingsphere.db.protocol.payload.PacketPayload;
import org.apache.shardingsphere.db.protocol.postgresql.constant.PostgreSQLAuthenticationMethod;
import org.apache.shardingsphere.db.protocol.postgresql.packet.generic.PostgreSQLReadyForQueryPacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.handshake.PostgreSQLAuthenticationOKPacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.handshake.PostgreSQLComStartupPacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.handshake.PostgreSQLParameterStatusPacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.handshake.PostgreSQLPasswordMessagePacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.handshake.PostgreSQLRandomGenerator;
import org.apache.shardingsphere.db.protocol.postgresql.packet.handshake.PostgreSQLSSLUnwillingPacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.handshake.PostgreSQLSSLWillingPacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.handshake.authentication.PostgreSQLMD5PasswordAuthenticationPacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.identifier.PostgreSQLIdentifierPacket;
import org.apache.shardingsphere.db.protocol.postgresql.packet.identifier.PostgreSQLMessagePacketType;
import org.apache.shardingsphere.db.protocol.postgresql.payload.PostgreSQLPacketPayload;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.dialect.exception.syntax.database.UnknownDatabaseException;
import org.apache.shardingsphere.infra.exception.postgresql.exception.authority.EmptyUsernameException;
import org.apache.shardingsphere.infra.exception.postgresql.exception.authority.InvalidPasswordException;
import org.apache.shardingsphere.infra.exception.postgresql.exception.authority.PrivilegeNotGrantedException;
import org.apache.shardingsphere.infra.exception.postgresql.exception.authority.UnknownUsernameException;
import org.apache.shardingsphere.infra.exception.postgresql.exception.protocol.ProtocolViolationException;
import org.apache.shardingsphere.infra.metadata.user.Grantee;
import org.apache.shardingsphere.infra.metadata.user.ShardingSphereUser;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.postgresql.handler.admin.executor.variable.charset.PostgreSQLCharacterSets;
import org.apache.shardingsphere.proxy.frontend.authentication.AuthenticationEngine;
import org.apache.shardingsphere.proxy.frontend.connection.ConnectionIdGenerator;
import org.apache.shardingsphere.proxy.frontend.opengauss.authentication.authenticator.OpenGaussAuthenticatorType;
import org.apache.shardingsphere.proxy.frontend.ssl.ProxySSLContext;

public final class OpenGaussAuthenticationEngine
implements AuthenticationEngine {
    private static final int SSL_REQUEST_PAYLOAD_LENGTH = 8;
    private static final int SSL_REQUEST_CODE = 80877103;
    private static final int PROTOCOL_350_SERVER_ITERATOR = 2048;
    private static final int PROTOCOL_351_SERVER_ITERATOR = 10000;
    private final OpenGaussAuthenticationHexData authHexData = new OpenGaussAuthenticationHexData();
    private boolean startupMessageReceived;
    private String clientEncoding;
    private int serverIteration;
    private byte[] md5Salt;
    private AuthenticationResult currentAuthResult;

    public int handshake(ChannelHandlerContext context) {
        return ConnectionIdGenerator.getInstance().nextId();
    }

    public AuthenticationResult authenticate(ChannelHandlerContext context, PacketPayload payload) {
        if (8 == payload.getByteBuf().markReaderIndex().readInt() && 80877103 == payload.getByteBuf().readInt()) {
            if (ProxySSLContext.getInstance().isSSLEnabled()) {
                SslHandler sslHandler = new SslHandler(ProxySSLContext.getInstance().newSSLEngine(context.alloc()), true);
                context.pipeline().addFirst(SslHandler.class.getSimpleName(), (ChannelHandler)sslHandler);
                context.writeAndFlush((Object)new PostgreSQLSSLWillingPacket());
            } else {
                context.writeAndFlush((Object)new PostgreSQLSSLUnwillingPacket());
            }
            return AuthenticationResultBuilder.continued();
        }
        payload.getByteBuf().resetReaderIndex();
        AuthorityRule rule = (AuthorityRule)ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getGlobalRuleMetaData().getSingleRule(AuthorityRule.class);
        return this.startupMessageReceived ? this.processPasswordMessage(context, (PostgreSQLPacketPayload)payload, rule) : this.processStartupMessage(context, (PostgreSQLPacketPayload)payload, rule);
    }

    private AuthenticationResult processPasswordMessage(ChannelHandlerContext context, PostgreSQLPacketPayload payload, AuthorityRule rule) {
        char messageType = (char)payload.readInt1();
        ShardingSpherePreconditions.checkState((PostgreSQLMessagePacketType.PASSWORD_MESSAGE.getValue() == messageType ? 1 : 0) != 0, () -> new ProtocolViolationException("password", Character.toString(messageType)));
        PostgreSQLPasswordMessagePacket passwordMessagePacket = new PostgreSQLPasswordMessagePacket(payload);
        this.login(rule, passwordMessagePacket.getDigest());
        context.write((Object)new PostgreSQLAuthenticationOKPacket());
        context.write((Object)new PostgreSQLParameterStatusPacket("server_version", DatabaseProtocolServerInfo.getProtocolVersion((String)this.currentAuthResult.getDatabase(), (DatabaseType)((DatabaseType)TypedSPILoader.getService(DatabaseType.class, (Object)"openGauss")))));
        context.write((Object)new PostgreSQLParameterStatusPacket("client_encoding", this.clientEncoding));
        context.write((Object)new PostgreSQLParameterStatusPacket("server_encoding", "UTF8"));
        context.write((Object)new PostgreSQLParameterStatusPacket("integer_datetimes", "on"));
        context.writeAndFlush((Object)PostgreSQLReadyForQueryPacket.NOT_IN_TRANSACTION);
        return AuthenticationResultBuilder.finished((String)this.currentAuthResult.getUsername(), (String)"", (String)this.currentAuthResult.getDatabase());
    }

    private void login(AuthorityRule rule, String digest) {
        String username = this.currentAuthResult.getUsername();
        String databaseName = this.currentAuthResult.getDatabase();
        ShardingSpherePreconditions.checkState((Strings.isNullOrEmpty((String)databaseName) || ProxyContext.getInstance().databaseExists(databaseName) ? 1 : 0) != 0, () -> new UnknownDatabaseException(databaseName));
        Grantee grantee = new Grantee(username);
        ShardingSphereUser user = (ShardingSphereUser)rule.findUser(grantee).orElseThrow(() -> new UnknownUsernameException(username));
        Authenticator authenticator = new AuthenticatorFactory(OpenGaussAuthenticatorType.class, rule).newInstance(user);
        ShardingSpherePreconditions.checkState((boolean)this.login(authenticator, user, digest), () -> new InvalidPasswordException(username));
        ShardingSpherePreconditions.checkState((null == databaseName || new AuthorityChecker(rule, grantee).isAuthorized(databaseName) ? 1 : 0) != 0, () -> new PrivilegeNotGrantedException(username, databaseName));
    }

    private boolean login(Authenticator authenticator, ShardingSphereUser user, String digest) {
        if (PostgreSQLAuthenticationMethod.MD5.getMethodName().equals(authenticator.getAuthenticationMethodName())) {
            return authenticator.authenticate(user, new Object[]{digest, this.md5Salt});
        }
        return authenticator.authenticate(user, new Object[]{digest, this.authHexData.getSalt(), this.authHexData.getNonce(), this.serverIteration});
    }

    private AuthenticationResult processStartupMessage(ChannelHandlerContext context, PostgreSQLPacketPayload payload, AuthorityRule rule) {
        this.startupMessageReceived = true;
        PostgreSQLComStartupPacket startupPacket = new PostgreSQLComStartupPacket(payload);
        this.clientEncoding = startupPacket.getClientEncoding();
        context.channel().attr(CommonConstants.CHARSET_ATTRIBUTE_KEY).set((Object)PostgreSQLCharacterSets.findCharacterSet((String)this.clientEncoding));
        String username = startupPacket.getUsername();
        ShardingSpherePreconditions.checkNotEmpty((String)username, EmptyUsernameException::new);
        context.writeAndFlush((Object)this.getIdentifierPacket(username, rule, startupPacket.getVersion()));
        this.currentAuthResult = AuthenticationResultBuilder.continued((String)username, (String)"", (String)startupPacket.getDatabase());
        return this.currentAuthResult;
    }

    private PostgreSQLIdentifierPacket getIdentifierPacket(String username, AuthorityRule rule, int version) {
        Optional<Authenticator> authenticator = rule.findUser(new Grantee(username)).map(optional -> new AuthenticatorFactory(OpenGaussAuthenticatorType.class, rule).newInstance(optional));
        if (authenticator.isPresent() && PostgreSQLAuthenticationMethod.MD5.getMethodName().equals(authenticator.get().getAuthenticationMethodName())) {
            this.md5Salt = PostgreSQLRandomGenerator.getInstance().generateRandomBytes(4);
            return new PostgreSQLMD5PasswordAuthenticationPacket(this.md5Salt);
        }
        this.serverIteration = version == OpenGaussProtocolVersion.PROTOCOL_350.getVersion() ? 2048 : 10000;
        String password = rule.findUser(new Grantee(username)).map(ShardingSphereUser::getPassword).orElse("");
        return new OpenGaussAuthenticationSCRAMSha256Packet(version, this.serverIteration, this.authHexData, password);
    }
}

