/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.context;

import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.database.DatabaseTypeEngine;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.resource.unit.StorageUnit;
import org.apache.shardingsphere.infra.state.instance.InstanceStateContext;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.proxy.backend.connector.jdbc.datasource.JDBCBackendDataSource;

public final class ProxyContext {
    private static final ProxyContext INSTANCE = new ProxyContext();
    private final JDBCBackendDataSource backendDataSource = new JDBCBackendDataSource();
    private ContextManager contextManager;

    public static void init(ContextManager contextManager) {
        ProxyContext.INSTANCE.contextManager = contextManager;
    }

    public static ProxyContext getInstance() {
        return INSTANCE;
    }

    public boolean databaseExists(String name) {
        return this.contextManager.getMetaDataContexts().getMetaData().containsDatabase(name);
    }

    public Collection<String> getAllDatabaseNames() {
        return this.contextManager.getMetaDataContexts().getMetaData().getAllDatabases().stream().map(ShardingSphereDatabase::getName).collect(Collectors.toList());
    }

    public Optional<InstanceStateContext> getInstanceStateContext() {
        return null == this.contextManager.getComputeNodeInstanceContext() ? Optional.empty() : Optional.ofNullable(this.contextManager.getComputeNodeInstanceContext().getInstance().getState());
    }

    public DatabaseType getDatabaseType() {
        Collection databases = this.contextManager.getMetaDataContexts().getMetaData().getAllDatabases();
        return databases.stream().flatMap(each -> each.getResourceMetaData().getStorageUnits().values().stream()).findFirst().map(StorageUnit::getStorageType).orElseGet(DatabaseTypeEngine::getDefaultStorageType);
    }

    @Generated
    private ProxyContext() {
    }

    @Generated
    public JDBCBackendDataSource getBackendDataSource() {
        return this.backendDataSource;
    }

    @Generated
    public ContextManager getContextManager() {
        return this.contextManager;
    }
}

