/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.context.statement.ddl;

import java.util.Collection;
import java.util.LinkedList;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.segment.table.TablesContext;
import org.apache.shardingsphere.infra.binder.context.statement.CommonSQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.type.TableAvailable;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.table.RenameTableDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.RenameTableStatement;

public final class RenameTableStatementContext
extends CommonSQLStatementContext
implements TableAvailable {
    private final TablesContext tablesContext;

    public RenameTableStatementContext(RenameTableStatement sqlStatement) {
        super((SQLStatement)sqlStatement);
        this.tablesContext = new TablesContext(this.getTables(sqlStatement));
    }

    private Collection<SimpleTableSegment> getTables(RenameTableStatement sqlStatement) {
        LinkedList<SimpleTableSegment> result = new LinkedList<SimpleTableSegment>();
        for (RenameTableDefinitionSegment each : sqlStatement.getRenameTables()) {
            result.add(each.getTable());
            result.add(each.getRenameTable());
        }
        return result;
    }

    public RenameTableStatement getSqlStatement() {
        return (RenameTableStatement)super.getSqlStatement();
    }

    @Override
    @Generated
    public TablesContext getTablesContext() {
        return this.tablesContext;
    }
}

