/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.context.statement.ddl;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.segment.table.TablesContext;
import org.apache.shardingsphere.infra.binder.context.statement.CommonSQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.binder.context.type.CursorAvailable;
import org.apache.shardingsphere.infra.binder.context.type.TableAvailable;
import org.apache.shardingsphere.infra.binder.context.type.WhereAvailable;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.sql.parser.statement.core.extractor.TableExtractor;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.cursor.CursorNameSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.BinaryOperationExpression;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.CursorStatement;

public final class CursorStatementContext
extends CommonSQLStatementContext
implements CursorAvailable,
TableAvailable,
WhereAvailable {
    private final Collection<WhereSegment> whereSegments = new LinkedList<WhereSegment>();
    private final Collection<ColumnSegment> columnSegments = new LinkedList<ColumnSegment>();
    private final Collection<BinaryOperationExpression> joinConditions = new LinkedList<BinaryOperationExpression>();
    private final TablesContext tablesContext = new TablesContext(this.getSimpleTableSegments());
    private final SelectStatementContext selectStatementContext;

    public CursorStatementContext(ShardingSphereMetaData metaData, List<Object> params, CursorStatement sqlStatement, String currentDatabaseName) {
        super((SQLStatement)sqlStatement);
        this.selectStatementContext = new SelectStatementContext(metaData, params, sqlStatement.getSelect(), currentDatabaseName, Collections.emptyList());
        this.whereSegments.addAll(this.selectStatementContext.getWhereSegments());
        this.columnSegments.addAll(this.selectStatementContext.getColumnSegments());
        this.joinConditions.addAll(this.selectStatementContext.getJoinConditions());
    }

    private Collection<SimpleTableSegment> getSimpleTableSegments() {
        TableExtractor tableExtractor = new TableExtractor();
        tableExtractor.extractTablesFromSelect(this.getSqlStatement().getSelect());
        return tableExtractor.getRewriteTables();
    }

    public CursorStatement getSqlStatement() {
        return (CursorStatement)super.getSqlStatement();
    }

    @Override
    public Optional<CursorNameSegment> getCursorName() {
        return Optional.of(this.getSqlStatement().getCursorName());
    }

    @Override
    public Collection<WhereSegment> getWhereSegments() {
        return this.whereSegments;
    }

    @Override
    public Collection<ColumnSegment> getColumnSegments() {
        return this.columnSegments;
    }

    @Override
    public Collection<BinaryOperationExpression> getJoinConditions() {
        return this.joinConditions;
    }

    @Override
    @Generated
    public TablesContext getTablesContext() {
        return this.tablesContext;
    }

    @Generated
    public SelectStatementContext getSelectStatementContext() {
        return this.selectStatementContext;
    }
}

