/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.util;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.Deque;
import java.util.HashSet;
import java.util.Set;

public class ClassLoadingHelper {
    private static Set<String> javaLangObjectMethodNames = new HashSet<String>();
    private static ClassLoader lastGoodClassLoader;
    private static boolean fallbackToMinimumSetOfInterfaces;

    public static boolean existsInJavaObjectClass(Method method) {
        return javaLangObjectMethodNames.contains(method.getName());
    }

    private static <RequiredInterfaceType> RequiredInterfaceType newProxyInstance(Deque<ClassLoader> classLoadersToTry, Class<?>[] interfaces, InvocationHandler delegate) throws IllegalArgumentException {
        Object ret = null;
        ClassLoader cl = classLoadersToTry.pop();
        try {
            ret = Proxy.newProxyInstance(cl, interfaces, delegate);
            lastGoodClassLoader = cl;
        }
        catch (IllegalArgumentException someClassNotFound) {
            if (!classLoadersToTry.isEmpty()) {
                ret = ClassLoadingHelper.newProxyInstance(classLoadersToTry, interfaces, delegate);
            }
            throw someClassNotFound;
        }
        return (RequiredInterfaceType)ret;
    }

    private static <RequiredInterfaceType> RequiredInterfaceType newProxyInstanceStartingWithLastGoodClassLoader(Deque<ClassLoader> classLoadersToTry, Class<?>[] interfaces, InvocationHandler delegate) throws IllegalArgumentException {
        Object ret = null;
        if (lastGoodClassLoader != null) {
            try {
                ret = Proxy.newProxyInstance(lastGoodClassLoader, interfaces, delegate);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (ret == null) {
            ret = ClassLoadingHelper.newProxyInstance(classLoadersToTry, interfaces, delegate);
        }
        return (RequiredInterfaceType)ret;
    }

    public static <RequiredInterfaceType> RequiredInterfaceType newProxyInstance(Deque<ClassLoader> classLoadersToTry, Class<RequiredInterfaceType> requiredInterfaceType, Class<?>[] interfaces, InvocationHandler delegate) throws IllegalArgumentException {
        RequiredInterfaceType ret = null;
        if (fallbackToMinimumSetOfInterfaces) {
            Class[] minimumSetOfInterfaces = new Class[]{requiredInterfaceType};
            ret = ClassLoadingHelper.newProxyInstanceStartingWithLastGoodClassLoader(classLoadersToTry, minimumSetOfInterfaces, delegate);
        } else {
            try {
                ret = ClassLoadingHelper.newProxyInstanceStartingWithLastGoodClassLoader(classLoadersToTry, interfaces, delegate);
            }
            catch (IllegalAccessError | IllegalArgumentException someClassNotFound) {
                fallbackToMinimumSetOfInterfaces = true;
                Class[] minimumSetOfInterfaces = new Class[]{requiredInterfaceType};
                ret = ClassLoadingHelper.newProxyInstanceStartingWithLastGoodClassLoader(classLoadersToTry, minimumSetOfInterfaces, delegate);
            }
        }
        return ret;
    }

    public static <T> Class<T> loadClass(String className) throws ClassNotFoundException {
        Class<?> clazz = null;
        try {
            clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException nf) {
            clazz = Class.forName(className);
        }
        return clazz;
    }

    public static URL loadResourceFromClasspath(Class<?> clazz, String resourceName) {
        URL ret = null;
        ret = clazz.getResource(resourceName);
        if (ret == null) {
            ret = clazz.getResource("/" + resourceName);
        }
        return ret;
    }

    public static Object newInstance(String className) {
        try {
            Class clazz = ClassLoadingHelper.loadClass(className);
            return clazz.newInstance();
        }
        catch (ClassNotFoundException clazz) {
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    static {
        try {
            MethodDescriptor[] methods;
            BeanInfo infos = Introspector.getBeanInfo(Object.class);
            for (MethodDescriptor methodDescriptor : methods = infos.getMethodDescriptors()) {
                javaLangObjectMethodNames.add(methodDescriptor.getName());
            }
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
        fallbackToMinimumSetOfInterfaces = false;
    }
}

