/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.conditionevaluator;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.plugin.conditionevaluator.RangerScriptConditionEvaluator;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerScriptTemplateConditionEvaluator
extends RangerScriptConditionEvaluator {
    private static final Logger LOG = LoggerFactory.getLogger(RangerScriptTemplateConditionEvaluator.class);
    protected String script;
    private boolean reverseResult;

    @Override
    public void init() {
        String expectedScriptReturn;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerScriptTemplateConditionEvaluator.init(" + this.condition + ")");
        }
        super.init();
        if (CollectionUtils.isNotEmpty(this.condition.getValues()) && StringUtils.isNotBlank((String)(expectedScriptReturn = this.condition.getValues().get(0)))) {
            if (StringUtils.equalsIgnoreCase((String)expectedScriptReturn, (String)"false") || StringUtils.equalsIgnoreCase((String)expectedScriptReturn, (String)"no")) {
                this.reverseResult = true;
            }
            this.script = MapUtils.getString(this.conditionDef.getEvaluatorOptions(), (Object)"scriptTemplate");
            if (this.script != null) {
                this.script = this.script.trim();
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerScriptTemplateConditionEvaluator.init(" + this.condition + "): script=" + this.script + "; reverseResult=" + this.reverseResult);
        }
    }

    @Override
    public boolean isMatched(RangerAccessRequest request) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerScriptTemplateConditionEvaluator.isMatched()");
        }
        boolean ret = super.isMatched(request);
        if (this.reverseResult) {
            boolean bl = ret = !ret;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerScriptTemplateConditionEvaluator.isMatched(): ret=" + ret);
        }
        return ret;
    }

    @Override
    protected String getScript() {
        return this.script;
    }
}

