/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.StreamComparator;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExplanation;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionNamedParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionValue;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.SolrNamedThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorStream
extends TupleStream
implements Expressible {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private TupleStream stream;
    private int threads;
    private ExecutorService executorService;
    private StreamFactory streamFactory;
    private StreamContext streamContext;

    public ExecutorStream(StreamExpression expression, StreamFactory factory) throws IOException {
        List<StreamExpression> streamExpressions = factory.getExpressionOperandsRepresentingTypes(expression, Expressible.class, TupleStream.class);
        StreamExpressionNamedParameter threadsParam = factory.getNamedOperand(expression, "threads");
        int threads = 6;
        if (threadsParam != null) {
            threads = Integer.parseInt(((StreamExpressionValue)threadsParam.getParameter()).getValue());
        }
        if (1 != streamExpressions.size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting a single stream but found %d", expression, streamExpressions.size()));
        }
        TupleStream stream = factory.constructStream(streamExpressions.get(0));
        this.init(stream, threads, factory);
    }

    private void init(TupleStream tupleStream, int threads, StreamFactory factory) throws IOException {
        this.threads = threads;
        this.stream = tupleStream;
        this.streamFactory = factory;
    }

    @Override
    public StreamExpression toExpression(StreamFactory factory) throws IOException {
        return this.toExpression(factory, true);
    }

    private StreamExpression toExpression(StreamFactory factory, boolean includeStreams) throws IOException {
        StreamExpression expression = new StreamExpression(factory.getFunctionName(this.getClass()));
        expression.addParameter(new StreamExpressionNamedParameter("threads", Integer.toString(this.threads)));
        if (includeStreams) {
            if (this.stream instanceof Expressible) {
                expression.addParameter(((Expressible)((Object)this.stream)).toExpression(factory));
            } else {
                throw new IOException("The ExecuteStream contains a non-expressible TupleStream - it cannot be converted to an expression");
            }
        }
        return expression;
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        return new StreamExplanation(this.getStreamNodeId().toString()).withChildren(new Explanation[]{this.stream.toExplanation(factory)}).withFunctionName(factory.getFunctionName(this.getClass())).withImplementingClass(this.getClass().getName()).withExpressionType("stream-decorator").withExpression(this.toExpression(factory, false).toString());
    }

    @Override
    public void setStreamContext(StreamContext streamContext) {
        this.streamContext = streamContext;
        this.stream.setStreamContext(streamContext);
    }

    @Override
    public List<TupleStream> children() {
        ArrayList<TupleStream> l = new ArrayList<TupleStream>();
        l.add(this.stream);
        return l;
    }

    @Override
    public void open() throws IOException {
        this.executorService = ExecutorUtil.newMDCAwareFixedThreadPool(this.threads, new SolrNamedThreadFactory("ExecutorStream"));
        this.stream.open();
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
        this.executorService.shutdown();
        try {
            this.executorService.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            log.error("Interrupted while waiting for termination", (Throwable)e);
        }
    }

    @Override
    public Tuple read() throws IOException {
        Tuple tuple;
        ArrayBlockingQueue<Tuple> queue = new ArrayBlockingQueue<Tuple>(10000);
        while (true) {
            tuple = this.stream.read();
            if (tuple.EOF) break;
            try {
                queue.put(tuple);
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
            this.executorService.execute(new StreamTask(queue, this.streamFactory, this.streamContext));
        }
        return tuple;
    }

    @Override
    public StreamComparator getStreamSort() {
        return this.stream.getStreamSort();
    }

    @Override
    public int getCost() {
        return 0;
    }

    public static class StreamTask
    implements Runnable {
        private ArrayBlockingQueue<Tuple> queue;
        private StreamFactory streamFactory;
        private StreamContext streamContext;

        public StreamTask(ArrayBlockingQueue queue, StreamFactory streamFactory, StreamContext streamContext) {
            this.queue = queue;
            this.streamFactory = streamFactory;
            this.streamContext = new StreamContext();
            this.streamContext.setObjectCache(streamContext.getObjectCache());
            this.streamContext.setSolrClientCache(streamContext.getSolrClientCache());
            this.streamContext.setModelCache(streamContext.getModelCache());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Tuple tuple = null;
            try {
                tuple = this.queue.take();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            String expr = tuple.getString("expr_s");
            Object id = tuple.get("id");
            TupleStream stream = null;
            try {
                Tuple t;
                stream = this.streamFactory.constructStream(expr);
                stream.setStreamContext(this.streamContext);
                stream.open();
                do {
                    t = stream.read();
                } while (!t.EOF);
            }
            catch (Exception e) {
                log.error("Executor Error: id={} expr_s={}", new Object[]{id, expr, e});
            }
            finally {
                try {
                    stream.close();
                }
                catch (Exception e1) {
                    log.error("Executor Error", (Throwable)e1);
                }
            }
        }
    }
}

