/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.nestedstructure.authorizer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.ranger.audit.model.AuthzAuditEvent;
import org.apache.ranger.plugin.audit.RangerDefaultAuditHandler;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;

public class NestedStructureAuditHandler
extends RangerDefaultAuditHandler {
    public static final String ACCESS_TYPE_ROWFILTER = "ROW_FILTER";
    List<AuthzAuditEvent> auditEvents = null;
    boolean deniedExists = false;

    public NestedStructureAuditHandler(Configuration config) {
        super(config);
    }

    public void processResult(RangerAccessResult result) {
        AuthzAuditEvent auditEvent;
        if (result.getIsAudited() && (auditEvent = this.createAuditEvent(result)) != null) {
            if (this.auditEvents == null) {
                this.auditEvents = new ArrayList<AuthzAuditEvent>();
            }
            this.auditEvents.add(auditEvent);
            if (auditEvent.getAccessResult() == 0) {
                this.deniedExists = true;
            }
        }
    }

    public void processResults(Collection<RangerAccessResult> results) {
        for (RangerAccessResult result : results) {
            this.processResult(result);
        }
    }

    public void flushAudit() {
        if (this.auditEvents != null) {
            for (AuthzAuditEvent auditEvent : this.auditEvents) {
                if (this.deniedExists && auditEvent.getAccessResult() != 0) continue;
                super.logAuthzAudit(auditEvent);
            }
        }
    }

    private AuthzAuditEvent createAuditEvent(RangerAccessResult result) {
        AuthzAuditEvent ret = super.getAuthzEvents(result);
        if (ret != null) {
            int policyType = result.getPolicyType();
            if (policyType == 1 && result.isMaskEnabled()) {
                ret.setAccessType(result.getMaskType());
            } else if (policyType == 2) {
                ret.setAccessType(ACCESS_TYPE_ROWFILTER);
            }
        }
        return ret;
    }
}

