/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Map;
import org.apache.ranger.authorization.utils.StringUtil;
import org.apache.ranger.plugin.model.RangerBaseModelObject;
import org.apache.ranger.plugin.model.RangerPolicy;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
public class RangerServiceResource
extends RangerBaseModelObject {
    private static final long serialVersionUID = 1L;
    private String serviceName;
    private Map<String, RangerPolicy.RangerPolicyResource> resourceElements;
    private String ownerUser;
    private String resourceSignature;
    private Map<String, String> additionalInfo;

    public RangerServiceResource(String guid, String serviceName, Map<String, RangerPolicy.RangerPolicyResource> resourceElements, String resourceSignature, String ownerUser, Map<String, String> additionalInfo) {
        this.setGuid(guid);
        this.setServiceName(serviceName);
        this.setResourceElements(resourceElements);
        this.setResourceSignature(resourceSignature);
        this.setOwnerUser(ownerUser);
        this.setAdditionalInfo(additionalInfo);
    }

    public RangerServiceResource(String guid, String serviceName, Map<String, RangerPolicy.RangerPolicyResource> resourceElements, String resourceSignature, String ownerUser) {
        this(guid, serviceName, resourceElements, resourceSignature, ownerUser, null);
    }

    public RangerServiceResource(String guid, String serviceName, Map<String, RangerPolicy.RangerPolicyResource> resourceElements, String resourceSignature) {
        this(guid, serviceName, resourceElements, resourceSignature, null);
    }

    public RangerServiceResource(String guid, String serviceName, Map<String, RangerPolicy.RangerPolicyResource> resourceElements) {
        this(guid, serviceName, resourceElements, null, null);
    }

    public RangerServiceResource(String serviceName, Map<String, RangerPolicy.RangerPolicyResource> resourceElements) {
        this(null, serviceName, resourceElements, null, null);
    }

    public RangerServiceResource() {
        this(null, null, null, null, null);
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public Map<String, RangerPolicy.RangerPolicyResource> getResourceElements() {
        return this.resourceElements;
    }

    public String getResourceSignature() {
        return this.resourceSignature;
    }

    public String getOwnerUser() {
        return this.ownerUser;
    }

    public Map<String, String> getAdditionalInfo() {
        return this.additionalInfo;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setResourceElements(Map<String, RangerPolicy.RangerPolicyResource> resource) {
        this.resourceElements = resource;
    }

    public void setResourceSignature(String resourceSignature) {
        this.resourceSignature = resourceSignature;
    }

    public void setOwnerUser(String ownerUser) {
        this.ownerUser = ownerUser;
    }

    public void setAdditionalInfo(Map<String, String> additionalInfo) {
        this.additionalInfo = additionalInfo;
    }

    @Override
    public void dedupStrings(Map<String, String> strTbl) {
        super.dedupStrings(strTbl);
        this.serviceName = StringUtil.dedupString(this.serviceName, strTbl);
        this.resourceElements = StringUtil.dedupStringsMapOfPolicyResource(this.resourceElements, strTbl);
        this.ownerUser = StringUtil.dedupString(this.ownerUser, strTbl);
        this.additionalInfo = StringUtil.dedupStringsMap(this.additionalInfo, strTbl);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb);
        return sb.toString();
    }

    @Override
    public StringBuilder toString(StringBuilder sb) {
        sb.append("RangerServiceResource={ ");
        super.toString(sb);
        sb.append("guid={").append(this.getGuid()).append("} ");
        sb.append("serviceName={").append(this.serviceName).append("} ");
        sb.append("resourceElements={");
        if (this.resourceElements != null) {
            for (Map.Entry<String, RangerPolicy.RangerPolicyResource> entry : this.resourceElements.entrySet()) {
                sb.append(entry.getKey()).append("={");
                entry.getValue().toString(sb);
                sb.append("} ");
            }
        }
        sb.append("} ");
        sb.append("ownerUser={").append(this.ownerUser).append("} ");
        sb.append("additionalInfo={");
        if (this.additionalInfo != null) {
            for (Map.Entry<String, Object> entry : this.additionalInfo.entrySet()) {
                sb.append(entry.getKey()).append("={").append((String)entry.getValue()).append("} ");
            }
        }
        sb.append("} ");
        sb.append("resourceSignature={").append(this.resourceSignature).append("} ");
        sb.append(" }");
        return sb;
    }
}

