/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.audit.provider;

import java.util.Collection;
import java.util.Iterator;
import org.apache.ranger.audit.model.AuditEventBase;
import org.apache.ranger.audit.model.AuthzAuditEvent;
import org.apache.ranger.audit.provider.BaseAuditHandler;
import org.apache.ranger.audit.provider.LogBuffer;
import org.apache.ranger.audit.provider.LogDestination;
import org.apache.ranger.audit.provider.MiscUtil;

public abstract class BufferedAuditProvider
extends BaseAuditHandler {
    private LogBuffer<AuditEventBase> mBuffer = null;
    private LogDestination<AuditEventBase> mDestination = null;

    @Override
    public boolean log(AuditEventBase event) {
        if (event instanceof AuthzAuditEvent) {
            AuthzAuditEvent authzEvent = (AuthzAuditEvent)event;
            if (authzEvent.getAgentHostname() == null) {
                authzEvent.setAgentHostname(MiscUtil.getHostname());
            }
            if (authzEvent.getLogType() == null) {
                authzEvent.setLogType("RangerAudit");
            }
            if (authzEvent.getEventId() == null) {
                authzEvent.setEventId(MiscUtil.generateUniqueId());
            }
        }
        if (!this.mBuffer.add(event)) {
            this.logFailedEvent(event);
            return false;
        }
        return true;
    }

    @Override
    public boolean log(Collection<AuditEventBase> events) {
        AuditEventBase event;
        boolean ret = true;
        Iterator<AuditEventBase> iterator = events.iterator();
        while (iterator.hasNext() && (ret = this.log(event = iterator.next()))) {
        }
        return ret;
    }

    @Override
    public boolean logJSON(String event) {
        AuditEventBase eventObj = MiscUtil.fromJson(event, AuthzAuditEvent.class);
        return this.log(eventObj);
    }

    @Override
    public boolean logJSON(Collection<String> events) {
        String event;
        boolean ret = true;
        Iterator<String> iterator = events.iterator();
        while (iterator.hasNext() && (ret = this.logJSON(event = iterator.next()))) {
        }
        return ret;
    }

    @Override
    public void start() {
        this.mBuffer.start(this.mDestination);
    }

    @Override
    public void stop() {
        this.mBuffer.stop();
    }

    @Override
    public void waitToComplete() {
    }

    @Override
    public void waitToComplete(long timeout) {
    }

    @Override
    public void flush() {
    }

    protected LogBuffer<AuditEventBase> getBuffer() {
        return this.mBuffer;
    }

    protected LogDestination<AuditEventBase> getDestination() {
        return this.mDestination;
    }

    protected void setBufferAndDestination(LogBuffer<AuditEventBase> buffer, LogDestination<AuditEventBase> destination) {
        this.mBuffer = buffer;
        this.mDestination = destination;
    }
}

