/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.util;

import java.time.Clock;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.common.util.Backoff;

public class BackoffBuilder {
    private long initial = 0L;
    private TimeUnit unitInitial = TimeUnit.MILLISECONDS;
    private long max = 0L;
    private TimeUnit unitMax = TimeUnit.MILLISECONDS;
    private Clock clock;
    private long mandatoryStop = 0L;
    private TimeUnit unitMandatoryStop = TimeUnit.MILLISECONDS;

    public BackoffBuilder() {
        this.clock = Clock.systemDefaultZone();
    }

    public BackoffBuilder setInitialTime(long initial, TimeUnit unitInitial) {
        this.unitInitial = unitInitial;
        this.initial = initial;
        return this;
    }

    public BackoffBuilder setMax(long max, TimeUnit unitMax) {
        this.unitMax = unitMax;
        this.max = max;
        return this;
    }

    public BackoffBuilder setMandatoryStop(long mandatoryStop, TimeUnit unitMandatoryStop) {
        this.mandatoryStop = mandatoryStop;
        this.unitMandatoryStop = unitMandatoryStop;
        return this;
    }

    public Backoff create() {
        return new Backoff(this.initial, this.unitInitial, this.max, this.unitMax, this.mandatoryStop, this.unitMandatoryStop, this.clock);
    }
}

