/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.clients.impl.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.apache.bookkeeper.clients.config.StorageClientSettings;
import org.apache.bookkeeper.clients.impl.channel.StorageServerChannel;
import org.apache.bookkeeper.clients.impl.channel.StorageServerChannelManager;
import org.apache.bookkeeper.clients.impl.container.StorageContainerChannel;
import org.apache.bookkeeper.clients.impl.container.StorageContainerChannelManager;
import org.apache.bookkeeper.clients.impl.internal.LocationClientImpl;
import org.apache.bookkeeper.clients.impl.internal.MetaRangeClientImpl;
import org.apache.bookkeeper.clients.impl.internal.RootRangeClientImpl;
import org.apache.bookkeeper.clients.impl.internal.RootRangeClientImplWithRetries;
import org.apache.bookkeeper.clients.impl.internal.StreamMetadataCache;
import org.apache.bookkeeper.clients.impl.internal.api.LocationClient;
import org.apache.bookkeeper.clients.impl.internal.api.MetaRangeClient;
import org.apache.bookkeeper.clients.impl.internal.api.RootRangeClient;
import org.apache.bookkeeper.clients.impl.internal.api.StorageServerClientManager;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.common.util.AbstractAutoAsyncCloseable;
import org.apache.bookkeeper.common.util.OrderedScheduler;
import org.apache.bookkeeper.common.util.SharedResourceManager;
import org.apache.bookkeeper.stream.proto.StreamProperties;
import org.apache.bookkeeper.stream.proto.common.Endpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageServerClientManagerImpl
extends AbstractAutoAsyncCloseable
implements StorageServerClientManager {
    private static final Logger log = LoggerFactory.getLogger(StorageServerClientManagerImpl.class);
    private final SharedResourceManager.Resource<OrderedScheduler> schedulerResource;
    private final OrderedScheduler scheduler;
    private final StorageServerChannelManager channelManager;
    private final StorageContainerChannelManager scChannelManager;
    private final LocationClient locationClient;
    private final RootRangeClient rootRangeClient;
    private final StreamMetadataCache streamMetadataCache;
    private final ConcurrentMap<Long, MetaRangeClientImpl> metaRangeClients;

    public StorageServerClientManagerImpl(StorageClientSettings settings, SharedResourceManager.Resource<OrderedScheduler> schedulerResource) {
        this(settings, schedulerResource, StorageServerChannel.factory(settings));
    }

    public StorageServerClientManagerImpl(StorageClientSettings settings, SharedResourceManager.Resource<OrderedScheduler> schedulerResource, Function<Endpoint, StorageServerChannel> channelFactory) {
        this.schedulerResource = schedulerResource;
        this.scheduler = (OrderedScheduler)SharedResourceManager.shared().get(schedulerResource);
        this.locationClient = new LocationClientImpl(settings, this.scheduler);
        this.channelManager = new StorageServerChannelManager(channelFactory);
        this.scChannelManager = new StorageContainerChannelManager(this.channelManager, this.locationClient, this.scheduler);
        this.rootRangeClient = new RootRangeClientImplWithRetries(new RootRangeClientImpl(this.scheduler, this.scChannelManager), settings.backoffPolicy(), this.scheduler);
        this.streamMetadataCache = new StreamMetadataCache(this.rootRangeClient);
        this.metaRangeClients = Maps.newConcurrentMap();
    }

    @VisibleForTesting
    StorageContainerChannelManager getStorageContainerChannelManager() {
        return this.scChannelManager;
    }

    @Override
    public StorageContainerChannel getStorageContainerChannel(long scId) {
        return this.scChannelManager.getOrCreate(scId);
    }

    @Override
    public LocationClient getLocationClient() {
        return this.locationClient;
    }

    @Override
    public RootRangeClient getRootRangeClient() {
        return this.rootRangeClient;
    }

    @Override
    public MetaRangeClientImpl openMetaRangeClient(StreamProperties streamProps) {
        MetaRangeClientImpl client = (MetaRangeClientImpl)this.metaRangeClients.get(streamProps.getStreamId());
        if (null != client) {
            return client;
        }
        MetaRangeClientImpl newClient = new MetaRangeClientImpl(streamProps, this.scheduler, this.scChannelManager);
        MetaRangeClientImpl oldClient = this.metaRangeClients.putIfAbsent(streamProps.getStreamId(), newClient);
        if (null != oldClient) {
            return oldClient;
        }
        this.streamMetadataCache.putStreamProperties(streamProps.getStreamId(), streamProps);
        return newClient;
    }

    @Override
    public CompletableFuture<StreamProperties> getStreamProperties(long streamId) {
        return this.streamMetadataCache.getStreamProperties(streamId);
    }

    @Override
    public CompletableFuture<MetaRangeClient> openMetaRangeClient(long streamId) {
        MetaRangeClientImpl client = (MetaRangeClientImpl)this.metaRangeClients.get(streamId);
        if (null != client) {
            return FutureUtils.value((Object)client);
        }
        return this.getStreamProperties(streamId).thenApply(props -> this.openMetaRangeClient((StreamProperties)props));
    }

    protected void closeAsyncOnce(CompletableFuture<Void> closeFuture) {
        this.locationClient.close();
        this.channelManager.close();
        this.scheduler.submit(() -> {
            SharedResourceManager.shared().release(this.schedulerResource, (Object)this.scheduler);
            closeFuture.complete(null);
        });
    }
}

