/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.tools.cli.commands.autorecovery;

import com.beust.jcommander.Parameter;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.meta.LedgerUnderreplicationManager;
import org.apache.bookkeeper.meta.MetadataDrivers;
import org.apache.bookkeeper.meta.UnderreplicatedLedger;
import org.apache.bookkeeper.meta.exceptions.MetadataException;
import org.apache.bookkeeper.replication.ReplicationException;
import org.apache.bookkeeper.tools.cli.helpers.BookieCommand;
import org.apache.bookkeeper.tools.framework.CliFlags;
import org.apache.bookkeeper.tools.framework.CliSpec;
import org.apache.bookkeeper.util.LedgerIdFormatter;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListUnderReplicatedCommand
extends BookieCommand<LURFlags> {
    static final Logger LOG = LoggerFactory.getLogger(ListUnderReplicatedCommand.class);
    private static final String NAME = "listunderreplicated";
    private static final String DESC = "List ledgers marked as underreplicated, with oprional options to specify missingreplica (BookieId) and to exclude missingreplica.";
    private static final String DEFAULT = "";
    private LedgerIdFormatter ledgerIdFormatter;

    public ListUnderReplicatedCommand() {
        this(new LURFlags());
    }

    public ListUnderReplicatedCommand(LedgerIdFormatter ledgerIdFormatter) {
        this();
        this.ledgerIdFormatter = ledgerIdFormatter;
    }

    private ListUnderReplicatedCommand(LURFlags flags) {
        super(CliSpec.newBuilder().withName(NAME).withDescription(DESC).withFlags((CliFlags)flags).build());
    }

    @Override
    public boolean apply(ServerConfiguration conf, LURFlags cmdFlags) {
        if (!cmdFlags.ledgerIdFormatter.equals(DEFAULT) && this.ledgerIdFormatter == null) {
            this.ledgerIdFormatter = LedgerIdFormatter.newLedgerIdFormatter(cmdFlags.ledgerIdFormatter, conf);
        } else if (this.ledgerIdFormatter == null) {
            this.ledgerIdFormatter = LedgerIdFormatter.newLedgerIdFormatter(conf);
        }
        try {
            return this.handler(conf, cmdFlags);
        }
        catch (Exception e) {
            throw new UncheckedExecutionException(e.getMessage(), (Throwable)e);
        }
    }

    public boolean handler(ServerConfiguration bkConf, LURFlags flags) throws MetadataException, ExecutionException {
        String includingBookieId = flags.missingReplica;
        String excludingBookieId = flags.excludingMissingReplica;
        boolean printMissingReplica = flags.printMissingReplica;
        boolean printReplicationWorkerId = flags.printReplicationWorkerId;
        boolean onlyDisplayLedgerCount = flags.onlyDisplayLedgerCount;
        Predicate<List> predicate = !StringUtils.isBlank((CharSequence)includingBookieId) && !StringUtils.isBlank((CharSequence)excludingBookieId) ? replicasList -> replicasList.contains(includingBookieId) && !replicasList.contains(excludingBookieId) : (!StringUtils.isBlank((CharSequence)includingBookieId) ? replicasList -> replicasList.contains(includingBookieId) : (!StringUtils.isBlank((CharSequence)excludingBookieId) ? replicasList -> !replicasList.contains(excludingBookieId) : null));
        AtomicInteger underReplicatedLedgerCount = new AtomicInteger(0);
        MetadataDrivers.runFunctionWithLedgerManagerFactory(bkConf, mFactory -> {
            LedgerUnderreplicationManager underreplicationManager;
            try {
                underreplicationManager = mFactory.newLedgerUnderreplicationManager();
            }
            catch (ReplicationException e) {
                throw new UncheckedExecutionException("Failed to new ledger underreplicated manager", (Throwable)e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new UncheckedExecutionException("Interrupted on newing ledger underreplicated manager", (Throwable)e);
            }
            Iterator<UnderreplicatedLedger> iter = underreplicationManager.listLedgersToRereplicate(predicate);
            while (iter.hasNext()) {
                UnderreplicatedLedger underreplicatedLedger = iter.next();
                underReplicatedLedgerCount.incrementAndGet();
                if (onlyDisplayLedgerCount) continue;
                long urLedgerId = underreplicatedLedger.getLedgerId();
                LOG.info("{}", (Object)this.ledgerIdFormatter.formatLedgerId(urLedgerId));
                long ctime = underreplicatedLedger.getCtime();
                if (ctime != -1L) {
                    LOG.info("\tCtime : {}", (Object)ctime);
                }
                if (printMissingReplica) {
                    underreplicatedLedger.getReplicaList().forEach(missingReplica -> LOG.info("\tMissingReplica : {}", missingReplica));
                }
                if (!printReplicationWorkerId) continue;
                try {
                    String replicationWorkerId = underreplicationManager.getReplicationWorkerIdRereplicatingLedger(urLedgerId);
                    if (replicationWorkerId == null) continue;
                    LOG.info("\tReplicationWorkerId : {}", (Object)replicationWorkerId);
                }
                catch (ReplicationException.UnavailableException e) {
                    LOG.error("Failed to get ReplicationWorkerId rereplicating ledger {} -- {}", (Object)urLedgerId, (Object)e.getMessage());
                }
            }
            LOG.info("Under replicated ledger count: {}", (Object)underReplicatedLedgerCount.get());
            return null;
        });
        return true;
    }

    public static class LURFlags
    extends CliFlags {
        @Parameter(names={"-pmr", "--printmissingreplica"}, description="Whether to print missingreplicas list?")
        private boolean printMissingReplica;
        @Parameter(names={"-prw", "--printreplicationworkerid"}, description="Whether wo print replicationworkerid?")
        private boolean printReplicationWorkerId;
        @Parameter(names={"-mr", "--missingreplica"}, description="Bookie Id of missing replica")
        private String missingReplica = "";
        @Parameter(names={"-emr", "--excludingmissingreplica"}, description="Bookie Id of missing replica to ignore")
        private String excludingMissingReplica = "";
        @Parameter(names={"-l", "--ledgeridformatter"}, description="Set ledger id formatter")
        private String ledgerIdFormatter = "";
        @Parameter(names={"-c", "--onlydisplayledgercount"}, description="Only display underreplicated ledger count")
        private boolean onlyDisplayLedgerCount;

        public LURFlags printMissingReplica(boolean printMissingReplica) {
            this.printMissingReplica = printMissingReplica;
            return this;
        }

        public LURFlags printReplicationWorkerId(boolean printReplicationWorkerId) {
            this.printReplicationWorkerId = printReplicationWorkerId;
            return this;
        }

        public LURFlags missingReplica(String missingReplica) {
            this.missingReplica = missingReplica;
            return this;
        }

        public LURFlags excludingMissingReplica(String excludingMissingReplica) {
            this.excludingMissingReplica = excludingMissingReplica;
            return this;
        }

        public LURFlags ledgerIdFormatter(String ledgerIdFormatter) {
            this.ledgerIdFormatter = ledgerIdFormatter;
            return this;
        }

        public LURFlags onlyDisplayLedgerCount(boolean onlyDisplayLedgerCount) {
            this.onlyDisplayLedgerCount = onlyDisplayLedgerCount;
            return this;
        }
    }
}

