/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.util.authenticators;

import io.kubernetes.client.util.KubeConfig;
import io.kubernetes.client.util.authenticators.Authenticator;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Base64;
import java.util.Collection;
import java.util.Map;
import java.util.Scanner;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.jose4j.json.internal.json_simple.JSONObject;
import org.jose4j.json.internal.json_simple.parser.JSONParser;
import org.jose4j.json.internal.json_simple.parser.ParseException;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.NumericDate;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.lang.JoseException;

public class OpenIDConnectAuthenticator
implements Authenticator {
    public static final String OIDC_ID_TOKEN = "id-token";
    public static final String OIDC_ISSUER = "idp-issuer-url";
    public static final String OIDC_REFRESH_TOKEN = "refresh-token";
    public static final String OIDC_CLIENT_ID = "client-id";
    public static final String OIDC_CLIENT_SECRET = "client-secret";
    public static final String OIDC_IDP_CERT_DATA = "idp-certificate-authority-data";

    @Override
    public String getName() {
        return "oidc";
    }

    @Override
    public String getToken(Map<String, Object> config) {
        return (String)config.get(OIDC_ID_TOKEN);
    }

    @Override
    public boolean isExpired(Map<String, Object> config) {
        String idToken = (String)config.get(OIDC_ID_TOKEN);
        if (idToken == null) {
            return true;
        }
        JsonWebSignature jws = new JsonWebSignature();
        try {
            jws.setCompactSerialization(idToken);
            String jwt = jws.getUnverifiedPayload();
            JwtClaims claims = JwtClaims.parse((String)jwt);
            return claims.getExpirationTime() == null || NumericDate.now().isOnOrAfter(claims.getExpirationTime());
        }
        catch (MalformedClaimException | InvalidJwtException | JoseException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Map<String, Object> refresh(Map<String, Object> config) {
        String issuer = (String)config.get(OIDC_ISSUER);
        String clientId = (String)config.get(OIDC_CLIENT_ID);
        String refreshToken = (String)config.get(OIDC_REFRESH_TOKEN);
        String clientSecret = (String)config.getOrDefault(OIDC_CLIENT_SECRET, "");
        String idpCert = (String)config.get(OIDC_IDP_CERT_DATA);
        SSLContext sslContext = null;
        if (idpCert != null) {
            String pemCert = new String(Base64.getDecoder().decode(idpCert));
            String alias = "doenotmatter";
            try {
                KeyStore ks = KeyStore.getInstance("PKCS12");
                ks.load(null, alias.toCharArray());
                ByteArrayInputStream bais = new ByteArrayInputStream(pemCert.getBytes(StandardCharsets.UTF_8));
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                Collection<? extends Certificate> c = cf.generateCertificates(bais);
                int j = 0;
                for (Certificate certificate : c) {
                    ks.setCertificateEntry(alias + "-" + j, certificate);
                    ++j;
                }
                TrustManagerFactory tmf = TrustManagerFactory.getInstance("PKIX");
                tmf.init(ks);
                sslContext = SSLContext.getInstance("TLSv1.2");
                sslContext.init(null, tmf.getTrustManagers(), new SecureRandom());
            }
            catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                throw new RuntimeException("Could not import idp certificate", e);
            }
        }
        String tokenURL = this.loadTokenURL(issuer, sslContext);
        JSONObject response = this.refreshOidcToken(clientId, refreshToken, clientSecret, sslContext, tokenURL);
        config.put(OIDC_ID_TOKEN, response.get((Object)"id_token"));
        config.put(OIDC_REFRESH_TOKEN, response.get((Object)"refresh_token"));
        return config;
    }

    private JSONObject refreshOidcToken(String clientId, String refreshToken, String clientSecret, SSLContext sslContext, String tokenURL) {
        try {
            URL tokenEndpoint = new URL(tokenURL);
            HttpsURLConnection https = (HttpsURLConnection)tokenEndpoint.openConnection();
            https.setRequestMethod("POST");
            if (sslContext != null) {
                https.setSSLSocketFactory(sslContext.getSocketFactory());
            }
            String credentials = Base64.getEncoder().encodeToString((clientId + ':' + clientSecret).getBytes(StandardCharsets.UTF_8));
            https.setRequestProperty("Authorization", "Basic " + credentials);
            https.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            https.setDoOutput(true);
            String urlData = "refresh_token=" + URLEncoder.encode(refreshToken, "UTF-8") + "&grant_type=refresh_token";
            OutputStream ou = https.getOutputStream();
            ou.write(urlData.getBytes(StandardCharsets.UTF_8));
            ou.flush();
            ou.close();
            int code = https.getResponseCode();
            if (code != 200) {
                throw new RuntimeException("Invalid response code for token retrieval - " + code);
            }
            Scanner scanner = new Scanner(https.getInputStream(), StandardCharsets.UTF_8.name());
            String json = scanner.useDelimiter("\\A").next();
            return (JSONObject)new JSONParser().parse(json);
        }
        catch (Throwable t) {
            throw new RuntimeException("Could not refresh token", t);
        }
    }

    private String loadTokenURL(String issuer, SSLContext sslContext) {
        StringBuilder wellKnownUrl = new StringBuilder();
        wellKnownUrl.append(issuer);
        if (!issuer.endsWith("/")) {
            wellKnownUrl.append("/");
        }
        wellKnownUrl.append(".well-known/openid-configuration");
        try {
            URL wellKnown = new URL(wellKnownUrl.toString());
            HttpsURLConnection https = (HttpsURLConnection)wellKnown.openConnection();
            https.setRequestMethod("GET");
            if (sslContext != null) {
                https.setSSLSocketFactory(sslContext.getSocketFactory());
            }
            https.setUseCaches(false);
            int code = https.getResponseCode();
            if (code != 200) {
                throw new RuntimeException("Invalid response code for issuer - " + code);
            }
            Scanner scanner = new Scanner(https.getInputStream(), StandardCharsets.UTF_8.name());
            String json = scanner.useDelimiter("\\A").next();
            JSONObject wellKnownJson = (JSONObject)new JSONParser().parse(json);
            return (String)wellKnownJson.get((Object)"token_endpoint");
        }
        catch (IOException | ParseException e) {
            throw new RuntimeException("Could not refresh", e);
        }
    }

    static {
        KubeConfig.registerAuthenticator(new OpenIDConnectAuthenticator());
    }
}

