/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog;

import java.io.File;
import org.apache.bookkeeper.shims.zk.ZooKeeperServerShim;
import org.apache.bookkeeper.util.IOUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.distributedlog.LocalDLMEmulator;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestDLMTestUtil {
    static final Logger LOG = LoggerFactory.getLogger(TestDLMTestUtil.class);
    @Rule
    public TestName testNames = new TestName();

    @Test(timeout=60000L)
    public void testRunZookeeperOnAnyPort() throws Exception {
        block4: {
            Pair serverAndPort1 = null;
            Pair serverAndPort2 = null;
            Pair serverAndPort3 = null;
            try {
                File zkTmpDir1 = IOUtils.createTempDir((String)"zookeeper1", (String)"distrlog");
                serverAndPort1 = LocalDLMEmulator.runZookeeperOnAnyPort((int)7000, (File)zkTmpDir1);
                File zkTmpDir2 = IOUtils.createTempDir((String)"zookeeper2", (String)"distrlog");
                serverAndPort2 = LocalDLMEmulator.runZookeeperOnAnyPort((int)7000, (File)zkTmpDir2);
                File zkTmpDir3 = IOUtils.createTempDir((String)"zookeeper3", (String)"distrlog");
                serverAndPort3 = LocalDLMEmulator.runZookeeperOnAnyPort((int)7000, (File)zkTmpDir3);
            }
            catch (Exception ex) {
                if (null != serverAndPort1) {
                    ((ZooKeeperServerShim)serverAndPort1.getLeft()).stop();
                }
                if (null != serverAndPort2) {
                    ((ZooKeeperServerShim)serverAndPort2.getLeft()).stop();
                }
                if (null == serverAndPort3) break block4;
                ((ZooKeeperServerShim)serverAndPort3.getLeft()).stop();
            }
        }
    }

    static {
        System.setProperty("zookeeper.4lw.commands.whitelist", "*");
    }
}

