/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.websocket;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.servlet.http.HttpServletRequest;
import org.apache.pulsar.broker.authentication.AuthenticationDataSource;
import org.apache.pulsar.broker.authentication.AuthenticationDataSubscription;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.policies.data.TopicOperation;
import org.apache.pulsar.common.util.Codec;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.websocket.ConsumerHandler;
import org.apache.pulsar.websocket.WebSocketService;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiTopicConsumerHandler
extends ConsumerHandler {
    private static final Logger log = LoggerFactory.getLogger(MultiTopicConsumerHandler.class);

    public MultiTopicConsumerHandler(WebSocketService service, HttpServletRequest request, ServletUpgradeResponse response) {
        super(service, request, response);
    }

    @Override
    protected Boolean isAuthorized(String authRole, AuthenticationDataSource authenticationData) throws Exception {
        try {
            AuthenticationDataSubscription subscription = new AuthenticationDataSubscription(authenticationData, this.subscription);
            if (this.topics != null) {
                List topicNames = Splitter.on((String)",").splitToList((CharSequence)this.topics);
                ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>();
                for (String topicName : topicNames) {
                    futures.add(this.service.getAuthorizationService().allowTopicOperationAsync(TopicName.get((String)topicName), TopicOperation.CONSUME, authRole, (AuthenticationDataSource)subscription));
                }
                FutureUtil.waitForAll(futures).get(this.service.getConfig().getMetadataStoreOperationTimeoutSeconds(), TimeUnit.SECONDS);
                return futures.stream().allMatch(f -> (Boolean)f.join());
            }
            return (Boolean)this.service.getAuthorizationService().allowTopicOperationAsync(this.topic, TopicOperation.CONSUME, authRole, (AuthenticationDataSource)subscription).get(this.service.getConfig().getMetadataStoreOperationTimeoutSeconds(), TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            log.warn("Time-out {} sec while checking authorization on {} ", (Object)this.service.getConfig().getMetadataStoreOperationTimeoutSeconds(), (Object)this.topic);
            throw e;
        }
        catch (Exception e) {
            log.warn("Consumer-client  with Role - {} failed to get permissions for topic - {}. {}", new Object[]{authRole, this.topic, e.getMessage()});
            throw e;
        }
    }

    @Override
    protected void extractTopicName(HttpServletRequest request) {
        String uri = request.getRequestURI();
        List parts = Splitter.on((String)"/").splitToList((CharSequence)uri);
        Preconditions.checkArgument((parts.size() >= 4 ? 1 : 0) != 0, (Object)"Invalid topic name format");
        Preconditions.checkArgument((boolean)((String)parts.get(2)).equals("v3"));
        Preconditions.checkArgument((this.queryParams.containsKey("topicsPattern") || this.queryParams.containsKey("topics") ? 1 : 0) != 0, (Object)"Should set topics or topicsPattern");
        Preconditions.checkArgument((!this.queryParams.containsKey("topicsPattern") || !this.queryParams.containsKey("topics") ? 1 : 0) != 0, (Object)"Topics must be null when use topicsPattern");
        this.topicsPattern = (String)this.queryParams.get("topicsPattern");
        this.topics = (String)this.queryParams.get("topics");
        this.topic = this.topicsPattern != null ? TopicName.get((String)this.topicsPattern) : TopicName.get((String)((String)Splitter.on((String)",").splitToList((CharSequence)this.topics).get(0)));
    }

    @Override
    public String extractSubscription(HttpServletRequest request) {
        String uri = request.getRequestURI();
        List parts = Splitter.on((String)"/").splitToList((CharSequence)uri);
        Preconditions.checkArgument((parts.size() >= 5 ? 1 : 0) != 0, (Object)"Invalid topic name format");
        Preconditions.checkArgument((boolean)((String)parts.get(1)).equals("ws"));
        Preconditions.checkArgument((boolean)((String)parts.get(2)).equals("v3"));
        Preconditions.checkArgument((((String)parts.get(4)).length() > 0 ? 1 : 0) != 0, (Object)"Empty subscription name");
        return Codec.decode((String)((String)parts.get(4)));
    }
}

