/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import io.grpc.Internal;
import io.grpc.LoadBalancer;
import io.grpc.LoadBalancerProvider;
import io.grpc.NameResolver;
import io.grpc.Status;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.JsonUtil;
import io.grpc.xds.RingHashLoadBalancer;
import io.grpc.xds.RingHashOptions;
import java.util.Map;

@Internal
public final class RingHashLoadBalancerProvider
extends LoadBalancerProvider {
    @VisibleForTesting
    static final long DEFAULT_MIN_RING_SIZE = 1024L;
    @VisibleForTesting
    static final long DEFAULT_MAX_RING_SIZE = 4096L;
    private static final boolean enableRingHash = Strings.isNullOrEmpty((String)System.getenv("GRPC_XDS_EXPERIMENTAL_ENABLE_RING_HASH")) || Boolean.parseBoolean(System.getenv("GRPC_XDS_EXPERIMENTAL_ENABLE_RING_HASH"));

    public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
        return new RingHashLoadBalancer(helper);
    }

    public boolean isAvailable() {
        return enableRingHash;
    }

    public int getPriority() {
        return 5;
    }

    public String getPolicyName() {
        return "ring_hash_experimental";
    }

    public NameResolver.ConfigOrError parseLoadBalancingPolicyConfig(Map<String, ?> rawLoadBalancingPolicyConfig) {
        try {
            return this.parseLoadBalancingPolicyConfigInternal(rawLoadBalancingPolicyConfig);
        }
        catch (RuntimeException e) {
            return NameResolver.ConfigOrError.fromError((Status)Status.UNAVAILABLE.withCause((Throwable)e).withDescription("Failed parsing configuration for " + this.getPolicyName()));
        }
    }

    private NameResolver.ConfigOrError parseLoadBalancingPolicyConfigInternal(Map<String, ?> rawLoadBalancingPolicyConfig) {
        Long minRingSize = JsonUtil.getNumberAsLong(rawLoadBalancingPolicyConfig, (String)"minRingSize");
        Long maxRingSize = JsonUtil.getNumberAsLong(rawLoadBalancingPolicyConfig, (String)"maxRingSize");
        String requestHashHeader = "";
        if (GrpcUtil.getFlag((String)"GRPC_EXPERIMENTAL_RING_HASH_SET_REQUEST_HASH_KEY", (boolean)false)) {
            requestHashHeader = JsonUtil.getString(rawLoadBalancingPolicyConfig, (String)"requestHashHeader");
        }
        long maxRingSizeCap = RingHashOptions.getRingSizeCap();
        if (minRingSize == null) {
            minRingSize = 1024L;
        }
        if (maxRingSize == null) {
            maxRingSize = 4096L;
        }
        if (requestHashHeader == null) {
            requestHashHeader = "";
        }
        if (minRingSize > maxRingSizeCap) {
            minRingSize = maxRingSizeCap;
        }
        if (maxRingSize > maxRingSizeCap) {
            maxRingSize = maxRingSizeCap;
        }
        if (minRingSize <= 0L || maxRingSize <= 0L || minRingSize > maxRingSize) {
            return NameResolver.ConfigOrError.fromError((Status)Status.UNAVAILABLE.withDescription("Invalid 'mingRingSize'/'maxRingSize'"));
        }
        return NameResolver.ConfigOrError.fromConfig((Object)new RingHashLoadBalancer.RingHashConfig(minRingSize, maxRingSize, requestHashHeader));
    }
}

