/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.clients.utils;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ListenableFuture;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.StatusRuntimeException;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.bookkeeper.common.util.Backoff;
import org.apache.bookkeeper.common.util.ListenableFutures;
import org.apache.bookkeeper.common.util.OrderedScheduler;
import org.apache.bookkeeper.common.util.Retries;

public class RetryUtils {
    @VisibleForTesting
    static final Predicate<Throwable> DEFAULT_CLIENT_RETRY_PREDICATE = cause -> RetryUtils.shouldRetryOnException(cause);
    private final Predicate<Throwable> retryPredicate;
    private final Backoff.Policy backoffPolicy;
    private final OrderedScheduler scheduler;

    private static boolean shouldRetryOnException(Throwable cause) {
        if (cause instanceof StatusRuntimeException || cause instanceof StatusException) {
            Status status = cause instanceof StatusException ? ((StatusException)cause).getStatus() : ((StatusRuntimeException)cause).getStatus();
            switch (status.getCode()) {
                case INVALID_ARGUMENT: 
                case ALREADY_EXISTS: 
                case PERMISSION_DENIED: 
                case UNAUTHENTICATED: {
                    return false;
                }
            }
            return true;
        }
        if (cause instanceof RuntimeException) {
            return false;
        }
        return false;
    }

    public static RetryUtils create(Backoff.Policy backoffPolicy, OrderedScheduler scheduler) {
        return RetryUtils.create(DEFAULT_CLIENT_RETRY_PREDICATE, backoffPolicy, scheduler);
    }

    public static RetryUtils create(Predicate<Throwable> retryPredicate, Backoff.Policy backoffPolicy, OrderedScheduler scheduler) {
        return new RetryUtils(retryPredicate, backoffPolicy, scheduler);
    }

    private RetryUtils(Predicate<Throwable> retryPredicate, Backoff.Policy backoffPolicy, OrderedScheduler scheduler) {
        this.retryPredicate = retryPredicate;
        this.backoffPolicy = backoffPolicy;
        this.scheduler = scheduler;
    }

    public <T> CompletableFuture<T> execute(Supplier<CompletableFuture<T>> action) {
        return Retries.run((Stream)this.backoffPolicy.toBackoffs(), this.retryPredicate, action, (OrderedScheduler)this.scheduler);
    }

    public <T> CompletableFuture<T> executeListenable(Supplier<ListenableFuture<T>> action) {
        return Retries.run((Stream)this.backoffPolicy.toBackoffs(), this.retryPredicate, () -> ListenableFutures.fromListenableFuture((ListenableFuture)((ListenableFuture)action.get())), (OrderedScheduler)this.scheduler);
    }
}

