/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.worker;

import io.opentelemetry.api.metrics.Meter;
import java.io.Closeable;
import lombok.Generated;
import org.apache.pulsar.PulsarVersion;
import org.apache.pulsar.functions.worker.WorkerConfig;
import org.apache.pulsar.opentelemetry.OpenTelemetryService;

public class PulsarWorkerOpenTelemetry
implements Closeable {
    public static final String SERVICE_NAME = "pulsar-function-worker";
    private final OpenTelemetryService openTelemetryService;
    private final Meter meter;

    public PulsarWorkerOpenTelemetry(WorkerConfig workerConfig) {
        this.openTelemetryService = OpenTelemetryService.builder().clusterName(workerConfig.getPulsarFunctionsCluster()).serviceName(SERVICE_NAME).serviceVersion(PulsarVersion.getVersion()).build();
        this.meter = this.openTelemetryService.getOpenTelemetry().getMeter("org.apache.pulsar.function_worker");
    }

    @Override
    public void close() {
        this.openTelemetryService.close();
    }

    @Generated
    public Meter getMeter() {
        return this.meter;
    }
}

