/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

#ifndef PLC4C_S7_READ_WRITE_S7_MESSAGE_H_
#define PLC4C_S7_READ_WRITE_S7_MESSAGE_H_

#include <stdbool.h>
#include <stdint.h>
#include <plc4c/spi/context.h>
#include <plc4c/spi/read_buffer.h>
#include <plc4c/spi/write_buffer.h>
#include <plc4c/utils/list.h>
#include "s7_parameter.h"
#include "s7_payload.h"

// Code generated by code-generation. DO NOT EDIT.


// Structure used to contain the discriminator values for discriminated types using this as a parent
struct plc4c_s7_read_write_s7_message_discriminator {
  uint8_t messageType;
};
typedef struct plc4c_s7_read_write_s7_message_discriminator plc4c_s7_read_write_s7_message_discriminator;

// Enum assigning each subtype an individual id.
enum plc4c_s7_read_write_s7_message_type {
  plc4c_s7_read_write_s7_message_type_plc4c_s7_read_write_s7_message_request = 0,
  plc4c_s7_read_write_s7_message_type_plc4c_s7_read_write_s7_message_response = 1,
  plc4c_s7_read_write_s7_message_type_plc4c_s7_read_write_s7_message_response_data = 2,
  plc4c_s7_read_write_s7_message_type_plc4c_s7_read_write_s7_message_user_data = 3};
typedef enum plc4c_s7_read_write_s7_message_type plc4c_s7_read_write_s7_message_type;

// Function to get the discriminator values for a given type.
plc4c_s7_read_write_s7_message_discriminator plc4c_s7_read_write_s7_message_get_discriminator(plc4c_s7_read_write_s7_message_type type);

// Constant values.
uint8_t PLC4C_S7_READ_WRITE_S7_MESSAGE_PROTOCOL_ID();

struct plc4c_s7_read_write_s7_message {
  /* This is an abstract type so this property saves the type of this typed union */
  plc4c_s7_read_write_s7_message_type _type;
  /* Properties */
  uint8_t protocol_id;
  uint16_t tpdu_reference;
  union {
    struct { /* S7MessageResponse */
      uint8_t s7_message_response_error_class;
      uint8_t s7_message_response_error_code;
    };
    struct { /* S7MessageResponseData */
      uint8_t s7_message_response_data_error_class;
      uint8_t s7_message_response_data_error_code;
    };
  };
  plc4c_s7_read_write_s7_parameter* parameter;
  plc4c_s7_read_write_s7_payload* payload;
};
typedef struct plc4c_s7_read_write_s7_message plc4c_s7_read_write_s7_message;

// Create an empty NULL-struct
plc4c_s7_read_write_s7_message plc4c_s7_read_write_s7_message_null();

plc4c_return_code plc4c_s7_read_write_s7_message_parse(plc4x_spi_context ctx, plc4c_spi_read_buffer* readBuffer, plc4c_s7_read_write_s7_message** message);

plc4c_return_code plc4c_s7_read_write_s7_message_serialize(plc4x_spi_context ctx, plc4c_spi_write_buffer* writeBuffer, plc4c_s7_read_write_s7_message* message);

uint16_t plc4c_s7_read_write_s7_message_length_in_bytes(plc4x_spi_context ctx, plc4c_s7_read_write_s7_message* message);

uint16_t plc4c_s7_read_write_s7_message_length_in_bits(plc4x_spi_context ctx, plc4c_s7_read_write_s7_message* message);

#endif  // PLC4C_S7_READ_WRITE_S7_MESSAGE_H_
