/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


/**
 * Proxy Auto-Config (PAC) script related.
 * 
 * <p>
 * A Proxy Auto-Config (PAC) script is a piece of JavaScript code
 * which is typically downloaded from the network. It is meant to be
 * evaluated on the client. The role of the PAC is to determine which 
 * proxy to use for a given URL.
 * 
 * <p>
 * Netscape wrote the original specification for the PAC script in 1995. The
 * specification has never been ratified as a standard but is widely implemented
 * on corporate Local Area Networks as a way to have a centralized and
 * configurable proxy setup.
 */
package org.netbeans.core.network.proxy.pac;
