/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.security.eddsa.generic;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PublicKey;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.apache.sshd.common.config.keys.KeyEntryResolver;
import org.apache.sshd.common.config.keys.impl.AbstractPublicKeyEntryDecoder;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.security.SecurityUtils;
import org.apache.sshd.common.util.security.eddsa.generic.EdDSAUtils;

public final class Ed25519PublicKeyDecoder
extends AbstractPublicKeyEntryDecoder {
    public static final int MAX_ALLOWED_SEED_LEN = 1024;
    public static final Ed25519PublicKeyDecoder INSTANCE = new Ed25519PublicKeyDecoder();

    private Ed25519PublicKeyDecoder() {
        super(Collections.singletonList("ssh-ed25519"));
    }

    @Override
    public KeyPairGenerator getKeyPairGenerator() throws GeneralSecurityException {
        return SecurityUtils.getKeyPairGenerator("Ed25519");
    }

    @Override
    public KeyPair generateKeyPair(int keySize) throws GeneralSecurityException {
        return this.getKeyPairGenerator().generateKeyPair();
    }

    @Override
    public String encodePublicKey(OutputStream s, PublicKey key) throws IOException {
        Objects.requireNonNull(key, "No public key provided");
        KeyEntryResolver.encodeString(s, "ssh-ed25519");
        KeyEntryResolver.writeRLEBytes(s, EdDSAUtils.getBytes(key));
        return "ssh-ed25519";
    }

    @Override
    public KeyFactory getKeyFactoryInstance() throws GeneralSecurityException {
        return SecurityUtils.getKeyFactory("Ed25519");
    }

    @Override
    public PublicKey decodePublicKey(SessionContext session, String keyType, InputStream keyData, Map<String, String> headers) throws IOException, GeneralSecurityException {
        byte[] seed = KeyEntryResolver.readRLEBytes(keyData, 1024);
        return EdDSAUtils.getPublicKey(seed);
    }
}

