/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog.parser.jdom;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog.parser.jdom.InvCatalogFactory10;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.featurecollection.FeatureCollectionType;

public class FeatureCollectionReader {
    private static final Logger logger = LoggerFactory.getLogger(FeatureCollectionReader.class);

    public static FeatureCollectionConfig getConfigFromSnippet(String filename) {
        Document doc;
        try {
            SAXBuilder builder = new SAXBuilder();
            doc = builder.build(filename);
        }
        catch (Exception e) {
            System.out.printf("Error parsing featureCollection %s err = %s", filename, e.getMessage());
            return null;
        }
        return FeatureCollectionReader.readFeatureCollection(doc.getRootElement());
    }

    public static FeatureCollectionConfig readFeatureCollection(String catalogAndPath) {
        Document doc;
        String catFilename;
        String fcName = null;
        int pos = catalogAndPath.indexOf("#");
        if (pos > 0) {
            catFilename = catalogAndPath.substring(0, pos);
            fcName = catalogAndPath.substring(pos + 1);
        } else {
            catFilename = catalogAndPath;
        }
        File cat = new File(catFilename);
        try {
            SAXBuilder builder = new SAXBuilder();
            doc = builder.build(cat);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        try {
            ArrayList<Element> fcElems = new ArrayList<Element>();
            FeatureCollectionReader.findFeatureCollection(doc.getRootElement(), fcName, fcElems);
            if (fcElems.size() > 0) {
                return FeatureCollectionReader.readFeatureCollection((Element)fcElems.get(0));
            }
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static void findFeatureCollection(Element parent, String name, List<Element> fcElems) {
        List elist = parent.getChildren("featureCollection", InvCatalogFactory10.defNS);
        if (name == null) {
            fcElems.addAll(elist);
        } else {
            for (Element elem : elist) {
                if (!name.equals(elem.getAttributeValue("name"))) continue;
                fcElems.add(elem);
            }
        }
        for (Element child : parent.getChildren("dataset", InvCatalogFactory10.defNS)) {
            FeatureCollectionReader.findFeatureCollection(child, name, fcElems);
        }
    }

    public static FeatureCollectionConfig readFeatureCollection(Element featureCollectionElement) {
        Element gribConfig;
        Element pointElem;
        String datasetTypes;
        Element fmrcElem;
        String name = featureCollectionElement.getAttributeValue("name");
        String path = featureCollectionElement.getAttributeValue("path");
        String fcTypeS = featureCollectionElement.getAttributeValue("featureType");
        FeatureCollectionType fcType = FeatureCollectionType.valueOf(fcTypeS);
        if (fcType == null) {
            logger.error("featureCollection " + name + " must have a valid FeatureCollectionType attribute, found '" + fcTypeS + "'");
            return null;
        }
        Element collElem = featureCollectionElement.getChild("collection", InvCatalogFactory10.defNS);
        if (collElem == null) {
            logger.error("featureCollection " + name + " must have a <collection> element.");
            return null;
        }
        String specName = collElem.getAttributeValue("name");
        if (specName == null) {
            specName = name;
        }
        String spec = collElem.getAttributeValue("spec");
        String timePartition = collElem.getAttributeValue("timePartition");
        String dateFormatMark = collElem.getAttributeValue("dateFormatMark");
        String olderThan = collElem.getAttributeValue("olderThan");
        String useIndexOnly = collElem.getAttributeValue("useIndexOnly");
        if (spec == null) {
            logger.error("featureCollection " + name + " must have a spec attribute.");
            return null;
        }
        String collName = specName != null ? specName : name;
        Element innerNcml = featureCollectionElement.getChild("netcdf", InvCatalogFactory10.ncmlNS);
        FeatureCollectionConfig config = new FeatureCollectionConfig(collName, path, fcType, spec, dateFormatMark, olderThan, timePartition, useIndexOnly, innerNcml);
        Element tdmElem = featureCollectionElement.getChild("tdm", InvCatalogFactory10.defNS);
        config.tdmConfig = FeatureCollectionReader.readUpdateElement(tdmElem);
        Element updateElem = featureCollectionElement.getChild("update", InvCatalogFactory10.defNS);
        config.updateConfig = FeatureCollectionReader.readUpdateElement(updateElem);
        Element protoElem = featureCollectionElement.getChild("protoDataset", InvCatalogFactory10.defNS);
        if (protoElem != null) {
            String choice = protoElem.getAttributeValue("choice");
            String change = protoElem.getAttributeValue("change");
            String param = protoElem.getAttributeValue("param");
            Element ncmlElem = protoElem.getChild("netcdf", InvCatalogFactory10.ncmlNS);
            config.protoConfig = new FeatureCollectionConfig.ProtoConfig(choice, change, param, ncmlElem);
        }
        if ((fmrcElem = featureCollectionElement.getChild("fmrcConfig", InvCatalogFactory10.defNS)) != null) {
            String regularize = fmrcElem.getAttributeValue("regularize");
            config.fmrcConfig = new FeatureCollectionConfig.FmrcConfig(regularize);
            datasetTypes = fmrcElem.getAttributeValue("datasetTypes");
            if (null != datasetTypes) {
                config.fmrcConfig.addDatasetType(datasetTypes);
            }
            List bestElems = fmrcElem.getChildren("dataset", InvCatalogFactory10.defNS);
            for (Element best : bestElems) {
                String bestName = best.getAttributeValue("name");
                String offs = best.getAttributeValue("offsetsGreaterEqual");
                double off = Double.parseDouble(offs);
                config.fmrcConfig.addBestDataset(bestName, off);
            }
        }
        if ((pointElem = featureCollectionElement.getChild("pointConfig", InvCatalogFactory10.defNS)) != null && null != (datasetTypes = pointElem.getAttributeValue("datasetTypes"))) {
            config.pointConfig.addDatasetType(datasetTypes);
        }
        if ((gribConfig = featureCollectionElement.getChild("gribConfig", InvCatalogFactory10.defNS)) != null) {
            config.gribConfig.configFromXml(gribConfig, InvCatalogFactory10.defNS);
        }
        config.finish();
        return config;
    }

    private static FeatureCollectionConfig.UpdateConfig readUpdateElement(Element updateElem) {
        if (updateElem == null) {
            return new FeatureCollectionConfig.UpdateConfig();
        }
        String startup = updateElem.getAttributeValue("startup");
        String rewrite = updateElem.getAttributeValue("rewrite");
        String recheckAfter = updateElem.getAttributeValue("recheckAfter");
        String rescan = updateElem.getAttributeValue("rescan");
        String trigger = updateElem.getAttributeValue("trigger");
        String deleteAfter = updateElem.getAttributeValue("deleteAfter");
        return new FeatureCollectionConfig.UpdateConfig(startup, rewrite, recheckAfter, rescan, trigger, deleteAfter);
    }
}

