/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.opennlp;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.analysis.TokenizerFactory;
import org.apache.lucene.analysis.opennlp.OpenNLPTokenizer;
import org.apache.lucene.analysis.opennlp.tools.NLPSentenceDetectorOp;
import org.apache.lucene.analysis.opennlp.tools.NLPTokenizerOp;
import org.apache.lucene.analysis.opennlp.tools.OpenNLPOpsFactory;
import org.apache.lucene.util.AttributeFactory;
import org.apache.lucene.util.ResourceLoader;
import org.apache.lucene.util.ResourceLoaderAware;

public class OpenNLPTokenizerFactory
extends TokenizerFactory
implements ResourceLoaderAware {
    public static final String NAME = "openNlp";
    public static final String SENTENCE_MODEL = "sentenceModel";
    public static final String TOKENIZER_MODEL = "tokenizerModel";
    private final String sentenceModelFile;
    private final String tokenizerModelFile;

    public OpenNLPTokenizerFactory(Map<String, String> args) {
        super(args);
        this.sentenceModelFile = this.require(args, SENTENCE_MODEL);
        this.tokenizerModelFile = this.require(args, TOKENIZER_MODEL);
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + String.valueOf(args));
        }
    }

    public OpenNLPTokenizerFactory() {
        throw OpenNLPTokenizerFactory.defaultCtorException();
    }

    public OpenNLPTokenizer create(AttributeFactory factory) {
        try {
            NLPSentenceDetectorOp sentenceOp = OpenNLPOpsFactory.getSentenceDetector(this.sentenceModelFile);
            NLPTokenizerOp tokenizerOp = OpenNLPOpsFactory.getTokenizer(this.tokenizerModelFile);
            return new OpenNLPTokenizer(factory, sentenceOp, tokenizerOp);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void inform(ResourceLoader loader) throws IOException {
        if (this.sentenceModelFile != null) {
            OpenNLPOpsFactory.getSentenceModel(this.sentenceModelFile, loader);
        }
        if (this.tokenizerModelFile != null) {
            OpenNLPOpsFactory.getTokenizerModel(this.tokenizerModelFile, loader);
        }
    }
}

