/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.luke.app.desktop.components.dialog.documents;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.Window;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import org.apache.lucene.luke.app.desktop.Preferences;
import org.apache.lucene.luke.app.desktop.PreferencesFactory;
import org.apache.lucene.luke.app.desktop.components.TableColumnInfo;
import org.apache.lucene.luke.app.desktop.components.TableModelBase;
import org.apache.lucene.luke.app.desktop.util.DialogOpener;
import org.apache.lucene.luke.app.desktop.util.MessageUtils;
import org.apache.lucene.luke.app.desktop.util.TableUtils;
import org.apache.lucene.luke.models.documents.TermVectorEntry;

public final class TermVectorDialogFactory
implements DialogOpener.DialogFactory {
    private static TermVectorDialogFactory instance;
    private final Preferences prefs = PreferencesFactory.getInstance();
    private JDialog dialog;
    private String field;
    private List<TermVectorEntry> tvEntries;

    public static synchronized TermVectorDialogFactory getInstance() throws IOException {
        if (instance == null) {
            instance = new TermVectorDialogFactory();
        }
        return instance;
    }

    private TermVectorDialogFactory() throws IOException {
    }

    public void setField(String field) {
        this.field = field;
    }

    public void setTvEntries(List<TermVectorEntry> tvEntries) {
        this.tvEntries = tvEntries;
    }

    @Override
    public JDialog create(Window owner, String title, int width, int height) {
        if (Objects.isNull(this.field) || Objects.isNull(this.tvEntries)) {
            throw new IllegalStateException("field name and/or term vector is not set.");
        }
        this.dialog = new JDialog(owner, title, Dialog.ModalityType.APPLICATION_MODAL);
        this.dialog.add(this.content());
        this.dialog.setSize(new Dimension(width, height));
        this.dialog.setLocationRelativeTo(owner);
        this.dialog.getContentPane().setBackground(this.prefs.getColorTheme().getBackgroundColor());
        return this.dialog;
    }

    private JPanel content() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setOpaque(false);
        panel.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
        JPanel header = new JPanel(new FlowLayout(3, 5, 5));
        header.setOpaque(false);
        header.add(new JLabel(MessageUtils.getLocalizedMessage("documents.termvector.label.term_vector")));
        header.add(new JLabel(this.field));
        panel.add((Component)header, "First");
        JTable tvTable = new JTable();
        TableUtils.setupTable(tvTable, 0, new TermVectorTableModel(this.tvEntries), null, 100, 50, 100);
        JScrollPane scrollPane = new JScrollPane(tvTable);
        panel.add((Component)scrollPane, "Center");
        JPanel footer = new JPanel(new FlowLayout(4, 0, 10));
        footer.setOpaque(false);
        JButton closeBtn = new JButton(MessageUtils.getLocalizedMessage("button.close"));
        closeBtn.setMargin(new Insets(3, 3, 3, 3));
        closeBtn.addActionListener(e -> this.dialog.dispose());
        footer.add(closeBtn);
        panel.add((Component)footer, "Last");
        return panel;
    }

    static final class TermVectorTableModel
    extends TableModelBase<Column> {
        TermVectorTableModel() {
        }

        TermVectorTableModel(List<TermVectorEntry> tvEntries) {
            super(tvEntries.size());
            for (int i = 0; i < tvEntries.size(); ++i) {
                TermVectorEntry entry = tvEntries.get(i);
                String termText = entry.getTermText();
                long freq = tvEntries.get(i).getFreq();
                String positions = entry.getPositions().stream().map(pos -> Integer.toString(pos.getPosition())).collect(Collectors.joining(","));
                String offsets = entry.getPositions().stream().filter(pos -> pos.getStartOffset().isPresent() && pos.getEndOffset().isPresent()).map(pos -> pos.getStartOffset().orElse(-1) + "-" + pos.getEndOffset().orElse(-1)).collect(Collectors.joining(","));
                this.data[i] = new Object[]{termText, freq, positions, offsets};
            }
        }

        protected Column[] columnInfos() {
            return Column.values();
        }

        static enum Column implements TableColumnInfo
        {
            TERM("Term", 0, String.class),
            FREQ("Freq", 1, Long.class),
            POSITIONS("Positions", 2, String.class),
            OFFSETS("Offsets", 3, String.class);

            private final String colName;
            private final int index;
            private final Class<?> type;

            private Column(String colName, int index, Class<?> type) {
                this.colName = colName;
                this.index = index;
                this.type = type;
            }

            @Override
            public String getColName() {
                return this.colName;
            }

            @Override
            public int getIndex() {
                return this.index;
            }

            @Override
            public Class<?> getType() {
                return this.type;
            }
        }
    }
}

