/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.luke.app.desktop.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.util.ArrayList;
import java.util.Objects;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.apache.lucene.luke.app.desktop.util.FontUtils;
import org.apache.lucene.luke.app.desktop.util.MessageUtils;
import org.apache.lucene.luke.util.CircularLogBufferHandler;
import org.apache.lucene.luke.util.LogRecordFormatter;
import org.apache.lucene.luke.util.LoggerFactory;

public final class LogsPanelProvider {
    public JPanel get() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setOpaque(false);
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel header = new JPanel(new FlowLayout(3));
        header.setOpaque(false);
        header.add(new JLabel(MessageUtils.getLocalizedMessage("logs.label.level")));
        JComboBox<Level> logFilter = new JComboBox<Level>(new Level[]{Level.FINEST, Level.FINER, Level.FINE, Level.CONFIG, Level.INFO, Level.WARNING, Level.SEVERE, Level.OFF});
        logFilter.setEditable(false);
        logFilter.setSelectedItem(Level.INFO);
        header.add(logFilter);
        JTextArea logTextArea = this.createLogPanel(logFilter);
        JButton copyBtn = new JButton(FontUtils.elegantIconHtml("&#xe0e6;", MessageUtils.getLocalizedMessage("button.copy")));
        copyBtn.setMargin(new Insets(3, 3, 3, 3));
        copyBtn.addActionListener(e -> {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            StringSelection selection = new StringSelection(logTextArea.getText());
            clipboard.setContents(selection, null);
        });
        header.add(copyBtn);
        panel.add((Component)header, "First");
        panel.add((Component)new JScrollPane(logTextArea), "Center");
        return panel;
    }

    private JTextArea createLogPanel(JComboBox<Level> logFilter) {
        JTextArea logTextArea = new JTextArea();
        logTextArea.setEditable(false);
        LogRecordFormatter formatter = new LogRecordFormatter();
        CircularLogBufferHandler.LogUpdateListener updater = records -> {
            ArrayList clonedCopy = new ArrayList(records);
            SwingUtilities.invokeLater(() -> {
                Level level = (Level)Objects.requireNonNull(logFilter.getSelectedItem());
                String logContent = clonedCopy.stream().filter(record -> record.getLevel().intValue() >= level.intValue()).map(formatter).collect(Collectors.joining("\n"));
                logTextArea.setText(logContent);
            });
        };
        CircularLogBufferHandler logBuffer = Objects.requireNonNull(LoggerFactory.circularBuffer);
        logFilter.addActionListener(e -> updater.accept(logBuffer.getLogRecords()));
        logTextArea.addHierarchyListener(e -> {
            if (e.getComponent() == logTextArea && (e.getChangeFlags() & 2L) != 0L) {
                if (logTextArea.isDisplayable()) {
                    logBuffer.addUpdateListener(updater);
                    updater.accept(logBuffer.getLogRecords());
                } else {
                    logBuffer.removeUpdateListener(updater);
                }
            }
        });
        return logTextArea;
    }
}

