/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.tasks;

import java.util.Locale;
import org.apache.lucene.benchmark.byTask.PerfRunData;
import org.apache.lucene.benchmark.byTask.tasks.PerfTask;

public class NewLocaleTask
extends PerfTask {
    private String tag;

    public NewLocaleTask(PerfRunData runData) {
        super(runData);
    }

    static Locale createLocale(String tag) {
        if (tag == null || tag.length() == 0) {
            return null;
        }
        if (tag.equalsIgnoreCase("ROOT")) {
            return Locale.ROOT;
        }
        return new Locale.Builder().setLanguageTag(tag).build();
    }

    @Override
    public int doLogic() throws Exception {
        Locale locale = NewLocaleTask.createLocale(this.tag);
        this.getRunData().setLocale(locale);
        System.out.println("Changed Locale to: " + String.valueOf(locale == null ? "null" : (locale.getDisplayName(Locale.ENGLISH).length() == 0 ? "root locale" : locale)));
        return 1;
    }

    @Override
    public void setParams(String params) {
        super.setParams(params);
        this.tag = params;
    }

    @Override
    public boolean supportsParams() {
        return true;
    }
}

