/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.backward_codecs.lucene94;

import java.io.IOException;
import org.apache.lucene.backward_codecs.lucene94.Lucene94HnswVectorsReader;
import org.apache.lucene.codecs.lucene90.IndexedDISI;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.KnnVectorValues;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.VectorScorer;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.RandomAccessInput;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.packed.DirectMonotonicReader;

abstract class OffHeapFloatVectorValues
extends FloatVectorValues {
    protected final int dimension;
    protected final int size;
    protected final IndexInput slice;
    protected final int byteSize;
    protected int lastOrd = -1;
    protected final float[] value;
    protected final VectorSimilarityFunction vectorSimilarityFunction;

    OffHeapFloatVectorValues(int dimension, int size, IndexInput slice, VectorSimilarityFunction vectorSimilarityFunction, int byteSize) {
        this.dimension = dimension;
        this.size = size;
        this.slice = slice;
        this.byteSize = byteSize;
        this.value = new float[dimension];
        this.vectorSimilarityFunction = vectorSimilarityFunction;
    }

    public int dimension() {
        return this.dimension;
    }

    public int size() {
        return this.size;
    }

    public float[] vectorValue(int targetOrd) throws IOException {
        if (this.lastOrd == targetOrd) {
            return this.value;
        }
        this.slice.seek((long)targetOrd * (long)this.byteSize);
        this.slice.readFloats(this.value, 0, this.value.length);
        this.lastOrd = targetOrd;
        return this.value;
    }

    static OffHeapFloatVectorValues load(Lucene94HnswVectorsReader.FieldEntry fieldEntry, IndexInput vectorData) throws IOException {
        int byteSize;
        if (fieldEntry.docsWithFieldOffset() == -2L) {
            return new EmptyOffHeapVectorValues(fieldEntry.dimension());
        }
        IndexInput bytesSlice = vectorData.slice("vector-data", fieldEntry.vectorDataOffset(), fieldEntry.vectorDataLength());
        switch (fieldEntry.vectorEncoding()) {
            default: {
                throw new MatchException(null, null);
            }
            case BYTE: {
                int n = fieldEntry.dimension();
                break;
            }
            case FLOAT32: {
                int n = byteSize = fieldEntry.dimension() * 4;
            }
        }
        if (fieldEntry.docsWithFieldOffset() == -1L) {
            return new DenseOffHeapVectorValues(fieldEntry.dimension(), fieldEntry.size(), bytesSlice, fieldEntry.similarityFunction(), byteSize);
        }
        return new SparseOffHeapVectorValues(fieldEntry, vectorData, bytesSlice, fieldEntry.similarityFunction(), byteSize);
    }

    private static class EmptyOffHeapVectorValues
    extends OffHeapFloatVectorValues {
        public EmptyOffHeapVectorValues(int dimension) {
            super(dimension, 0, null, VectorSimilarityFunction.COSINE, 0);
        }

        @Override
        public int dimension() {
            return super.dimension();
        }

        @Override
        public int size() {
            return 0;
        }

        public OffHeapFloatVectorValues copy() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public float[] vectorValue(int targetOrd) throws IOException {
            throw new UnsupportedOperationException();
        }

        public int ordToDoc(int ord) {
            throw new UnsupportedOperationException();
        }

        public KnnVectorValues.DocIndexIterator iterator() {
            return this.createDenseIterator();
        }

        public Bits getAcceptOrds(Bits acceptDocs) {
            return null;
        }

        public VectorScorer scorer(float[] query) {
            return null;
        }
    }

    static class DenseOffHeapVectorValues
    extends OffHeapFloatVectorValues {
        public DenseOffHeapVectorValues(int dimension, int size, IndexInput slice, VectorSimilarityFunction vectorSimilarityFunction, int byteSize) {
            super(dimension, size, slice, vectorSimilarityFunction, byteSize);
        }

        public DenseOffHeapVectorValues copy() throws IOException {
            return new DenseOffHeapVectorValues(this.dimension, this.size, this.slice.clone(), this.vectorSimilarityFunction, this.byteSize);
        }

        public KnnVectorValues.DocIndexIterator iterator() {
            return this.createDenseIterator();
        }

        public Bits getAcceptOrds(Bits acceptDocs) {
            return acceptDocs;
        }

        public VectorScorer scorer(final float[] query) throws IOException {
            final DenseOffHeapVectorValues values = this.copy();
            final KnnVectorValues.DocIndexIterator iterator = values.iterator();
            return new VectorScorer(){

                public float score() throws IOException {
                    return values.vectorSimilarityFunction.compare(values.vectorValue(iterator.index()), query);
                }

                public DocIdSetIterator iterator() {
                    return iterator;
                }
            };
        }
    }

    private static class SparseOffHeapVectorValues
    extends OffHeapFloatVectorValues {
        private final DirectMonotonicReader ordToDoc;
        private final IndexedDISI disi;
        private final IndexInput dataIn;
        private final Lucene94HnswVectorsReader.FieldEntry fieldEntry;

        public SparseOffHeapVectorValues(Lucene94HnswVectorsReader.FieldEntry fieldEntry, IndexInput dataIn, IndexInput slice, VectorSimilarityFunction vectorSimilarityFunction, int byteSize) throws IOException {
            super(fieldEntry.dimension(), fieldEntry.size(), slice, vectorSimilarityFunction, byteSize);
            this.fieldEntry = fieldEntry;
            RandomAccessInput addressesData = dataIn.randomAccessSlice(fieldEntry.addressesOffset(), fieldEntry.addressesLength());
            this.dataIn = dataIn;
            this.ordToDoc = DirectMonotonicReader.getInstance((DirectMonotonicReader.Meta)fieldEntry.meta(), (RandomAccessInput)addressesData);
            this.disi = new IndexedDISI(dataIn, fieldEntry.docsWithFieldOffset(), fieldEntry.docsWithFieldLength(), (int)fieldEntry.jumpTableEntryCount(), fieldEntry.denseRankPower(), (long)fieldEntry.size());
        }

        public SparseOffHeapVectorValues copy() throws IOException {
            return new SparseOffHeapVectorValues(this.fieldEntry, this.dataIn, this.slice.clone(), this.vectorSimilarityFunction, this.byteSize);
        }

        public KnnVectorValues.DocIndexIterator iterator() {
            return IndexedDISI.asDocIndexIterator((IndexedDISI)this.disi);
        }

        public int ordToDoc(int ord) {
            return (int)this.ordToDoc.get((long)ord);
        }

        public Bits getAcceptOrds(final Bits acceptDocs) {
            if (acceptDocs == null) {
                return null;
            }
            return new Bits(){

                public boolean get(int index) {
                    return acceptDocs.get(this.ordToDoc(index));
                }

                public int length() {
                    return size;
                }
            };
        }

        public VectorScorer scorer(final float[] query) throws IOException {
            final SparseOffHeapVectorValues values = this.copy();
            final KnnVectorValues.DocIndexIterator iterator = values.iterator();
            return new VectorScorer(){

                public float score() throws IOException {
                    return values.vectorSimilarityFunction.compare(values.vectorValue(iterator.index()), query);
                }

                public DocIdSetIterator iterator() {
                    return iterator;
                }
            };
        }
    }
}

