/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.mockfile;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Objects;
import org.apache.lucene.tests.mockfile.FilterFileSystem;

public class FilterDirectoryStream
implements DirectoryStream<Path> {
    protected final DirectoryStream<Path> delegate;
    protected final FilterFileSystem fileSystem;

    public FilterDirectoryStream(DirectoryStream<Path> delegate, FilterFileSystem fileSystem) {
        this.delegate = Objects.requireNonNull(delegate);
        this.fileSystem = Objects.requireNonNull(fileSystem);
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    @Override
    public Iterator<Path> iterator() {
        final Iterator<Path> delegateIterator = this.delegate.iterator();
        return new Iterator<Path>(){

            @Override
            public boolean hasNext() {
                return delegateIterator.hasNext();
            }

            @Override
            public Path next() {
                return FilterDirectoryStream.this.fileSystem.parent.wrapPath((Path)delegateIterator.next());
            }

            @Override
            public void remove() {
                delegateIterator.remove();
            }
        };
    }
}

