/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.index;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.function.Supplier;
import org.apache.lucene.document.BinaryDocValuesField;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.document.SortedNumericDocValuesField;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.CheckIndex;
import org.apache.lucene.index.CodecReader;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.DocValuesSkipper;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SerialMergeScheduler;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.Directory;
import org.apache.lucene.tests.analysis.MockAnalyzer;
import org.apache.lucene.tests.index.LegacyBaseDocValuesFormatTestCase;
import org.apache.lucene.tests.index.MismatchedCodecReader;
import org.apache.lucene.tests.index.RandomIndexWriter;
import org.apache.lucene.tests.store.BaseDirectoryWrapper;
import org.apache.lucene.tests.util.LuceneTestCase;
import org.apache.lucene.tests.util.TestUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;

public abstract class BaseDocValuesFormatTestCase
extends LegacyBaseDocValuesFormatTestCase {
    protected boolean skipperHasAccurateDocBounds() {
        return true;
    }

    protected boolean skipperHasAccurateValueBounds() {
        return true;
    }

    public void testSortedMergeAwayAllValuesWithSkipper() throws IOException {
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        IndexWriterConfig iwconfig = BaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        iwconfig.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, iwconfig);
        Document doc = new Document();
        doc.add((IndexableField)new StringField("id", "0", Field.Store.NO));
        iwriter.addDocument(doc);
        doc = new Document();
        doc.add((IndexableField)new StringField("id", "1", Field.Store.NO));
        doc.add((IndexableField)SortedDocValuesField.indexedField((String)"field", (BytesRef)BaseDocValuesFormatTestCase.newBytesRef("hello")));
        iwriter.addDocument(doc);
        iwriter.commit();
        iwriter.deleteDocuments(new Term("id", "1"));
        iwriter.forceMerge(1);
        DirectoryReader ireader = iwriter.getReader();
        iwriter.close();
        SortedDocValues dv = BaseDocValuesFormatTestCase.getOnlyLeafReader((IndexReader)ireader).getSortedDocValues("field");
        BaseDocValuesFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)dv.nextDoc());
        DocValuesSkipper skipper = BaseDocValuesFormatTestCase.getOnlyLeafReader((IndexReader)ireader).getDocValuesSkipper("field");
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)skipper.docCount());
        skipper.advance(0);
        BaseDocValuesFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)skipper.minDocID(0));
        TermsEnum termsEnum = dv.termsEnum();
        BaseDocValuesFormatTestCase.assertFalse((boolean)termsEnum.seekExact(new BytesRef((CharSequence)"lucene")));
        BaseDocValuesFormatTestCase.assertEquals((Object)TermsEnum.SeekStatus.END, (Object)termsEnum.seekCeil(new BytesRef((CharSequence)"lucene")));
        BaseDocValuesFormatTestCase.assertEquals((long)-1L, (long)dv.lookupTerm(new BytesRef((CharSequence)"lucene")));
        ireader.close();
        directory.close();
    }

    public void testSortedSetMergeAwayAllValuesWithSkipper() throws IOException {
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        IndexWriterConfig iwconfig = BaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        iwconfig.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, iwconfig);
        Document doc = new Document();
        doc.add((IndexableField)new StringField("id", "0", Field.Store.NO));
        iwriter.addDocument(doc);
        doc = new Document();
        doc.add((IndexableField)new StringField("id", "1", Field.Store.NO));
        doc.add((IndexableField)SortedSetDocValuesField.indexedField((String)"field", (BytesRef)BaseDocValuesFormatTestCase.newBytesRef("hello")));
        iwriter.addDocument(doc);
        iwriter.commit();
        iwriter.deleteDocuments(new Term("id", "1"));
        iwriter.forceMerge(1);
        DirectoryReader ireader = iwriter.getReader();
        iwriter.close();
        SortedSetDocValues dv = BaseDocValuesFormatTestCase.getOnlyLeafReader((IndexReader)ireader).getSortedSetDocValues("field");
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)dv.getValueCount());
        DocValuesSkipper skipper = BaseDocValuesFormatTestCase.getOnlyLeafReader((IndexReader)ireader).getDocValuesSkipper("field");
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)skipper.docCount());
        skipper.advance(0);
        BaseDocValuesFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)skipper.minDocID(0));
        TermsEnum termsEnum = dv.termsEnum();
        BaseDocValuesFormatTestCase.assertFalse((boolean)termsEnum.seekExact(new BytesRef((CharSequence)"lucene")));
        BaseDocValuesFormatTestCase.assertEquals((Object)TermsEnum.SeekStatus.END, (Object)termsEnum.seekCeil(new BytesRef((CharSequence)"lucene")));
        BaseDocValuesFormatTestCase.assertEquals((long)-1L, (long)dv.lookupTerm(new BytesRef((CharSequence)"lucene")));
        ireader.close();
        directory.close();
    }

    public void testNumberMergeAwayAllValuesWithSkipper() throws IOException {
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        IndexWriterConfig iwconfig = BaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        iwconfig.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, iwconfig);
        Document doc = new Document();
        doc.add((IndexableField)new StringField("id", "0", Field.Store.NO));
        iwriter.addDocument(doc);
        doc = new Document();
        doc.add((IndexableField)new StringField("id", "1", Field.Store.NO));
        doc.add((IndexableField)NumericDocValuesField.indexedField((String)"field", (long)5L));
        iwriter.addDocument(doc);
        iwriter.commit();
        iwriter.deleteDocuments(new Term("id", "1"));
        iwriter.forceMerge(1);
        DirectoryReader ireader = iwriter.getReader();
        iwriter.close();
        NumericDocValues dv = BaseDocValuesFormatTestCase.getOnlyLeafReader((IndexReader)ireader).getNumericDocValues("field");
        BaseDocValuesFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)dv.nextDoc());
        DocValuesSkipper skipper = BaseDocValuesFormatTestCase.getOnlyLeafReader((IndexReader)ireader).getDocValuesSkipper("field");
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)skipper.docCount());
        skipper.advance(0);
        BaseDocValuesFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)skipper.minDocID(0));
        ireader.close();
        directory.close();
    }

    public void testSortedNumberMergeAwayAllValuesWithSkipper() throws IOException {
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        IndexWriterConfig iwconfig = BaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        iwconfig.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, iwconfig);
        Document doc = new Document();
        doc.add((IndexableField)new StringField("id", "0", Field.Store.NO));
        iwriter.addDocument(doc);
        doc = new Document();
        doc.add((IndexableField)new StringField("id", "1", Field.Store.NO));
        doc.add((IndexableField)SortedNumericDocValuesField.indexedField((String)"field", (long)5L));
        iwriter.addDocument(doc);
        iwriter.commit();
        iwriter.deleteDocuments(new Term("id", "1"));
        iwriter.forceMerge(1);
        DirectoryReader ireader = iwriter.getReader();
        iwriter.close();
        SortedNumericDocValues dv = BaseDocValuesFormatTestCase.getOnlyLeafReader((IndexReader)ireader).getSortedNumericDocValues("field");
        BaseDocValuesFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)dv.nextDoc());
        DocValuesSkipper skipper = BaseDocValuesFormatTestCase.getOnlyLeafReader((IndexReader)ireader).getDocValuesSkipper("field");
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)skipper.docCount());
        skipper.advance(0);
        BaseDocValuesFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)skipper.minDocID(0));
        ireader.close();
        directory.close();
    }

    public void testSortedMergeAwayAllValuesLargeSegmentWithSkipper() throws IOException {
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        IndexWriterConfig iwconfig = BaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        iwconfig.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, iwconfig);
        Document doc = new Document();
        doc.add((IndexableField)new StringField("id", "1", Field.Store.NO));
        doc.add((IndexableField)SortedDocValuesField.indexedField((String)"field", (BytesRef)BaseDocValuesFormatTestCase.newBytesRef("hello")));
        iwriter.addDocument(doc);
        int numEmptyDocs = BaseDocValuesFormatTestCase.atLeast(1024);
        for (int i = 0; i < numEmptyDocs; ++i) {
            iwriter.addDocument(new Document());
        }
        iwriter.commit();
        iwriter.deleteDocuments(new Term("id", "1"));
        iwriter.forceMerge(1);
        DirectoryReader ireader = iwriter.getReader();
        iwriter.close();
        SortedDocValues dv = BaseDocValuesFormatTestCase.getOnlyLeafReader((IndexReader)ireader).getSortedDocValues("field");
        BaseDocValuesFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)dv.nextDoc());
        DocValuesSkipper skipper = BaseDocValuesFormatTestCase.getOnlyLeafReader((IndexReader)ireader).getDocValuesSkipper("field");
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)skipper.docCount());
        skipper.advance(0);
        BaseDocValuesFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)skipper.minDocID(0));
        TermsEnum termsEnum = dv.termsEnum();
        BaseDocValuesFormatTestCase.assertFalse((boolean)termsEnum.seekExact(new BytesRef((CharSequence)"lucene")));
        BaseDocValuesFormatTestCase.assertEquals((Object)TermsEnum.SeekStatus.END, (Object)termsEnum.seekCeil(new BytesRef((CharSequence)"lucene")));
        BaseDocValuesFormatTestCase.assertEquals((long)-1L, (long)dv.lookupTerm(new BytesRef((CharSequence)"lucene")));
        ireader.close();
        directory.close();
    }

    public void testSortedSetMergeAwayAllValuesLargeSegmentWithSkipper() throws IOException {
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        IndexWriterConfig iwconfig = BaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        iwconfig.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, iwconfig);
        Document doc = new Document();
        doc.add((IndexableField)new StringField("id", "1", Field.Store.NO));
        doc.add((IndexableField)SortedSetDocValuesField.indexedField((String)"field", (BytesRef)BaseDocValuesFormatTestCase.newBytesRef("hello")));
        iwriter.addDocument(doc);
        int numEmptyDocs = BaseDocValuesFormatTestCase.atLeast(1024);
        for (int i = 0; i < numEmptyDocs; ++i) {
            iwriter.addDocument(new Document());
        }
        iwriter.commit();
        iwriter.deleteDocuments(new Term("id", "1"));
        iwriter.forceMerge(1);
        DirectoryReader ireader = iwriter.getReader();
        iwriter.close();
        SortedSetDocValues dv = BaseDocValuesFormatTestCase.getOnlyLeafReader((IndexReader)ireader).getSortedSetDocValues("field");
        BaseDocValuesFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)dv.nextDoc());
        DocValuesSkipper skipper = BaseDocValuesFormatTestCase.getOnlyLeafReader((IndexReader)ireader).getDocValuesSkipper("field");
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)skipper.docCount());
        skipper.advance(0);
        BaseDocValuesFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)skipper.minDocID(0));
        TermsEnum termsEnum = dv.termsEnum();
        BaseDocValuesFormatTestCase.assertFalse((boolean)termsEnum.seekExact(new BytesRef((CharSequence)"lucene")));
        BaseDocValuesFormatTestCase.assertEquals((Object)TermsEnum.SeekStatus.END, (Object)termsEnum.seekCeil(new BytesRef((CharSequence)"lucene")));
        BaseDocValuesFormatTestCase.assertEquals((long)-1L, (long)dv.lookupTerm(new BytesRef((CharSequence)"lucene")));
        ireader.close();
        directory.close();
    }

    public void testNumericMergeAwayAllValuesLargeSegmentWithSkipper() throws IOException {
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        IndexWriterConfig iwconfig = BaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        iwconfig.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, iwconfig);
        Document doc = new Document();
        doc.add((IndexableField)new StringField("id", "1", Field.Store.NO));
        doc.add((IndexableField)NumericDocValuesField.indexedField((String)"field", (long)42L));
        iwriter.addDocument(doc);
        int numEmptyDocs = BaseDocValuesFormatTestCase.atLeast(1024);
        for (int i = 0; i < numEmptyDocs; ++i) {
            iwriter.addDocument(new Document());
        }
        iwriter.commit();
        iwriter.deleteDocuments(new Term("id", "1"));
        iwriter.forceMerge(1);
        DirectoryReader ireader = iwriter.getReader();
        iwriter.close();
        NumericDocValues dv = BaseDocValuesFormatTestCase.getOnlyLeafReader((IndexReader)ireader).getNumericDocValues("field");
        BaseDocValuesFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)dv.nextDoc());
        DocValuesSkipper skipper = BaseDocValuesFormatTestCase.getOnlyLeafReader((IndexReader)ireader).getDocValuesSkipper("field");
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)skipper.docCount());
        skipper.advance(0);
        BaseDocValuesFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)skipper.minDocID(0));
        ireader.close();
        directory.close();
    }

    public void testSortedNumericMergeAwayAllValuesLargeSegmentWithSkipper() throws IOException {
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        MockAnalyzer analyzer = new MockAnalyzer(BaseDocValuesFormatTestCase.random());
        IndexWriterConfig iwconfig = BaseDocValuesFormatTestCase.newIndexWriterConfig(analyzer);
        iwconfig.setMergePolicy((MergePolicy)BaseDocValuesFormatTestCase.newLogMergePolicy());
        RandomIndexWriter iwriter = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory, iwconfig);
        Document doc = new Document();
        doc.add((IndexableField)new StringField("id", "1", Field.Store.NO));
        doc.add((IndexableField)SortedNumericDocValuesField.indexedField((String)"field", (long)42L));
        iwriter.addDocument(doc);
        int numEmptyDocs = BaseDocValuesFormatTestCase.atLeast(1024);
        for (int i = 0; i < numEmptyDocs; ++i) {
            iwriter.addDocument(new Document());
        }
        iwriter.commit();
        iwriter.deleteDocuments(new Term("id", "1"));
        iwriter.forceMerge(1);
        DirectoryReader ireader = iwriter.getReader();
        iwriter.close();
        SortedNumericDocValues dv = BaseDocValuesFormatTestCase.getOnlyLeafReader((IndexReader)ireader).getSortedNumericDocValues("field");
        BaseDocValuesFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)dv.nextDoc());
        DocValuesSkipper skipper = BaseDocValuesFormatTestCase.getOnlyLeafReader((IndexReader)ireader).getDocValuesSkipper("field");
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)skipper.docCount());
        skipper.advance(0);
        BaseDocValuesFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)skipper.minDocID(0));
        ireader.close();
        directory.close();
    }

    public void testNumericDocValuesWithSkipperSmall() throws Exception {
        this.doTestNumericDocValuesWithSkipper(BaseDocValuesFormatTestCase.random().nextInt(1, 1000));
    }

    public void testNumericDocValuesWithSkipperMedium() throws Exception {
        this.doTestNumericDocValuesWithSkipper(BaseDocValuesFormatTestCase.random().nextInt(1000, 20000));
    }

    @LuceneTestCase.Nightly
    public void testNumericDocValuesWithSkipperBig() throws Exception {
        this.doTestNumericDocValuesWithSkipper(BaseDocValuesFormatTestCase.random().nextInt(50000, 100000));
    }

    private void doTestNumericDocValuesWithSkipper(int totalDocs) throws Exception {
        this.assertDocValuesWithSkipper(totalDocs, new TestDocValueSkipper(this){

            @Override
            public void populateDoc(Document doc) {
                doc.add((IndexableField)NumericDocValuesField.indexedField((String)"test", (long)LuceneTestCase.random().nextLong()));
            }

            @Override
            public DocValuesWrapper docValuesWrapper(LeafReader leafReader) throws IOException {
                final NumericDocValues numericDocValues = leafReader.getNumericDocValues("test");
                return new DocValuesWrapper(){

                    @Override
                    public int advance(int target) throws IOException {
                        return numericDocValues.advance(target);
                    }

                    @Override
                    public boolean advanceExact(int target) throws IOException {
                        return numericDocValues.advanceExact(target);
                    }

                    @Override
                    public long maxValue() throws IOException {
                        return numericDocValues.longValue();
                    }

                    @Override
                    public long minValue() throws IOException {
                        return numericDocValues.longValue();
                    }

                    @Override
                    public int docID() {
                        return numericDocValues.docID();
                    }
                };
            }

            @Override
            public DocValuesSkipper docValuesSkipper(LeafReader leafReader) throws IOException {
                return leafReader.getDocValuesSkipper("test");
            }
        });
    }

    public void testSortedNumericDocValuesWithSkipperSmall() throws Exception {
        this.doTestSortedNumericDocValuesWithSkipper(BaseDocValuesFormatTestCase.random().nextInt(1, 1000));
    }

    public void testSortedNumericDocValuesWithSkipperMedium() throws Exception {
        this.doTestSortedNumericDocValuesWithSkipper(BaseDocValuesFormatTestCase.random().nextInt(1000, 20000));
    }

    @LuceneTestCase.Nightly
    public void testSortedNumericDocValuesWithSkipperBig() throws Exception {
        this.doTestSortedNumericDocValuesWithSkipper(BaseDocValuesFormatTestCase.random().nextInt(50000, 100000));
    }

    private void doTestSortedNumericDocValuesWithSkipper(int totalDocs) throws Exception {
        this.assertDocValuesWithSkipper(totalDocs, new TestDocValueSkipper(this){

            @Override
            public void populateDoc(Document doc) {
                for (int j = 0; j < LuceneTestCase.random().nextInt(1, 5); ++j) {
                    doc.add((IndexableField)SortedNumericDocValuesField.indexedField((String)"test", (long)LuceneTestCase.random().nextLong()));
                }
            }

            @Override
            public DocValuesWrapper docValuesWrapper(LeafReader leafReader) throws IOException {
                final SortedNumericDocValues sortedNumericDocValues = leafReader.getSortedNumericDocValues("test");
                return new DocValuesWrapper(){
                    long max;
                    long min;

                    @Override
                    public int advance(int target) throws IOException {
                        int doc = sortedNumericDocValues.advance(target);
                        if (doc != Integer.MAX_VALUE) {
                            this.readValues();
                        }
                        return doc;
                    }

                    @Override
                    public boolean advanceExact(int target) throws IOException {
                        if (sortedNumericDocValues.advanceExact(target)) {
                            this.readValues();
                            return true;
                        }
                        return false;
                    }

                    private void readValues() throws IOException {
                        this.max = Long.MIN_VALUE;
                        this.min = Long.MAX_VALUE;
                        for (int i = 0; i < sortedNumericDocValues.docValueCount(); ++i) {
                            long value = sortedNumericDocValues.nextValue();
                            this.max = Math.max(this.max, value);
                            this.min = Math.min(this.min, value);
                        }
                    }

                    @Override
                    public long maxValue() {
                        return this.max;
                    }

                    @Override
                    public long minValue() {
                        return this.min;
                    }

                    @Override
                    public int docID() {
                        return sortedNumericDocValues.docID();
                    }
                };
            }

            @Override
            public DocValuesSkipper docValuesSkipper(LeafReader leafReader) throws IOException {
                return leafReader.getDocValuesSkipper("test");
            }
        });
    }

    public void testSortedDocValuesWithSkipperSmall() throws Exception {
        this.doTestSortedDocValuesWithSkipper(BaseDocValuesFormatTestCase.random().nextInt(1, 1000));
    }

    public void testSortedDocValuesWithSkipperMedium() throws Exception {
        this.doTestSortedDocValuesWithSkipper(BaseDocValuesFormatTestCase.random().nextInt(1000, 20000));
    }

    @LuceneTestCase.Nightly
    public void testSortedDocValuesWithSkipperBig() throws Exception {
        this.doTestSortedDocValuesWithSkipper(BaseDocValuesFormatTestCase.random().nextInt(50000, 100000));
    }

    private void doTestSortedDocValuesWithSkipper(int totalDocs) throws Exception {
        this.assertDocValuesWithSkipper(totalDocs, new TestDocValueSkipper(this){

            @Override
            public void populateDoc(Document doc) {
                doc.add((IndexableField)SortedDocValuesField.indexedField((String)"test", (BytesRef)TestUtil.randomBinaryTerm(LuceneTestCase.random())));
            }

            @Override
            public DocValuesWrapper docValuesWrapper(LeafReader leafReader) throws IOException {
                final SortedDocValues sortedDocValues = leafReader.getSortedDocValues("test");
                return new DocValuesWrapper(){

                    @Override
                    public int advance(int target) throws IOException {
                        return sortedDocValues.advance(target);
                    }

                    @Override
                    public boolean advanceExact(int target) throws IOException {
                        return sortedDocValues.advanceExact(target);
                    }

                    @Override
                    public long maxValue() throws IOException {
                        return sortedDocValues.ordValue();
                    }

                    @Override
                    public long minValue() throws IOException {
                        return sortedDocValues.ordValue();
                    }

                    @Override
                    public int docID() {
                        return sortedDocValues.docID();
                    }
                };
            }

            @Override
            public DocValuesSkipper docValuesSkipper(LeafReader leafReader) throws IOException {
                return leafReader.getDocValuesSkipper("test");
            }
        });
    }

    public void testSortedSetDocValuesWithSkipperSmall() throws Exception {
        this.doTestSortedSetDocValuesWithSkipper(BaseDocValuesFormatTestCase.random().nextInt(1, 1000));
    }

    public void testSortedSetDocValuesWithSkipperMedium() throws Exception {
        this.doTestSortedSetDocValuesWithSkipper(BaseDocValuesFormatTestCase.random().nextInt(10000, 20000));
    }

    @LuceneTestCase.Nightly
    public void testSortedSetDocValuesWithSkipperBig() throws Exception {
        this.doTestSortedSetDocValuesWithSkipper(BaseDocValuesFormatTestCase.random().nextInt(50000, 100000));
    }

    private void doTestSortedSetDocValuesWithSkipper(int totalDocs) throws Exception {
        this.assertDocValuesWithSkipper(totalDocs, new TestDocValueSkipper(this){

            @Override
            public void populateDoc(Document doc) {
                for (int j = 0; j < LuceneTestCase.random().nextInt(1, 5); ++j) {
                    doc.add((IndexableField)SortedSetDocValuesField.indexedField((String)"test", (BytesRef)TestUtil.randomBinaryTerm(LuceneTestCase.random())));
                }
            }

            @Override
            public DocValuesWrapper docValuesWrapper(LeafReader leafReader) throws IOException {
                final SortedSetDocValues sortedSetDocValues = leafReader.getSortedSetDocValues("test");
                return new DocValuesWrapper(){
                    long max;
                    long min;

                    @Override
                    public int advance(int target) throws IOException {
                        int doc = sortedSetDocValues.advance(target);
                        if (doc != Integer.MAX_VALUE) {
                            this.readValues();
                        }
                        return doc;
                    }

                    @Override
                    public boolean advanceExact(int target) throws IOException {
                        if (sortedSetDocValues.advanceExact(target)) {
                            this.readValues();
                            return true;
                        }
                        return false;
                    }

                    private void readValues() throws IOException {
                        this.max = Long.MIN_VALUE;
                        this.min = Long.MAX_VALUE;
                        for (int i = 0; i < sortedSetDocValues.docValueCount(); ++i) {
                            long value = sortedSetDocValues.nextOrd();
                            this.max = Math.max(this.max, value);
                            this.min = Math.min(this.min, value);
                        }
                    }

                    @Override
                    public long maxValue() {
                        return this.max;
                    }

                    @Override
                    public long minValue() {
                        return this.min;
                    }

                    @Override
                    public int docID() {
                        return sortedSetDocValues.docID();
                    }
                };
            }

            @Override
            public DocValuesSkipper docValuesSkipper(LeafReader leafReader) throws IOException {
                return leafReader.getDocValuesSkipper("test");
            }
        });
    }

    private void assertDocValuesWithSkipper(int totalDocs, TestDocValueSkipper testDocValueSkipper) throws Exception {
        Supplier<Boolean> booleanSupplier = switch (BaseDocValuesFormatTestCase.random().nextInt(3)) {
            case 0 -> () -> true;
            case 1 -> () -> BaseDocValuesFormatTestCase.random().nextBoolean();
            case 2 -> () -> BaseDocValuesFormatTestCase.random().nextBoolean() && BaseDocValuesFormatTestCase.random().nextBoolean();
            default -> throw new AssertionError();
        };
        BaseDirectoryWrapper directory = BaseDocValuesFormatTestCase.newDirectory();
        RandomIndexWriter writer = new RandomIndexWriter(BaseDocValuesFormatTestCase.random(), (Directory)directory);
        int numDocs = 0;
        for (int i = 0; i < totalDocs; ++i) {
            Document doc = new Document();
            if (booleanSupplier.get().booleanValue()) {
                testDocValueSkipper.populateDoc(doc);
                ++numDocs;
            }
            writer.addDocument(doc);
            if (!BaseDocValuesFormatTestCase.rarely()) continue;
            writer.commit();
        }
        writer.flush();
        if (BaseDocValuesFormatTestCase.random().nextBoolean()) {
            writer.forceMerge(1);
        }
        DirectoryReader r = writer.getReader();
        int readDocs = 0;
        for (LeafReaderContext readerContext : r.leaves()) {
            LeafReader reader = readerContext.reader();
            ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);
            PrintStream infoStream = new PrintStream((OutputStream)bos, false, StandardCharsets.UTF_8);
            CheckIndex.Status.DocValuesStatus status = CheckIndex.testDocValues((CodecReader)((CodecReader)reader), (PrintStream)infoStream, (boolean)true);
            if (status.error != null) {
                throw new Exception(status.error);
            }
            readDocs += this.assertDocValuesSkipSequential(testDocValueSkipper.docValuesWrapper(reader), testDocValueSkipper.docValuesSkipper(reader));
            for (int i = 0; i < 10; ++i) {
                BaseDocValuesFormatTestCase.assertDocValuesSkipRandom(testDocValueSkipper.docValuesWrapper(reader), testDocValueSkipper.docValuesSkipper(reader), reader.maxDoc());
            }
        }
        BaseDocValuesFormatTestCase.assertEquals((long)numDocs, (long)readDocs);
        IOUtils.close((Closeable[])new Closeable[]{r, writer, directory});
    }

    private int assertDocValuesSkipSequential(DocValuesWrapper iterator, DocValuesSkipper skipper) throws IOException {
        if (skipper == null) {
            return 0;
        }
        BaseDocValuesFormatTestCase.assertEquals((long)-1L, (long)iterator.docID());
        BaseDocValuesFormatTestCase.assertEquals((long)-1L, (long)skipper.minDocID(0));
        BaseDocValuesFormatTestCase.assertEquals((long)-1L, (long)skipper.maxDocID(0));
        iterator.advance(0);
        int docCount = 0;
        block0: while (true) {
            int previousMaxDoc = skipper.maxDocID(0);
            skipper.advance(previousMaxDoc + 1);
            BaseDocValuesFormatTestCase.assertTrue((skipper.minDocID(0) > previousMaxDoc ? 1 : 0) != 0);
            if (this.skipperHasAccurateDocBounds()) {
                BaseDocValuesFormatTestCase.assertEquals((long)iterator.docID(), (long)skipper.minDocID(0));
            } else {
                BaseDocValuesFormatTestCase.assertTrue((String)("Expected: " + iterator.docID() + " but got " + skipper.minDocID(0)), (skipper.minDocID(0) <= iterator.docID() ? 1 : 0) != 0);
            }
            if (skipper.minDocID(0) == Integer.MAX_VALUE) {
                BaseDocValuesFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)skipper.maxDocID(0));
                break;
            }
            BaseDocValuesFormatTestCase.assertTrue((skipper.docCount(0) > 0 ? 1 : 0) != 0);
            int maxDoc = -1;
            long minVal = Long.MAX_VALUE;
            long maxVal = Long.MIN_VALUE;
            for (int i = 0; i < skipper.docCount(0); ++i) {
                BaseDocValuesFormatTestCase.assertNotEquals((long)Integer.MAX_VALUE, (long)iterator.docID());
                maxDoc = Math.max(maxDoc, iterator.docID());
                minVal = Math.min(minVal, iterator.minValue());
                maxVal = Math.max(maxVal, iterator.maxValue());
                iterator.advance(iterator.docID() + 1);
            }
            if (this.skipperHasAccurateDocBounds()) {
                BaseDocValuesFormatTestCase.assertEquals((long)maxDoc, (long)skipper.maxDocID(0));
            } else {
                BaseDocValuesFormatTestCase.assertTrue((String)("Expected: " + maxDoc + " but got " + skipper.maxDocID(0)), (skipper.maxDocID(0) >= maxDoc ? 1 : 0) != 0);
            }
            if (this.skipperHasAccurateValueBounds()) {
                BaseDocValuesFormatTestCase.assertEquals((long)minVal, (long)skipper.minValue(0));
                BaseDocValuesFormatTestCase.assertEquals((long)maxVal, (long)skipper.maxValue(0));
            } else {
                BaseDocValuesFormatTestCase.assertTrue((String)("Expected: " + minVal + " but got " + skipper.minValue(0)), (minVal >= skipper.minValue(0) ? 1 : 0) != 0);
                BaseDocValuesFormatTestCase.assertTrue((String)("Expected: " + maxVal + " but got " + skipper.maxValue(0)), (maxVal <= skipper.maxValue(0) ? 1 : 0) != 0);
            }
            docCount += skipper.docCount(0);
            int level = 1;
            while (true) {
                if (level >= skipper.numLevels()) continue block0;
                BaseDocValuesFormatTestCase.assertTrue((skipper.minDocID(0) >= skipper.minDocID(level) ? 1 : 0) != 0);
                BaseDocValuesFormatTestCase.assertTrue((skipper.maxDocID(0) <= skipper.maxDocID(level) ? 1 : 0) != 0);
                BaseDocValuesFormatTestCase.assertTrue((skipper.minValue(0) >= skipper.minValue(level) ? 1 : 0) != 0);
                BaseDocValuesFormatTestCase.assertTrue((skipper.maxValue(0) <= skipper.maxValue(level) ? 1 : 0) != 0);
                BaseDocValuesFormatTestCase.assertTrue((skipper.docCount(0) < skipper.docCount(level) ? 1 : 0) != 0);
                ++level;
            }
            break;
        }
        BaseDocValuesFormatTestCase.assertEquals((long)docCount, (long)skipper.docCount());
        return docCount;
    }

    private static void assertDocValuesSkipRandom(DocValuesWrapper iterator, DocValuesSkipper skipper, int maxDoc) throws IOException {
        if (skipper == null) {
            return;
        }
        int nextLevel = 0;
        while (true) {
            int doc = BaseDocValuesFormatTestCase.random().nextInt(skipper.maxDocID(nextLevel), maxDoc + 1) + 1;
            skipper.advance(doc);
            if (skipper.minDocID(0) == Integer.MAX_VALUE) {
                BaseDocValuesFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)skipper.maxDocID(0));
                return;
            }
            if (iterator.advanceExact(doc)) {
                for (int level = 0; level < skipper.numLevels(); ++level) {
                    BaseDocValuesFormatTestCase.assertTrue((iterator.docID() >= skipper.minDocID(level) ? 1 : 0) != 0);
                    BaseDocValuesFormatTestCase.assertTrue((iterator.docID() <= skipper.maxDocID(level) ? 1 : 0) != 0);
                    BaseDocValuesFormatTestCase.assertTrue((iterator.minValue() >= skipper.minValue(level) ? 1 : 0) != 0);
                    BaseDocValuesFormatTestCase.assertTrue((iterator.maxValue() <= skipper.maxValue(level) ? 1 : 0) != 0);
                }
            }
            nextLevel = BaseDocValuesFormatTestCase.random().nextInt(skipper.numLevels());
        }
    }

    public void testMismatchedFields() throws Exception {
        BaseDirectoryWrapper dir1 = BaseDocValuesFormatTestCase.newDirectory();
        IndexWriter w1 = new IndexWriter((Directory)dir1, BaseDocValuesFormatTestCase.newIndexWriterConfig());
        Document doc = new Document();
        doc.add((IndexableField)new BinaryDocValuesField("binary", new BytesRef((CharSequence)"lucene")));
        doc.add((IndexableField)new NumericDocValuesField("numeric", 0L));
        doc.add((IndexableField)new SortedDocValuesField("sorted", new BytesRef((CharSequence)"search")));
        doc.add((IndexableField)new SortedNumericDocValuesField("sorted_numeric", 1L));
        doc.add((IndexableField)new SortedSetDocValuesField("sorted_set", new BytesRef((CharSequence)"engine")));
        w1.addDocument((Iterable)doc);
        BaseDirectoryWrapper dir2 = BaseDocValuesFormatTestCase.newDirectory();
        IndexWriter w2 = new IndexWriter((Directory)dir2, BaseDocValuesFormatTestCase.newIndexWriterConfig().setMergeScheduler((MergeScheduler)new SerialMergeScheduler()));
        w2.addDocument((Iterable)doc);
        w2.commit();
        DirectoryReader reader = DirectoryReader.open((IndexWriter)w1);
        w1.close();
        w2.addIndexes(new CodecReader[]{new MismatchedCodecReader((CodecReader)BaseDocValuesFormatTestCase.getOnlyLeafReader((IndexReader)reader), BaseDocValuesFormatTestCase.random())});
        reader.close();
        w2.forceMerge(1);
        reader = DirectoryReader.open((IndexWriter)w2);
        w2.close();
        LeafReader leafReader = BaseDocValuesFormatTestCase.getOnlyLeafReader((IndexReader)reader);
        BinaryDocValues bdv = leafReader.getBinaryDocValues("binary");
        BaseDocValuesFormatTestCase.assertNotNull((Object)bdv);
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)bdv.nextDoc());
        BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"lucene"), (Object)bdv.binaryValue());
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)bdv.nextDoc());
        BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"lucene"), (Object)bdv.binaryValue());
        BaseDocValuesFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)bdv.nextDoc());
        NumericDocValues ndv = leafReader.getNumericDocValues("numeric");
        BaseDocValuesFormatTestCase.assertNotNull((Object)ndv);
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)ndv.nextDoc());
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)ndv.longValue());
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)ndv.nextDoc());
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)ndv.longValue());
        BaseDocValuesFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)ndv.nextDoc());
        SortedDocValues sdv = leafReader.getSortedDocValues("sorted");
        BaseDocValuesFormatTestCase.assertNotNull((Object)sdv);
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)sdv.nextDoc());
        BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"search"), (Object)sdv.lookupOrd(sdv.ordValue()));
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)sdv.nextDoc());
        BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"search"), (Object)sdv.lookupOrd(sdv.ordValue()));
        BaseDocValuesFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)sdv.nextDoc());
        SortedNumericDocValues sndv = leafReader.getSortedNumericDocValues("sorted_numeric");
        BaseDocValuesFormatTestCase.assertNotNull((Object)sndv);
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)sndv.nextDoc());
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)sndv.nextValue());
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)sndv.nextDoc());
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)sndv.nextValue());
        BaseDocValuesFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)sndv.nextDoc());
        SortedSetDocValues ssdv = leafReader.getSortedSetDocValues("sorted_set");
        BaseDocValuesFormatTestCase.assertNotNull((Object)ssdv);
        BaseDocValuesFormatTestCase.assertEquals((long)0L, (long)ssdv.nextDoc());
        BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"engine"), (Object)ssdv.lookupOrd(ssdv.nextOrd()));
        BaseDocValuesFormatTestCase.assertEquals((long)1L, (long)ssdv.nextDoc());
        BaseDocValuesFormatTestCase.assertEquals((Object)new BytesRef((CharSequence)"engine"), (Object)ssdv.lookupOrd(ssdv.nextOrd()));
        BaseDocValuesFormatTestCase.assertEquals((long)Integer.MAX_VALUE, (long)ssdv.nextDoc());
        IOUtils.close((Closeable[])new Closeable[]{reader, w2, dir1, dir2});
    }

    private static interface TestDocValueSkipper {
        public void populateDoc(Document var1);

        public DocValuesWrapper docValuesWrapper(LeafReader var1) throws IOException;

        public DocValuesSkipper docValuesSkipper(LeafReader var1) throws IOException;
    }

    private static interface DocValuesWrapper {
        public int advance(int var1) throws IOException;

        public boolean advanceExact(int var1) throws IOException;

        public long maxValue() throws IOException;

        public long minValue() throws IOException;

        public int docID();
    }
}

