/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.test.spi;

import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.logging.log4j.spi.ThreadContextMap;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@Execution(value=ExecutionMode.CONCURRENT)
public abstract class ThreadContextMapSuite {
    private static final String KEY = "key";

    protected static void threadLocalNotInheritableByDefault(ThreadContextMap contextMap) {
        contextMap.put(KEY, "threadLocalNotInheritableByDefault");
        ThreadContextMapSuite.verifyThreadContextValueFromANewThread(contextMap, null);
    }

    protected static void threadLocalInheritableIfConfigured(ThreadContextMap contextMap) {
        contextMap.put(KEY, "threadLocalInheritableIfConfigured");
        ThreadContextMapSuite.verifyThreadContextValueFromANewThread(contextMap, "threadLocalInheritableIfConfigured");
    }

    protected static void singleValue(ThreadContextMap contextMap) {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)contextMap.isEmpty()).as("Map is empty", new Object[0])).isTrue();
        contextMap.put(KEY, "testPut");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)contextMap.isEmpty()).as("Map is not empty", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)contextMap.containsKey(KEY)).as("Map key exists", new Object[0])).isTrue();
        ((AbstractStringAssert)Assertions.assertThat((String)contextMap.get(KEY)).as("Map contains expected value", new Object[0])).isEqualTo("testPut");
        contextMap.remove(KEY);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)contextMap.isEmpty()).as("Map is empty", new Object[0])).isTrue();
    }

    protected static void getCopyReturnsMutableCopy(ThreadContextMap contextMap) {
        contextMap.put(KEY, "testGetCopyReturnsMutableCopy");
        Map copy = contextMap.getCopy();
        ((MapAssert)Assertions.assertThat((Map)copy).as("Copy contains same value", new Object[0])).containsExactly(new Map.Entry[]{Assertions.entry((Object)KEY, (Object)"testGetCopyReturnsMutableCopy")});
        copy.put(KEY, "testGetCopyReturnsMutableCopy2");
        ((AbstractStringAssert)Assertions.assertThat((String)contextMap.get(KEY)).as("Original map is not affected by changes in the copy", new Object[0])).isEqualTo("testGetCopyReturnsMutableCopy");
        contextMap.clear();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)contextMap.isEmpty()).as("Original map is empty", new Object[0])).isTrue();
        ((MapAssert)Assertions.assertThat((Map)copy).as("Copy is not affected by changes in the map.", new Object[0])).containsExactly(new Map.Entry[]{Assertions.entry((Object)KEY, (Object)"testGetCopyReturnsMutableCopy2")});
    }

    protected static void getImmutableMapReturnsNullIfEmpty(ThreadContextMap contextMap) {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)contextMap.isEmpty()).as("Original map is empty", new Object[0])).isTrue();
        ((MapAssert)Assertions.assertThat((Map)contextMap.getImmutableMapOrNull()).as("Immutable copy is null", new Object[0])).isNull();
    }

    protected static void getImmutableMapReturnsImmutableMapIfNonEmpty(ThreadContextMap contextMap) {
        contextMap.put(KEY, "getImmutableMapReturnsImmutableMapIfNonEmpty");
        Map immutable = contextMap.getImmutableMapOrNull();
        ((MapAssert)Assertions.assertThat((Map)immutable).as("Immutable copy contains same value", new Object[0])).containsExactly(new Map.Entry[]{Assertions.entry((Object)KEY, (Object)"getImmutableMapReturnsImmutableMapIfNonEmpty")});
        org.junit.jupiter.api.Assertions.assertThrows(UnsupportedOperationException.class, () -> immutable.put(KEY, "getImmutableMapReturnsNullIfEmpty2"));
    }

    protected static void getImmutableMapCopyNotAffectedByContextMapChanges(ThreadContextMap contextMap) {
        contextMap.put(KEY, "getImmutableMapCopyNotAffectedByContextMapChanges");
        Map immutable = contextMap.getImmutableMapOrNull();
        contextMap.put(KEY, "getImmutableMapCopyNotAffectedByContextMapChanges2");
        ((MapAssert)Assertions.assertThat((Map)immutable).as("Immutable copy contains the original value", new Object[0])).containsExactly(new Map.Entry[]{Assertions.entry((Object)KEY, (Object)"getImmutableMapCopyNotAffectedByContextMapChanges")});
    }

    private static void verifyThreadContextValueFromANewThread(ThreadContextMap contextMap, String expected) {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        try {
            Assertions.assertThat(executorService.submit(() -> contextMap.get(KEY))).succeedsWithin(Duration.ofSeconds(1L)).isEqualTo((Object)expected);
        }
        finally {
            executorService.shutdown();
        }
    }
}

