/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import kafka.server.MetadataCache;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.server.share.SharePartitionKey;
import org.apache.kafka.server.share.persister.ShareCoordinatorMetadataCacheHelper;
import scala.collection.Seq;
import scala.collection.Set;
import scala.jdk.javaapi.CollectionConverters;
import scala.jdk.javaapi.OptionConverters;

public class ShareCoordinatorMetadataCacheHelperImpl
implements ShareCoordinatorMetadataCacheHelper {
    private final MetadataCache metadataCache;
    private final Function<SharePartitionKey, Integer> keyToPartitionMapper;
    private final ListenerName interBrokerListenerName;

    public ShareCoordinatorMetadataCacheHelperImpl(MetadataCache metadataCache, Function<SharePartitionKey, Integer> keyToPartitionMapper, ListenerName interBrokerListenerName) {
        Objects.requireNonNull(metadataCache, "metadataCache must not be null");
        Objects.requireNonNull(keyToPartitionMapper, "keyToPartitionMapper must not be null");
        Objects.requireNonNull(interBrokerListenerName, "interBrokerListenerName must not be null");
        this.metadataCache = metadataCache;
        this.keyToPartitionMapper = keyToPartitionMapper;
        this.interBrokerListenerName = interBrokerListenerName;
    }

    public boolean containsTopic(String topic) {
        return this.metadataCache.contains(topic);
    }

    public Node getShareCoordinator(SharePartitionKey key, String internalTopicName) {
        if (this.metadataCache.contains(internalTopicName)) {
            HashSet<String> topicSet = new HashSet<String>();
            topicSet.add(internalTopicName);
            List topicMetadata = CollectionConverters.asJava(this.metadataCache.getTopicMetadata((Set<String>)CollectionConverters.asScala(topicSet), this.interBrokerListenerName, false, false));
            if (topicMetadata == null || topicMetadata.isEmpty() || ((MetadataResponseData.MetadataResponseTopic)topicMetadata.get(0)).errorCode() != Errors.NONE.code()) {
                return Node.noNode();
            }
            int partition = this.keyToPartitionMapper.apply(key);
            Optional<MetadataResponseData.MetadataResponsePartition> response = ((MetadataResponseData.MetadataResponseTopic)topicMetadata.get(0)).partitions().stream().filter(responsePart -> responsePart.partitionIndex() == partition && responsePart.leaderId() != -1).findFirst();
            if (response.isPresent()) {
                return OptionConverters.toJava(this.metadataCache.getAliveBrokerNode(response.get().leaderId(), this.interBrokerListenerName)).orElse(Node.noNode());
            }
            return Node.noNode();
        }
        return Node.noNode();
    }

    public List<Node> getClusterNodes() {
        return CollectionConverters.asJava((Seq)this.metadataCache.getAliveBrokerNodes(this.interBrokerListenerName).toSeq());
    }
}

