/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.task.eventsourcing;

import java.io.Serializable;
import org.apache.james.eventsourcing.Event;
import org.apache.james.eventsourcing.EventId;
import org.apache.james.eventsourcing.EventId$;
import org.apache.james.eventsourcing.eventstore.History;
import org.apache.james.task.Hostname;
import org.apache.james.task.Task;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.james.task.TaskManager;
import org.apache.james.task.eventsourcing.AdditionalInformationUpdated;
import org.apache.james.task.eventsourcing.CancelRequested;
import org.apache.james.task.eventsourcing.Cancelled;
import org.apache.james.task.eventsourcing.Completed;
import org.apache.james.task.eventsourcing.Created;
import org.apache.james.task.eventsourcing.DecisionProjection;
import org.apache.james.task.eventsourcing.DecisionProjection$;
import org.apache.james.task.eventsourcing.Failed;
import org.apache.james.task.eventsourcing.Started;
import org.apache.james.task.eventsourcing.TaskAggregate$;
import org.apache.james.task.eventsourcing.TaskAggregateId;
import org.apache.james.task.eventsourcing.TaskEvent;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.LinearSeqOps;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\u0005\re\u0001B\r\u001b\u0001\u0015B\u0001\u0002\f\u0001\u0003\u0006\u0004%\t!\f\u0005\te\u0001\u0011\t\u0011)A\u0005]!A1\u0007\u0001BC\u0002\u0013%A\u0007\u0003\u0005=\u0001\t\u0005\t\u0015!\u00036\u0011\u0015i\u0004\u0001\"\u0003?\u0011\u001d\u0011\u0005A1A\u0005\n\rCaa\u0012\u0001!\u0002\u0013!\u0005\"\u0002\"\u0001\t\u0013A\u0005bB(\u0001\u0005\u0004%I\u0001\u0015\u0005\u0007)\u0002\u0001\u000b\u0011B)\t\u000bU\u0003A\u0011\u0002,\t\u000b\u0005\u0004A\u0011\u00022\t\u000b\u0011\u0004A\u0011B3\t\rM\u0004A\u0011\u0001\u000eu\u0011\u0019Y\b\u0001\"\u0001\u001by\"1a\u0010\u0001C\u00015}D\u0001\"a\t\u0001\t\u0003Q\u0012Q\u0005\u0005\t\u0003{\u0001A\u0011\u0001\u000e\u0002@!A\u0011Q\f\u0001\u0005\u0002i\tyfB\u0004\u0002diA\t!!\u001a\u0007\reQ\u0002\u0012AA4\u0011\u0019iT\u0003\"\u0001\u0002j!9\u00111N\u000b\u0005\u0002\u00055\u0004bBA:+\u0011\u0005\u0011Q\u000f\u0002\u000e)\u0006\u001c8.Q4he\u0016<\u0017\r^3\u000b\u0005ma\u0012!D3wK:$8o\\;sG&twM\u0003\u0002\u001e=\u0005!A/Y:l\u0015\ty\u0002%A\u0003kC6,7O\u0003\u0002\"E\u00051\u0011\r]1dQ\u0016T\u0011aI\u0001\u0004_J<7\u0001A\n\u0003\u0001\u0019\u0002\"a\n\u0016\u000e\u0003!R\u0011!K\u0001\u0006g\u000e\fG.Y\u0005\u0003W!\u0012a!\u00118z%\u00164\u0017aC1hOJ,w-\u0019;f\u0013\u0012,\u0012A\f\t\u0003_Aj\u0011AG\u0005\u0003ci\u0011q\u0002V1tW\u0006;wM]3hCR,\u0017\nZ\u0001\rC\u001e<'/Z4bi\u0016LE\rI\u0001\bQ&\u001cHo\u001c:z+\u0005)\u0004C\u0001\u001c;\u001b\u00059$B\u0001\u001d:\u0003))g/\u001a8ugR|'/\u001a\u0006\u00037yI!aO\u001c\u0003\u000f!K7\u000f^8ss\u0006A\u0001.[:u_JL\b%\u0001\u0004=S:LGO\u0010\u000b\u0004\u007f\u0001\u000b\u0005CA\u0018\u0001\u0011\u0015aS\u00011\u0001/\u0011\u0015\u0019T\u00011\u00016\u00031Ig.\u001b;jC2,e/\u001a8u+\u0005!\u0005CA\u0018F\u0013\t1%DA\u0005UCN\\WI^3oi\u0006i\u0011N\\5uS\u0006dWI^3oi\u0002\"\"\u0001R%\t\u000b)C\u0001\u0019A&\u0002\u000b\u00154XM\u001c;\u0011\u00051kU\"A\u001d\n\u00059K$!B#wK:$\u0018!G2veJ,g\u000e\u001e#fG&\u001c\u0018n\u001c8Qe>TWm\u0019;j_:,\u0012!\u0015\t\u0003_IK!a\u0015\u000e\u0003%\u0011+7-[:j_:\u0004&o\u001c6fGRLwN\\\u0001\u001bGV\u0014(/\u001a8u\t\u0016\u001c\u0017n]5p]B\u0013xN[3di&|g\u000eI\u0001\u0019GJ,\u0017\r^3Fm\u0016tG/\u00134O_R4\u0015N\\5tQ\u0016$GCA,[!\r9\u0003lS\u0005\u00033\"\u0012aa\u00149uS>t\u0007\"\u0002&\f\u0001\u0004Y\u0006\u0003B\u0014]=.K!!\u0018\u0015\u0003\u0013\u0019+hn\u0019;j_:\f\u0004C\u0001'`\u0013\t\u0001\u0017HA\u0004Fm\u0016tG/\u00133\u0002\u0017\r\u0014X-\u0019;f\u000bZ,g\u000e\u001e\u000b\u0003/\u000eDQA\u0013\u0007A\u0002m\u000bad\u0019:fCR,WI^3oi&3gj\u001c;GS:L7\u000f[3e\u0003Nd\u0015n\u001d;\u0015\u0005\u0019\u0014\bcA4p\u0017:\u0011\u0001.\u001c\b\u0003S2l\u0011A\u001b\u0006\u0003W\u0012\na\u0001\u0010:p_Rt\u0014\"A\u0015\n\u00059D\u0013a\u00029bG.\fw-Z\u0005\u0003aF\u0014A\u0001T5ti*\u0011a\u000e\u000b\u0005\u0006\u00156\u0001\raW\u0001\u0006gR\f'\u000f\u001e\u000b\u0003MVDQA\u001e\bA\u0002]\f\u0001\u0002[8ti:\fW.\u001a\t\u0003qfl\u0011\u0001H\u0005\u0003ur\u0011\u0001\u0002S8ti:\fW.Z\u0001\u000ee\u0016\fX/Z:u\u0007\u0006t7-\u001a7\u0015\u0005\u0019l\b\"\u0002<\u0010\u0001\u00049\u0018AB;qI\u0006$X\rF\u0002g\u0003\u0003Aq!a\u0001\u0011\u0001\u0004\t)!A\u000bbI\u0012LG/[8oC2LeNZ8s[\u0006$\u0018n\u001c8\u0011\t\u0005\u001d\u0011Q\u0004\b\u0005\u0003\u0013\tIB\u0004\u0003\u0002\f\u0005]a\u0002BA\u0007\u0003+qA!a\u0004\u0002\u00149\u0019\u0011.!\u0005\n\u0003\rJ!!\t\u0012\n\u0005}\u0001\u0013BA\u000f\u001f\u0013\r\tY\u0002H\u0001\u0015)\u0006\u001c8.\u0012=fGV$\u0018n\u001c8EKR\f\u0017\u000e\\:\n\t\u0005}\u0011\u0011\u0005\u0002\u0016\u0003\u0012$\u0017\u000e^5p]\u0006d\u0017J\u001c4pe6\fG/[8o\u0015\r\tY\u0002H\u0001\tG>l\u0007\u000f\\3uKR)a-a\n\u0002:!9\u0011\u0011F\tA\u0002\u0005-\u0012A\u0002:fgVdG\u000f\u0005\u0003\u0002.\u0005Mb\u0002BA\u0005\u0003_I1!!\r\u001d\u0003\u0011!\u0016m]6\n\t\u0005U\u0012q\u0007\u0002\u0007%\u0016\u001cX\u000f\u001c;\u000b\u0007\u0005EB\u0004C\u0004\u0002\u0004E\u0001\r!a\u000f\u0011\t\u001dB\u0016QA\u0001\u0005M\u0006LG\u000eF\u0004g\u0003\u0003\n\u0019%!\u0017\t\u000f\u0005\r!\u00031\u0001\u0002<!9\u0011Q\t\nA\u0002\u0005\u001d\u0013\u0001D3se>\u0014X*Z:tC\u001e,\u0007\u0003B\u0014Y\u0003\u0013\u0002B!a\u0013\u0002T9!\u0011QJA(!\tI\u0007&C\u0002\u0002R!\na\u0001\u0015:fI\u00164\u0017\u0002BA+\u0003/\u0012aa\u0015;sS:<'bAA)Q!9\u00111\f\nA\u0002\u0005\u001d\u0013!C3yG\u0016\u0004H/[8o\u0003\u0019\u0019\u0017M\\2fYR\u0019a-!\u0019\t\u000f\u0005\r1\u00031\u0001\u0002<\u0005iA+Y:l\u0003\u001e<'/Z4bi\u0016\u0004\"aL\u000b\u0014\u0005U1CCAA3\u0003-1'o\\7ISN$xN]=\u0015\u000b}\ny'!\u001d\t\u000b1:\u0002\u0019\u0001\u0018\t\u000bM:\u0002\u0019A\u001b\u0002\r\r\u0014X-\u0019;f)\u001d1\u0017qOA=\u0003\u0003CQ\u0001\f\rA\u00029Ba!\b\rA\u0002\u0005m\u0004c\u0001=\u0002~%\u0019\u0011q\u0010\u000f\u0003\tQ\u000b7o\u001b\u0005\u0006mb\u0001\ra\u001e")
public class TaskAggregate {
    private final TaskAggregateId aggregateId;
    private final History history;
    private final TaskEvent initialEvent;
    private final DecisionProjection currentDecisionProjection;

    public static List<Event> create(TaskAggregateId aggregateId, Task task, Hostname hostname) {
        return TaskAggregate$.MODULE$.create(aggregateId, task, hostname);
    }

    public static TaskAggregate fromHistory(TaskAggregateId aggregateId, History history) {
        return TaskAggregate$.MODULE$.fromHistory(aggregateId, history);
    }

    public TaskAggregateId aggregateId() {
        return this.aggregateId;
    }

    private History history() {
        return this.history;
    }

    private TaskEvent initialEvent() {
        return this.initialEvent;
    }

    private TaskEvent initialEvent(Event event) {
        Created created;
        Event event2 = event;
        if (event2 instanceof Created && (created = (Created)event2).eventId().equals((Object)EventId$.MODULE$.first())) {
            return created;
        }
        if (event2 instanceof TaskEvent) {
            TaskEvent taskEvent = (TaskEvent)event2;
            if (taskEvent.eventId().equals((Object)EventId$.MODULE$.first())) {
                throw new IllegalArgumentException("History must start with Created event");
            }
            return taskEvent;
        }
        throw new MatchError((Object)event2);
    }

    private DecisionProjection currentDecisionProjection() {
        return this.currentDecisionProjection;
    }

    private Option<Event> createEventIfNotFinished(Function1<EventId, Event> event) {
        if (!this.currentDecisionProjection().status().isFinished()) {
            return new Some(event.apply((Object)this.history().getNextEventId()));
        }
        return None$.MODULE$;
    }

    private Option<Event> createEvent(Function1<EventId, Event> event) {
        return new Some(event.apply((Object)this.history().getNextEventId()));
    }

    private List<Event> createEventIfNotFinishedAsList(Function1<EventId, Event> event) {
        return this.createEventIfNotFinished(event).toList();
    }

    public List<Event> start(Hostname hostname) {
        return this.createEventIfNotFinished((Function1<EventId, Event>)(Function1 & Serializable)x$1 -> new Started(this.aggregateId(), (EventId)x$1, hostname)).toList();
    }

    public List<Event> requestCancel(Hostname hostname) {
        return this.createEventIfNotFinishedAsList((Function1<EventId, Event>)(Function1 & Serializable)x$2 -> new CancelRequested(this.aggregateId(), (EventId)x$2, hostname));
    }

    public List<Event> update(TaskExecutionDetails.AdditionalInformation additionalInformation) {
        TaskManager.Status status = this.currentDecisionProjection().status();
        return (TaskManager.Status.IN_PROGRESS.equals(status) && this.currentDecisionProjection().additionalInformationIsOlderThan(additionalInformation.timestamp()) ? this.createEvent((Function1<EventId, Event>)(Function1 & Serializable)x$3 -> new AdditionalInformationUpdated(this.aggregateId(), (EventId)x$3, additionalInformation)) : (TaskManager.Status.CANCEL_REQUESTED.equals(status) && this.currentDecisionProjection().additionalInformationIsOlderThan(additionalInformation.timestamp()) ? this.createEvent((Function1<EventId, Event>)(Function1 & Serializable)x$4 -> new AdditionalInformationUpdated(this.aggregateId(), (EventId)x$4, additionalInformation)) : None$.MODULE$)).toList();
    }

    public List<Event> complete(Task.Result result, Option<TaskExecutionDetails.AdditionalInformation> additionalInformation) {
        return this.createEventIfNotFinishedAsList((Function1<EventId, Event>)(Function1 & Serializable)x$5 -> new Completed(this.aggregateId(), (EventId)x$5, result, additionalInformation));
    }

    public List<Event> fail(Option<TaskExecutionDetails.AdditionalInformation> additionalInformation, Option<String> errorMessage, Option<String> exception) {
        return this.createEventIfNotFinishedAsList((Function1<EventId, Event>)(Function1 & Serializable)x$6 -> new Failed(this.aggregateId(), (EventId)x$6, additionalInformation, errorMessage, exception));
    }

    public List<Event> cancel(Option<TaskExecutionDetails.AdditionalInformation> additionalInformation) {
        return this.createEventIfNotFinishedAsList((Function1<EventId, Event>)(Function1 & Serializable)x$7 -> new Cancelled(this.aggregateId(), (EventId)x$7, additionalInformation));
    }

    public TaskAggregate(TaskAggregateId aggregateId, History history) {
        this.aggregateId = aggregateId;
        this.history = history;
        this.initialEvent = (TaskEvent)((Try)history.getEvents().headOption().map((Function1 & Serializable)e -> new Success((Object)this.initialEvent((Event)e))).getOrElse((Function0 & Serializable)() -> new Failure((Throwable)new IllegalArgumentException("History must start with Created event")))).get();
        this.currentDecisionProjection = (DecisionProjection)((LinearSeqOps)history.getEvents().tail()).foldLeft((Object)DecisionProjection$.MODULE$.initial(this.initialEvent()), (Function2 & Serializable)(decision, event) -> decision.update((Event)event));
    }
}

