/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.dnsservice.library.inetnetwork.model;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.james.dnsservice.library.inetnetwork.InetNetworkBuilder;
import org.apache.james.dnsservice.library.inetnetwork.model.InetNetwork;

public class Inet6Network
implements InetNetwork {
    private final InetAddress network;
    private final Integer netmask;

    public Inet6Network(InetAddress ip, Integer netmask) {
        this.network = Inet6Network.maskIP(ip, netmask);
        this.netmask = netmask;
    }

    @Override
    public boolean contains(InetAddress ip) {
        if (!InetNetworkBuilder.isV6(ip.getHostAddress())) {
            return false;
        }
        try {
            return this.network.equals(Inet6Network.maskIP(ip, this.netmask));
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public String toString() {
        return this.network.getHostAddress() + "/" + this.netmask;
    }

    public int hashCode() {
        return Inet6Network.maskIP(this.network, this.netmask).hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof InetNetwork && ((Inet6Network)obj).network.equals(this.network) && ((Inet6Network)obj).netmask.equals(this.netmask);
    }

    private static InetAddress maskIP(InetAddress ip, Integer mask) {
        byte[] maskBytes = new byte[16];
        int i = 0;
        while (mask > 0) {
            maskBytes[i] = -1;
            ++i;
            mask = mask >> 1;
        }
        return Inet6Network.maskIP(ip.getAddress(), maskBytes);
    }

    private static InetAddress maskIP(byte[] ip, byte[] mask) {
        if (ip.length != mask.length) {
            throw new IllegalArgumentException("IP address and mask must be of the same length.");
        }
        if (ip.length != 16) {
            throw new IllegalArgumentException("IP address and mask length must be equal to 16.");
        }
        try {
            byte[] maskedIp = new byte[ip.length];
            for (int i = 0; i < ip.length; ++i) {
                maskedIp[i] = (byte)(ip[i] & mask[i]);
            }
            return Inet6Network.getByAddress(maskedIp);
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    private static InetAddress getByAddress(byte[] ip) throws UnknownHostException {
        InetAddress addr = Inet6Address.getByAddress(ip);
        if (addr == null) {
            addr = InetAddress.getByName(Integer.toString(ip[0] & 0xFF, 10) + ":" + Integer.toString(ip[1] & 0xFF, 10) + ":" + Integer.toString(ip[2] & 0xFF, 10) + ":" + Integer.toString(ip[3] & 0xFF, 10) + ":" + Integer.toString(ip[4] & 0xFF, 10) + ":" + Integer.toString(ip[5] & 0xFF, 10) + ":" + Integer.toString(ip[6] & 0xFF, 10) + ":" + Integer.toString(ip[7] & 0xFF, 10) + ":" + Integer.toString(ip[8] & 0xFF, 10) + ":" + Integer.toString(ip[9] & 0xFF, 10) + ":" + Integer.toString(ip[10] & 0xFF, 10) + ":" + Integer.toString(ip[11] & 0xFF, 10) + ":" + Integer.toString(ip[12] & 0xFF, 10) + ":" + Integer.toString(ip[13] & 0xFF, 10) + ":" + Integer.toString(ip[14] & 0xFF, 10) + ":" + Integer.toString(ip[15] & 0xFF, 10));
        }
        return addr;
    }
}

