/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp.core;

import com.google.common.collect.ImmutableSet;
import jakarta.inject.Inject;
import java.util.Collection;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.metrics.api.TimeMetric;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.api.Request;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.smtp.SMTPResponse;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.core.AbstractHookableCmdHandler;
import org.apache.james.protocols.smtp.dsn.DSNStatus;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.UnknownHook;

public class UnknownCmdHandler
extends AbstractHookableCmdHandler<UnknownHook> {
    private static final Collection<String> COMMANDS = ImmutableSet.of((Object)"UNKNOWN_CMD");
    private static final String MISSING_CURR_COMMAND = "";
    public static final ProtocolSession.AttachmentKey<String> CURR_COMMAND = ProtocolSession.AttachmentKey.of((String)"CURR_COMMAND", String.class);

    @Inject
    public UnknownCmdHandler(MetricFactory metricFactory) {
        super(metricFactory);
    }

    public Collection<String> getImplCommands() {
        return COMMANDS;
    }

    @Override
    protected Response doCoreCmd(SMTPSession session, String command, String parameters) {
        StringBuilder result = new StringBuilder();
        result.append(DSNStatus.getStatus(5, "5.1")).append(" Command ").append(command).append(" unrecognized.");
        return new SMTPResponse("500", result);
    }

    @Override
    protected Response doFilterChecks(SMTPSession session, String command, String parameters) {
        session.setAttachment(CURR_COMMAND, command, ProtocolSession.State.Transaction);
        return null;
    }

    @Override
    protected HookResult callHook(UnknownHook rawHook, SMTPSession session, String parameters) {
        return rawHook.doUnknown(session, session.getAttachment(CURR_COMMAND, ProtocolSession.State.Transaction).orElse(MISSING_CURR_COMMAND));
    }

    @Override
    protected Class<UnknownHook> getHookInterface() {
        return UnknownHook.class;
    }

    @Override
    protected TimeMetric timer(Request request) {
        return this.metricFactory.timer("SMTP-unknown");
    }
}

