/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.tools;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import org.apache.iotdb.commons.file.SystemFileFactory;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.utils.DateTimeUtils;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.fileSystem.FSFactoryProducer;

public class IoTDBDataDirViewer {
    public static void main(String[] args) throws IOException {
        String[] data_dir;
        String outFile = "IoTDB_data_dir_overview.txt";
        if (args.length == 0) {
            String path = "data/datanode/data";
            data_dir = path.split(",");
        } else if (args.length == 1) {
            data_dir = args[0].split(",");
        } else if (args.length == 2) {
            data_dir = args[0].split(",");
            outFile = args[1];
        } else {
            throw new IOException("Invalid parameters. Please check the user guide.");
        }
        System.out.println("output save path:" + outFile);
        System.out.println("data dir num:" + data_dir.length);
        try (PrintWriter pw = new PrintWriter(new FileWriter(outFile));){
            for (String dir : data_dir) {
                File dirFile = FSFactoryProducer.getFSFactory().getFile(dir);
                File[] seqAndUnseqDirs = dirFile.listFiles();
                if (seqAndUnseqDirs == null) {
                    throw new IOException("Irregular data dir structure.There should be a sequence and unsequence directory under the data directory " + dirFile.getName());
                }
                List<File> fileList = Arrays.asList(seqAndUnseqDirs);
                fileList.sort(Comparator.comparing(File::getName));
                if (!"sequence".equals(seqAndUnseqDirs[1].getName()) || !"unsequence".equals(seqAndUnseqDirs[2].getName())) {
                    throw new IOException("Irregular data dir structure.There should be a sequence and unsequence directory under the data directory " + dirFile.getPath());
                }
                IoTDBDataDirViewer.printlnBoth(pw, "|==============================================================");
                IoTDBDataDirViewer.printlnBoth(pw, "|" + dir);
                IoTDBDataDirViewer.printlnBoth(pw, "|--sequence");
                IoTDBDataDirViewer.printFilesInSeqOrUnseqDir(seqAndUnseqDirs[1], pw);
                IoTDBDataDirViewer.printlnBoth(pw, "|--unsequence");
                IoTDBDataDirViewer.printFilesInSeqOrUnseqDir(seqAndUnseqDirs[2], pw);
            }
            IoTDBDataDirViewer.printlnBoth(pw, "|==============================================================");
        }
    }

    private static void printFilesInSeqOrUnseqDir(File seqOrUnseqDir, PrintWriter pw) throws IOException {
        File[] storageGroupDirs = seqOrUnseqDir.listFiles();
        if (storageGroupDirs == null) {
            throw new IOException("Irregular data dir structure.There should be database directories under the sequence/unsequence directory " + seqOrUnseqDir.getName());
        }
        List<File> fileList = Arrays.asList(storageGroupDirs);
        fileList.sort(Comparator.comparing(File::getName));
        for (File storageGroup : storageGroupDirs) {
            IoTDBDataDirViewer.printlnBoth(pw, "|  |--" + storageGroup.getName());
            IoTDBDataDirViewer.printFilesInStorageGroupDir(storageGroup, pw);
        }
    }

    private static void printFilesInStorageGroupDir(File storageGroup, PrintWriter pw) throws IOException {
        File[] files = storageGroup.listFiles();
        if (files == null) {
            throw new IOException("Irregular data dir structure.There should be dataRegion directories under the database directory " + storageGroup.getName());
        }
        List<File> fileList = Arrays.asList(files);
        fileList.sort(Comparator.comparing(File::getName));
        for (File file : fileList) {
            IoTDBDataDirViewer.printlnBoth(pw, "|  |  |--" + file.getName());
            IoTDBDataDirViewer.printFilesInDataRegionDir(file, pw);
        }
    }

    private static void printFilesInDataRegionDir(File dataRegion, PrintWriter pw) throws IOException {
        File[] files = dataRegion.listFiles();
        if (files == null) {
            throw new IOException("Irregular data dir structure.There should be timeInterval directories under the database directory " + dataRegion.getName());
        }
        List<File> fileList = Arrays.asList(files);
        fileList.sort(Comparator.comparing(File::getName));
        for (File file : fileList) {
            IoTDBDataDirViewer.printlnBoth(pw, "|  |  |  |--" + file.getName());
            IoTDBDataDirViewer.printFilesInTimeInterval(file, pw);
        }
    }

    private static void printFilesInTimeInterval(File timeInterval, PrintWriter pw) throws IOException {
        File[] files = timeInterval.listFiles();
        if (files == null) {
            throw new IOException("Irregular data dir structure.There should be tsfiles under the timeInterval directories directory " + timeInterval.getName());
        }
        List<File> fileList = Arrays.asList(files);
        fileList.sort(Comparator.comparing(File::getName));
        for (File file : fileList) {
            IoTDBDataDirViewer.printlnBoth(pw, "|  |  |  |  |--" + file.getName());
            if (!file.getName().endsWith(".tsfile.resource")) continue;
            IoTDBDataDirViewer.printResource(file.getAbsolutePath(), pw);
        }
    }

    private static void printResource(String filename, PrintWriter pw) throws IOException {
        filename = filename.substring(0, filename.length() - 9);
        TsFileResource resource = new TsFileResource(SystemFileFactory.INSTANCE.getFile(filename));
        resource.deserialize();
        TreeSet<IDeviceID> keys = new TreeSet<IDeviceID>(resource.getDevices());
        for (IDeviceID device : keys) {
            IoTDBDataDirViewer.printlnBoth(pw, String.format("|  |  |  |  |  |--device %s, start time %d (%s), end time %d (%s)", device, resource.getStartTime(device), DateTimeUtils.convertLongToDate(resource.getStartTime(device).get()), resource.getEndTime(device), DateTimeUtils.convertLongToDate(resource.getEndTime(device).get())));
        }
    }

    private static void printlnBoth(PrintWriter pw, String str) {
        System.out.println(str);
        pw.println(str);
    }
}

