/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.persistence;

import io.moquette.broker.ISessionsRepository;
import io.netty.handler.codec.mqtt.MqttQoS;
import io.netty.handler.codec.mqtt.MqttVersion;
import java.nio.ByteBuffer;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.h2.mvstore.WriteBuffer;
import org.h2.mvstore.type.BasicDataType;
import org.h2.mvstore.type.ByteArrayDataType;
import org.h2.mvstore.type.DataType;
import org.h2.mvstore.type.StringDataType;

class H2SessionsRepository
implements ISessionsRepository {
    private static final byte SESSION_DATA_SERDES_V1 = 1;
    private static final byte SESSION_DATA_SERDES_V2 = 2;
    private static final long UNDEFINED_INSTANT = -1L;
    public static final byte WILL_PRESENT = 1;
    public static final byte WILL_NOT_PRESENT = 0;
    private final MVMap<String, ISessionsRepository.SessionData> sessionMap;
    private final MVMap<String, ISessionsRepository.Will> willMap;
    private final Clock clock;

    public H2SessionsRepository(MVStore mvStore, Clock clock) {
        this.clock = clock;
        MVMap.Builder sessionTypeBuilder = new MVMap.Builder().valueType((DataType)new SessionDataValueType());
        this.sessionMap = mvStore.openMap("sessions_store", (MVMap.MapBuilder)sessionTypeBuilder);
        MVMap.Builder willTypeBuilder = new MVMap.Builder().valueType((DataType)new WillDataValueType());
        this.willMap = mvStore.openMap("will_specs_store", (MVMap.MapBuilder)willTypeBuilder);
    }

    @Override
    public Collection<ISessionsRepository.SessionData> list() {
        return this.sessionMap.values();
    }

    @Override
    public void saveSession(ISessionsRepository.SessionData session) {
        this.sessionMap.put((Object)session.clientId(), (Object)session);
    }

    @Override
    public void delete(ISessionsRepository.SessionData session) {
        this.sessionMap.remove((Object)session.clientId());
    }

    @Override
    public void listSessionsWill(BiConsumer<String, ISessionsRepository.Will> visitor) {
        this.willMap.entrySet().stream().forEach(e -> visitor.accept((String)e.getKey(), (ISessionsRepository.Will)e.getValue()));
    }

    @Override
    public void saveWill(String clientId, ISessionsRepository.Will will) {
        this.willMap.put((Object)clientId, (Object)will);
    }

    @Override
    public void deleteWill(String clientId) {
        this.willMap.remove((Object)clientId);
    }

    private MqttVersion readMQTTVersion(byte rawVersion) {
        MqttVersion version;
        switch (rawVersion) {
            case 3: {
                version = MqttVersion.MQTT_3_1;
                break;
            }
            case 4: {
                version = MqttVersion.MQTT_3_1_1;
                break;
            }
            case 5: {
                version = MqttVersion.MQTT_5;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized MQTT version value " + rawVersion);
            }
        }
        return version;
    }

    private static final class UserPropertiesDataValueType
    extends BasicDataType<Map<String, String>> {
        private UserPropertiesDataValueType() {
        }

        public int getMemory(Map<String, String> userProps) {
            int kvSize = userProps.entrySet().stream().map(kv -> StringDataType.INSTANCE.getMemory((String)kv.getKey()) + StringDataType.INSTANCE.getMemory((String)kv.getValue())).mapToInt(Integer::intValue).sum();
            return 4 + kvSize;
        }

        public void write(WriteBuffer writeBuffer, Map<String, String> userProps) {
            writeBuffer.putInt(userProps.size());
            for (Map.Entry<String, String> kv : userProps.entrySet()) {
                StringDataType.INSTANCE.write(writeBuffer, kv.getKey());
                StringDataType.INSTANCE.write(writeBuffer, kv.getValue());
            }
        }

        public Map<String, String> read(ByteBuffer byteBuffer) {
            int length = byteBuffer.getInt();
            HashMap<String, String> result = new HashMap<String, String>(length);
            for (int i = 0; i < length; ++i) {
                String key = StringDataType.INSTANCE.read(byteBuffer);
                String value = StringDataType.INSTANCE.read(byteBuffer);
                result.put(key, value);
            }
            return result;
        }

        public Map<String, String>[] createStorage(int i) {
            return new Map[i];
        }
    }

    private static final class DurationDataValueType
    extends BasicDataType<Duration> {
        private DurationDataValueType() {
        }

        public int getMemory(Duration duration) {
            return 4;
        }

        public void write(WriteBuffer writeBuffer, Duration duration) {
            int seconds = (int)duration.get(ChronoUnit.SECONDS);
            writeBuffer.putInt(seconds);
        }

        public Duration read(ByteBuffer byteBuffer) {
            return Duration.ofSeconds(byteBuffer.getInt());
        }

        public Duration[] createStorage(int i) {
            return new Duration[i];
        }
    }

    private static final class WillOptionsDataValueType
    extends BasicDataType<ISessionsRepository.WillOptions> {
        private static final byte EMPTY_OPTIONS = -1;
        private static final byte MESSAGE_EXPIRY_FLAG = 1;
        private static final byte CONTENT_TYPE_FLAG = 2;
        private static final byte RESPONSE_TOPIC_FLAG = 4;
        private static final byte CORRELATION_DATA_FLAG = 8;
        private static final byte USER_PROPERTIES_FLAG = 16;
        private final DurationDataValueType durationDataValueType = new DurationDataValueType();
        private final StringDataType stringDataType = StringDataType.INSTANCE;
        private final ByteArrayDataType byteArrayDataType = ByteArrayDataType.INSTANCE;
        private final UserPropertiesDataValueType userPropertiesDataValueType = new UserPropertiesDataValueType();

        private WillOptionsDataValueType() {
        }

        public int getMemory(ISessionsRepository.WillOptions willOptions) {
            int size = 1;
            if (willOptions.messageExpiry().isPresent()) {
                size += this.durationDataValueType.getMemory(willOptions.messageExpiry().get());
            }
            if (willOptions.contentType().isPresent()) {
                size += this.stringDataType.getMemory(willOptions.contentType().get());
            }
            if (willOptions.responseTopic().isPresent()) {
                size += this.stringDataType.getMemory(willOptions.responseTopic().get());
            }
            if (willOptions.correlationData().isPresent()) {
                size += this.byteArrayDataType.getMemory(willOptions.correlationData().get());
            }
            if (willOptions.userProperties().isPresent()) {
                size += this.userPropertiesDataValueType.getMemory(willOptions.userProperties().get());
            }
            return size;
        }

        public void write(WriteBuffer writeBuffer, ISessionsRepository.WillOptions willOptions) {
            if (willOptions == null || !willOptions.notEmpty()) {
                writeBuffer.put((byte)-1);
                return;
            }
            byte optionBitmask = 0;
            if (willOptions.messageExpiry().isPresent()) {
                optionBitmask = (byte)(optionBitmask | 1);
            }
            if (willOptions.contentType().isPresent()) {
                optionBitmask = (byte)(optionBitmask | 2);
            }
            if (willOptions.responseTopic().isPresent()) {
                optionBitmask = (byte)(optionBitmask | 4);
            }
            if (willOptions.correlationData().isPresent()) {
                optionBitmask = (byte)(optionBitmask | 8);
            }
            if (willOptions.userProperties().isPresent()) {
                optionBitmask = (byte)(optionBitmask | 0x10);
            }
            writeBuffer.put(optionBitmask);
            willOptions.messageExpiry().ifPresent(expiry -> this.durationDataValueType.write(writeBuffer, (Duration)expiry));
            willOptions.contentType().ifPresent(contentType -> this.stringDataType.write(writeBuffer, contentType));
            willOptions.responseTopic().ifPresent(responseTopic -> this.stringDataType.write(writeBuffer, responseTopic));
            willOptions.correlationData().ifPresent(correlationData -> this.byteArrayDataType.write(writeBuffer, correlationData));
            willOptions.userProperties().ifPresent(userProps -> this.userPropertiesDataValueType.write(writeBuffer, (Map<String, String>)userProps));
        }

        public ISessionsRepository.WillOptions read(ByteBuffer byteBuffer) {
            byte header = byteBuffer.get();
            ISessionsRepository.WillOptions options = ISessionsRepository.WillOptions.empty();
            if (header == -1) {
                return options;
            }
            if ((header & 1) > 0) {
                options = options.withMessageExpiry(this.durationDataValueType.read(byteBuffer));
            }
            if ((header & 2) > 0) {
                options = options.withContentType(this.stringDataType.read(byteBuffer));
            }
            if ((header & 4) > 0) {
                options = options.withResponseTopic(this.stringDataType.read(byteBuffer));
            }
            if ((header & 8) > 0) {
                options = options.withCorrelationData(this.byteArrayDataType.read(byteBuffer));
            }
            if ((header & 0x10) > 0) {
                options = options.withUserProperties((Map<String, String>)this.userPropertiesDataValueType.read(byteBuffer));
            }
            return options;
        }

        public ISessionsRepository.WillOptions[] createStorage(int i) {
            return new ISessionsRepository.WillOptions[i];
        }
    }

    private final class WillDataValueType
    extends BasicDataType<ISessionsRepository.Will> {
        private final StringDataType stringDataType = new StringDataType();
        private final WillOptionsDataValueType willOptionsDataType = new WillOptionsDataValueType();

        private WillDataValueType() {
        }

        public int getMemory(ISessionsRepository.Will will) {
            return this.stringDataType.getMemory(will.topic) + 4 + will.payload.length + 1;
        }

        public void write(WriteBuffer buff, ISessionsRepository.Will will) {
            this.stringDataType.write(buff, will.topic);
            buff.putInt(will.payload.length);
            buff.put(will.payload);
            int retained = will.retained ? 16 : 0;
            byte qos = (byte)(will.qos.value() & 0xF);
            buff.put((byte)(retained & qos));
            buff.putInt(will.delayInterval);
            buff.putLong(will.expireAt().map(Instant::toEpochMilli).orElse(-1L).longValue());
            if (will.properties.notEmpty()) {
                this.willOptionsDataType.write(buff, will.properties);
            }
        }

        public ISessionsRepository.Will read(ByteBuffer buff) {
            ISessionsRepository.WillOptions options;
            String topic = this.stringDataType.read(buff);
            int payloadLength = buff.getInt();
            byte[] payload = new byte[payloadLength];
            buff.get(payload);
            byte rawFlags = buff.get();
            byte qos = (byte)(rawFlags & 0xF);
            boolean retained = (rawFlags >> 4 & 0xF) > 0;
            int willDelayInterval = buff.getInt();
            ISessionsRepository.Will will = new ISessionsRepository.Will(topic, payload, MqttQoS.valueOf((int)qos), retained, willDelayInterval);
            long expiresAt = buff.getLong();
            if (expiresAt != -1L) {
                will = new ISessionsRepository.Will(will, Instant.ofEpochMilli(expiresAt));
            }
            if ((options = this.willOptionsDataType.read(buff)) != null && options.notEmpty()) {
                will = new ISessionsRepository.Will(will, options);
            }
            return will;
        }

        public ISessionsRepository.Will[] createStorage(int i) {
            return new ISessionsRepository.Will[i];
        }
    }

    private final class SessionDataValueType
    extends BasicDataType<ISessionsRepository.SessionData> {
        private final StringDataType stringDataType = new StringDataType();
        private final WillDataValueType willDataType = new WillDataValueType();

        private SessionDataValueType() {
        }

        public int getMemory(ISessionsRepository.SessionData obj) {
            int length = this.stringDataType.getMemory(obj.clientId()) + 8 + 1 + 4 + 1;
            if (obj.hasWill()) {
                return length + this.willDataType.getMemory(obj.will());
            }
            return length;
        }

        public void write(WriteBuffer buff, ISessionsRepository.SessionData obj) {
            buff.put((byte)2);
            this.stringDataType.write(buff, obj.clientId());
            buff.putLong(obj.expiryInstant().orElse(-1L).longValue());
            buff.put(obj.protocolVersion().protocolLevel());
            buff.putInt(obj.expiryInterval());
            if (obj.hasWill()) {
                buff.put((byte)1);
                this.willDataType.write(buff, obj.will());
            } else {
                buff.put((byte)0);
            }
        }

        public ISessionsRepository.SessionData read(ByteBuffer buff) {
            byte serDesVersion = buff.get();
            if (serDesVersion != 1 && serDesVersion != 2) {
                throw new IllegalArgumentException("Unrecognized serialization version " + serDesVersion);
            }
            String clientId = this.stringDataType.read(buff);
            long expiresAt = buff.getLong();
            MqttVersion version = H2SessionsRepository.this.readMQTTVersion(buff.get());
            int expiryInterval = buff.getInt();
            ISessionsRepository.Will will = null;
            if (serDesVersion == 2 && buff.get() == 1) {
                will = this.willDataType.read(buff);
            }
            if (expiresAt == -1L) {
                if (will != null) {
                    return new ISessionsRepository.SessionData(clientId, version, will, expiryInterval, H2SessionsRepository.this.clock);
                }
                return new ISessionsRepository.SessionData(clientId, version, expiryInterval, H2SessionsRepository.this.clock);
            }
            if (will != null) {
                return new ISessionsRepository.SessionData(clientId, Instant.ofEpochMilli(expiresAt), version, will, expiryInterval, H2SessionsRepository.this.clock);
            }
            return new ISessionsRepository.SessionData(clientId, Instant.ofEpochMilli(expiresAt), version, expiryInterval, H2SessionsRepository.this.clock);
        }

        public ISessionsRepository.SessionData[] createStorage(int i) {
            return new ISessionsRepository.SessionData[i];
        }
    }
}

