/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tool.data;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.iotdb.cli.utils.IoTPrinter;
import org.apache.iotdb.isession.ITableSession;
import org.apache.iotdb.isession.SessionDataSet;
import org.apache.iotdb.isession.pool.ITableSessionPool;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.session.pool.TableSessionPoolBuilder;
import org.apache.iotdb.tool.data.AbstractImportData;
import org.apache.iotdb.tool.data.ImportDataScanTool;
import org.apache.iotdb.tool.tsfile.ImportTsFileScanTool;
import org.apache.tsfile.enums.ColumnCategory;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.RowRecord;
import org.apache.tsfile.write.record.Tablet;
import org.apache.tsfile.write.schema.MeasurementSchema;

public class ImportDataTable
extends AbstractImportData {
    private static final IoTPrinter ioTPrinter = new IoTPrinter(System.out);
    private static ITableSessionPool sessionPool;
    private static Map<String, TSDataType> dataTypes;
    private static Map<String, ColumnCategory> columnCategory;

    @Override
    public void init() throws InterruptedException {
        sessionPool = new TableSessionPoolBuilder().nodeUrls(Collections.singletonList(host + ":" + port)).user(username).password(password).maxSize(threadNum + 1).enableCompression(false).enableRedirection(false).enableAutoFetch(false).database(database).build();
        File file = new File(targetPath);
        if (!file.isFile() && !file.isDirectory()) {
            ioTPrinter.println(String.format("Source file or directory %s does not exist", targetPath));
            System.exit(1);
        }
        SessionDataSet sessionDataSet = null;
        try (ITableSession session = sessionPool.getSession();){
            ArrayList<String> databases = new ArrayList<String>();
            sessionDataSet = session.executeQueryStatement("show databases");
            while (sessionDataSet.hasNext()) {
                RowRecord rowRecord = sessionDataSet.next();
                databases.add(rowRecord.getField(0).getStringValue());
            }
            if (!databases.contains(database)) {
                ioTPrinter.println(String.format("The target database %s does not exist", database));
                System.exit(1);
            }
            if ("csv".equals(fileType)) {
                if (StringUtils.isNotBlank((CharSequence)table)) {
                    RowRecord rowRecord;
                    sessionDataSet = session.executeQueryStatement("show tables");
                    ArrayList<String> tables = new ArrayList<String>();
                    while (sessionDataSet.hasNext()) {
                        rowRecord = sessionDataSet.next();
                        tables.add(rowRecord.getField(0).getStringValue());
                    }
                    if (!tables.contains(table)) {
                        ioTPrinter.println(String.format("There are no tables or the target table %s does not exist", table));
                        System.exit(1);
                    }
                    sessionDataSet = session.executeQueryStatement("describe " + table);
                    while (sessionDataSet.hasNext()) {
                        rowRecord = sessionDataSet.next();
                        String columnName = rowRecord.getField(0).getStringValue();
                        String category = rowRecord.getField(2).getStringValue();
                        if (timeColumn.equalsIgnoreCase(category)) continue;
                        dataTypes.put(columnName, ImportDataTable.getType(rowRecord.getField(1).getStringValue()));
                        columnCategory.put(columnName, ImportDataTable.getColumnCategory(category));
                    }
                } else {
                    ioTPrinter.println(String.format("There are no tables or the target table %s does not exist", null));
                    System.exit(1);
                }
            }
        }
        catch (StatementExecutionException e) {
            ioTPrinter.println("Meet error when insert csv because " + e.getMessage());
            System.exit(1);
        }
        catch (IoTDBConnectionException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (ObjectUtils.isNotEmpty((Object)sessionDataSet)) {
                try {
                    sessionDataSet.close();
                }
                catch (Exception e) {}
            }
        }
        if ("tsfile".equalsIgnoreCase(fileType)) {
            ImportTsFileScanTool.setSourceFullPath(targetPath);
            ImportTsFileScanTool.traverseAndCollectFiles();
            ImportTsFileScanTool.addNoResourceOrModsToQueue();
        } else {
            ImportDataScanTool.setSourceFullPath(targetPath);
            ImportDataScanTool.traverseAndCollectFiles();
        }
    }

    @Override
    protected Runnable getAsyncImportRunnable() {
        return new ImportDataTable();
    }

    protected static void processSuccessFile() {
        loadFileSuccessfulNum.increment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void importFromSqlFile(File file) {
        Object sql;
        ArrayList<List<String>> failedRecords = new ArrayList<List<String>>();
        String failedFilePath = failedFileDirectory == null ? file.getAbsolutePath() + ".failed" : failedFileDirectory + file.getName() + ".failed";
        try (BufferedReader br = new BufferedReader(new FileReader(file.getAbsolutePath()));){
            while ((sql = br.readLine()) != null) {
                try {
                    ITableSession iTableSession = sessionPool.getSession();
                    try {
                        sql = ((String)sql).replace(";", "");
                        iTableSession.executeNonQueryStatement((String)sql);
                    }
                    finally {
                        if (iTableSession == null) continue;
                        iTableSession.close();
                    }
                }
                catch (IoTDBConnectionException | StatementExecutionException throwable) {
                    ioTPrinter.println(throwable.getMessage());
                    failedRecords.add(Collections.singletonList(sql));
                }
            }
            ImportDataTable.processSuccessFile();
        }
        catch (IOException e) {
            ioTPrinter.println("SQL file read exception because: " + e.getMessage());
        }
        if (failedRecords.isEmpty()) return;
        FileWriter writer = null;
        try {
            writer = new FileWriter(failedFilePath);
            sql = failedRecords.iterator();
            while (sql.hasNext()) {
                List list = (List)sql.next();
                writer.write(list.get(0).toString() + "\n");
            }
            return;
        }
        catch (IOException e) {
            ioTPrinter.println("Cannot dump fail result because: " + e.getMessage());
            return;
        }
        finally {
            if (ObjectUtils.isNotEmpty((Object)writer)) {
                try {
                    writer.flush();
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    protected void importFromTsFile(File file) {
        String sql = "load '" + file + "'";
        try (ITableSession session = sessionPool.getSession();){
            session.executeNonQueryStatement(sql);
            this.processSuccessFile(file.getPath());
        }
        catch (Exception e) {
            this.processFailFile(file.getPath(), e);
        }
    }

    @Override
    protected void importFromCsvFile(File file) {
        if (file.getName().endsWith("csv") || file.getName().endsWith("txt")) {
            try {
                CSVParser csvRecords = ImportDataTable.readCsvFile(file.getAbsolutePath());
                List headerNames = csvRecords.getHeaderNames();
                Stream records = csvRecords.stream();
                if (headerNames.isEmpty()) {
                    ioTPrinter.println("Empty file!");
                    return;
                }
                if (!timeColumn.toLowerCase().equalsIgnoreCase(ImportDataTable.filterBomHeader((String)headerNames.get(0)))) {
                    ioTPrinter.println("The first field of header must be `time`!");
                    return;
                }
                String failedFilePath = failedFileDirectory == null ? file.getAbsolutePath() + ".failed" : failedFileDirectory + file.getName() + ".failed";
                this.writeData(headerNames, records.collect(Collectors.toList()), failedFilePath);
                ImportDataTable.processSuccessFile();
            }
            catch (IOException e) {
                ioTPrinter.println("CSV file read exception because: " + e.getMessage());
            }
        } else {
            ioTPrinter.println("The file name must end with \"csv\" or \"txt\"!");
        }
    }

    protected void writeData(List<String> headerNames, List<CSVRecord> records, String failedFilePath) {
        HashMap<String, TSDataType> headerTypeMap = new HashMap<String, TSDataType>();
        HashMap<String, String> headerNameMap = new HashMap<String, String>();
        this.parseHeaders(headerNames, headerTypeMap, headerNameMap);
        this.queryType(headerTypeMap);
        ArrayList<List<Object>> failedRecords = new ArrayList<List<Object>>();
        ArrayList schemas = new ArrayList();
        headerNames.forEach(t -> {
            if (dataTypes.containsKey(t)) {
                schemas.add(new MeasurementSchema(t, dataTypes.get(t)));
            }
        });
        LinkedList<String> headNames = new LinkedList<String>(dataTypes.keySet());
        LinkedList<TSDataType> columnTypes = new LinkedList<TSDataType>(dataTypes.values());
        LinkedList<ColumnCategory> columnCategorys = new LinkedList<ColumnCategory>(columnCategory.values());
        Tablet tablet = new Tablet(table, headNames, columnTypes, columnCategorys, batchPointSize);
        for (CSVRecord recordObj : records) {
            boolean isFail = false;
            int rowSize = tablet.getRowSize();
            long rowTimeStamp = ImportDataTable.parseTimestamp(recordObj.get(0));
            for (String headerName : headerNameMap.keySet()) {
                TSDataType type;
                String value = recordObj.get((String)headerNameMap.get(headerName));
                if ("".equals(value)) continue;
                if (timeColumn.equalsIgnoreCase(headerName)) {
                    tablet.addTimestamp(rowSize, rowTimeStamp);
                    continue;
                }
                if (!headerTypeMap.containsKey(headerName)) {
                    type = ImportDataTable.typeInfer(value);
                    if (type != null) {
                        headerTypeMap.put(headerName, type);
                        int newIndex = headerNames.indexOf(headerName);
                        if (newIndex >= columnTypes.size()) {
                            headNames.add(headerName);
                            columnTypes.add(type);
                            columnCategorys.add(ColumnCategory.FIELD);
                        } else {
                            headNames.add(headerName);
                            columnTypes.add(newIndex, type);
                            columnCategorys.add(newIndex, ColumnCategory.FIELD);
                        }
                        ImportDataTable.writeAndEmptyDataSet(tablet, 3);
                        tablet = new Tablet(table, headNames, columnTypes, columnCategorys, batchPointSize);
                        tablet.addTimestamp(rowSize, rowTimeStamp);
                    } else {
                        ioTPrinter.printf("Line '%s', column '%s': '%s' unknown type%n", recordObj.getRecordNumber(), headerName, value);
                        isFail = true;
                    }
                }
                if ((type = (TSDataType)headerTypeMap.get(headerName)) == null) continue;
                Object valueTrans = ImportDataTable.typeTrans(value, type);
                if (valueTrans == null) {
                    isFail = true;
                    ioTPrinter.printf("Line '%s', column '%s': '%s' can't convert to '%s'%n", recordObj.getRecordNumber(), headerName, value, type);
                    continue;
                }
                tablet.addValue(headerName, rowSize, valueTrans);
            }
            if (tablet.getRowSize() >= batchPointSize) {
                ImportDataTable.writeAndEmptyDataSet(tablet, 3);
                tablet.reset();
            }
            if (!isFail) continue;
            failedRecords.add(recordObj.stream().collect(Collectors.toList()));
        }
        if (tablet.getRowSize() > 0) {
            ImportDataTable.writeAndEmptyDataSet(tablet, 3);
        }
        if (!failedRecords.isEmpty()) {
            ImportDataTable.writeFailedLinesFile(headerNames, failedFilePath, failedRecords);
        }
    }

    private static void writeAndEmptyDataSet(Tablet tablet, int retryTime) {
        try (ITableSession session = sessionPool.getSession();){
            session.insert(tablet);
        }
        catch (IoTDBConnectionException e) {
            if (retryTime > 0) {
                ImportDataTable.writeAndEmptyDataSet(tablet, --retryTime);
            }
        }
        catch (StatementExecutionException e) {
            ioTPrinter.println("Meet error when insert csv because " + e.getMessage());
            System.exit(1);
        }
    }

    private void parseHeaders(List<String> headerNames, Map<String, TSDataType> headerTypeMap, Map<String, String> headerNameMap) {
        String regex = "(?<=\\()\\S+(?=\\))";
        Pattern pattern = Pattern.compile(regex);
        for (String headerName : headerNames) {
            Matcher matcher = pattern.matcher(headerName = headerName.toLowerCase());
            if (matcher.find()) {
                String type = matcher.group();
                String headerNameWithoutType = headerName.replace("(" + type + ")", "").replaceAll("\\s+", "");
                headerNameMap.put(headerNameWithoutType, headerName);
                headerTypeMap.put(headerNameWithoutType, ImportDataTable.getType(type));
                continue;
            }
            headerNameMap.put(headerName, headerName);
        }
    }

    private void queryType(Map<String, TSDataType> dataType) {
        if (MapUtils.isEmpty(dataType)) {
            dataType.putAll(dataTypes);
        } else {
            ArrayList<String> noMatch = new ArrayList<String>();
            for (String headName : dataType.keySet()) {
                if (!dataTypes.containsKey(headName) || dataTypes.get(headName).equals((Object)dataType.get(headName))) continue;
                noMatch.add(headName);
            }
            if (CollectionUtils.isNotEmpty(noMatch)) {
                StringBuilder sb = new StringBuilder();
                for (String match : noMatch) {
                    sb.append(match).append(": rawType(").append(dataType.get(match)).append("), targetType(").append(dataTypes.get(match)).append(");");
                }
                ioTPrinter.println("These columns do not match the column types in the target table\uff1a" + sb.toString());
                System.exit(1);
            }
        }
    }

    static {
        dataTypes = new HashMap<String, TSDataType>();
        columnCategory = new HashMap<String, ColumnCategory>();
    }
}

